/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.result;

import android.app.Activity;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.SMSParsedResult;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.result.ResultHandler;

public final class SMSResultHandler
extends ResultHandler {
    private static final int[] buttons = new int[]{R.string.button_sms, R.string.button_mms};

    public SMSResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        String number = smsResult.getNumbers()[0];
        switch (index) {
            case 0: {
                this.sendSMS(number, smsResult.getBody());
                break;
            }
            case 1: {
                this.sendMMS(number, smsResult.getSubject(), smsResult.getBody());
            }
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        String[] rawNumbers = smsResult.getNumbers();
        String[] formattedNumbers = new String[rawNumbers.length];
        for (int i = 0; i < rawNumbers.length; ++i) {
            formattedNumbers[i] = SMSResultHandler.formatPhone(rawNumbers[i]);
        }
        StringBuilder contents = new StringBuilder(50);
        ParsedResult.maybeAppend((String[])formattedNumbers, (StringBuilder)contents);
        ParsedResult.maybeAppend((String)smsResult.getSubject(), (StringBuilder)contents);
        ParsedResult.maybeAppend((String)smsResult.getBody(), (StringBuilder)contents);
        return contents.toString();
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_sms;
    }
}

