/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.result;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.util.Log;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.result.ResultHandler;
import java.text.DateFormat;

public final class CalendarResultHandler
extends ResultHandler {
    private static final String TAG = CalendarResultHandler.class.getSimpleName();
    private static final int[] buttons = new int[]{R.string.button_add_calendar};

    public CalendarResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        if (index == 0) {
            CalendarParsedResult calendarResult = (CalendarParsedResult)this.getResult();
            String description = calendarResult.getDescription();
            String organizer = calendarResult.getOrganizer();
            if (organizer != null) {
                description = description == null ? organizer : description + '\n' + organizer;
            }
            this.addCalendarEvent(calendarResult.getSummary(), calendarResult.getStartTimestamp(), calendarResult.isStartAllDay(), calendarResult.getEndTimestamp(), calendarResult.getLocation(), description, calendarResult.getAttendees());
        }
    }

    private void addCalendarEvent(String summary, long start, boolean allDay, long end, String location, String description, String[] attendees) {
        Intent intent = new Intent("android.intent.action.INSERT");
        intent.setType("vnd.android.cursor.item/event");
        intent.putExtra("beginTime", start);
        if (allDay) {
            intent.putExtra("allDay", true);
        }
        if (end < 0L) {
            end = allDay ? start + 86400000L : start;
        }
        intent.putExtra("endTime", end);
        intent.putExtra("title", summary);
        intent.putExtra("eventLocation", location);
        intent.putExtra("description", description);
        if (attendees != null) {
            intent.putExtra("android.intent.extra.EMAIL", attendees);
        }
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException anfe) {
            Log.w((String)TAG, (String)"No calendar app available that responds to android.intent.action.INSERT");
            intent.setAction("android.intent.action.EDIT");
            this.launchIntent(intent);
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        CalendarParsedResult calResult = (CalendarParsedResult)this.getResult();
        StringBuilder result = new StringBuilder(100);
        ParsedResult.maybeAppend((String)calResult.getSummary(), (StringBuilder)result);
        long start = calResult.getStartTimestamp();
        ParsedResult.maybeAppend((String)CalendarResultHandler.format(calResult.isStartAllDay(), start), (StringBuilder)result);
        long end = calResult.getEndTimestamp();
        if (end >= 0L) {
            if (calResult.isEndAllDay() && start != end) {
                end -= 86400000L;
            }
            ParsedResult.maybeAppend((String)CalendarResultHandler.format(calResult.isEndAllDay(), end), (StringBuilder)result);
        }
        ParsedResult.maybeAppend((String)calResult.getLocation(), (StringBuilder)result);
        ParsedResult.maybeAppend((String)calResult.getOrganizer(), (StringBuilder)result);
        ParsedResult.maybeAppend((String[])calResult.getAttendees(), (StringBuilder)result);
        ParsedResult.maybeAppend((String)calResult.getDescription(), (StringBuilder)result);
        return result.toString();
    }

    private static String format(boolean allDay, long date) {
        if (date < 0L) {
            return null;
        }
        DateFormat format = allDay ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2);
        return format.format(date);
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_calendar;
    }
}

