/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.encode;

import com.vhall.zxing.client.android.encode.ContactEncoder;
import com.vhall.zxing.client.android.encode.VCardFieldFormatter;
import com.vhall.zxing.client.android.encode.VCardTelDisplayFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class VCardContactEncoder
extends ContactEncoder {
    private static final char TERMINATOR = '\n';

    VCardContactEncoder() {
    }

    @Override
    public String[] encode(List<String> names, String organization, List<String> addresses, List<String> phones, List<String> phoneTypes, List<String> emails, List<String> urls, String note) {
        StringBuilder newContents = new StringBuilder(100);
        newContents.append("BEGIN:VCARD").append('\n');
        newContents.append("VERSION:3.0").append('\n');
        StringBuilder newDisplayContents = new StringBuilder(100);
        VCardFieldFormatter fieldFormatter = new VCardFieldFormatter();
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "N", names, 1, null, fieldFormatter, '\n');
        VCardContactEncoder.append(newContents, newDisplayContents, "ORG", organization, fieldFormatter, '\n');
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "ADR", addresses, 1, null, fieldFormatter, '\n');
        List<Map<String, Set<String>>> phoneMetadata = VCardContactEncoder.buildPhoneMetadata(phones, phoneTypes);
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "TEL", phones, Integer.MAX_VALUE, new VCardTelDisplayFormatter(phoneMetadata), new VCardFieldFormatter(phoneMetadata), '\n');
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "EMAIL", emails, Integer.MAX_VALUE, null, fieldFormatter, '\n');
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "URL", urls, Integer.MAX_VALUE, null, fieldFormatter, '\n');
        VCardContactEncoder.append(newContents, newDisplayContents, "NOTE", note, fieldFormatter, '\n');
        newContents.append("END:VCARD").append('\n');
        return new String[]{newContents.toString(), newDisplayContents.toString()};
    }

    private static List<Map<String, Set<String>>> buildPhoneMetadata(Collection<String> phones, List<String> phoneTypes) {
        if (phoneTypes == null || phoneTypes.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Set<String>>> metadataForIndex = new ArrayList<Map<String, Set<String>>>();
        for (int i = 0; i < phones.size(); ++i) {
            if (phoneTypes.size() <= i) {
                metadataForIndex.add(null);
                continue;
            }
            HashMap metadata = new HashMap();
            metadataForIndex.add(metadata);
            HashSet<String> typeTokens = new HashSet<String>();
            metadata.put("TYPE", typeTokens);
            String typeString = phoneTypes.get(i);
            Integer androidType = VCardContactEncoder.maybeIntValue(typeString);
            if (androidType == null) {
                typeTokens.add(typeString);
                continue;
            }
            String purpose = VCardContactEncoder.vCardPurposeLabelForAndroidType(androidType);
            String context = VCardContactEncoder.vCardContextLabelForAndroidType(androidType);
            if (purpose != null) {
                typeTokens.add(purpose);
            }
            if (context == null) continue;
            typeTokens.add(context);
        }
        return metadataForIndex;
    }

    private static Integer maybeIntValue(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static String vCardPurposeLabelForAndroidType(int androidType) {
        switch (androidType) {
            case 4: 
            case 5: 
            case 13: {
                return "fax";
            }
            case 6: 
            case 18: {
                return "pager";
            }
            case 16: {
                return "textphone";
            }
            case 20: {
                return "text";
            }
        }
        return null;
    }

    private static String vCardContextLabelForAndroidType(int androidType) {
        switch (androidType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return "home";
            }
            case 3: 
            case 4: 
            case 10: 
            case 17: 
            case 18: {
                return "work";
            }
        }
        return null;
    }
}

