/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.encode;

import com.vhall.zxing.client.android.encode.ContactEncoder;
import com.vhall.zxing.client.android.encode.Formatter;
import java.util.List;
import java.util.regex.Pattern;

final class MECARDContactEncoder
extends ContactEncoder {
    private static final char TERMINATOR = ';';

    MECARDContactEncoder() {
    }

    @Override
    public String[] encode(List<String> names, String organization, List<String> addresses, List<String> phones, List<String> phoneTypes, List<String> emails, List<String> urls, String note) {
        StringBuilder newContents = new StringBuilder(100);
        newContents.append("MECARD:");
        StringBuilder newDisplayContents = new StringBuilder(100);
        MECARDFieldFormatter fieldFormatter = new MECARDFieldFormatter();
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "N", names, 1, new MECARDNameDisplayFormatter(), fieldFormatter, ';');
        MECARDContactEncoder.append(newContents, newDisplayContents, "ORG", organization, fieldFormatter, ';');
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "ADR", addresses, 1, null, fieldFormatter, ';');
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "TEL", phones, Integer.MAX_VALUE, new MECARDTelDisplayFormatter(), fieldFormatter, ';');
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "EMAIL", emails, Integer.MAX_VALUE, null, fieldFormatter, ';');
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "URL", urls, Integer.MAX_VALUE, null, fieldFormatter, ';');
        MECARDContactEncoder.append(newContents, newDisplayContents, "NOTE", note, fieldFormatter, ';');
        newContents.append(';');
        return new String[]{newContents.toString(), newDisplayContents.toString()};
    }

    private static final class MECARDNameDisplayFormatter
    implements Formatter {
        private static final Pattern COMMA = Pattern.compile(",");

        private MECARDNameDisplayFormatter() {
        }

        @Override
        public CharSequence format(CharSequence value, int index) {
            return COMMA.matcher(value).replaceAll("");
        }
    }

    private static final class MECARDTelDisplayFormatter
    implements Formatter {
        private static final Pattern NOT_DIGITS_OR_PLUS = Pattern.compile("[^0-9+]+");

        private MECARDTelDisplayFormatter() {
        }

        @Override
        public CharSequence format(CharSequence value, int index) {
            return NOT_DIGITS_OR_PLUS.matcher(ContactEncoder.formatPhone(value.toString())).replaceAll("");
        }
    }

    private static final class MECARDFieldFormatter
    implements Formatter {
        private static final Pattern RESERVED_MECARD_CHARS = Pattern.compile("([\\\\:;])");
        private static final Pattern NEWLINE = Pattern.compile("\\n");

        private MECARDFieldFormatter() {
        }

        @Override
        public CharSequence format(CharSequence value, int index) {
            return ':' + NEWLINE.matcher(RESERVED_MECARD_CHARS.matcher(value).replaceAll("\\\\$1")).replaceAll("");
        }
    }
}

