/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.book;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.vhall.zxing.client.android.HttpHelper;
import com.vhall.zxing.client.android.LocaleManager;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.book.BrowseBookListener;
import com.vhall.zxing.client.android.book.SearchBookContentsAdapter;
import com.vhall.zxing.client.android.book.SearchBookContentsResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class SearchBookContentsActivity
extends Activity {
    private static final String TAG = SearchBookContentsActivity.class.getSimpleName();
    private static final Pattern TAG_PATTERN = Pattern.compile("<.*?>");
    private static final Pattern LT_ENTITY_PATTERN = Pattern.compile("&lt;");
    private static final Pattern GT_ENTITY_PATTERN = Pattern.compile("&gt;");
    private static final Pattern QUOTE_ENTITY_PATTERN = Pattern.compile("&#39;");
    private static final Pattern QUOT_ENTITY_PATTERN = Pattern.compile("&quot;");
    private String isbn;
    private EditText queryTextView;
    private View queryButton;
    private ListView resultListView;
    private TextView headerView;
    private AsyncTask<String, ?, ?> networkTask;
    private final View.OnClickListener buttonListener = new View.OnClickListener(){

        public void onClick(View view) {
            SearchBookContentsActivity.this.launchSearch();
        }
    };
    private final View.OnKeyListener keyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (keyCode == 66 && event.getAction() == 0) {
                SearchBookContentsActivity.this.launchSearch();
                return true;
            }
            return false;
        }
    };

    String getISBN() {
        return this.isbn;
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Intent intent = this.getIntent();
        if (intent == null || !"com.google.zxing.client.android.SEARCH_BOOK_CONTENTS".equals(intent.getAction())) {
            this.finish();
            return;
        }
        this.isbn = intent.getStringExtra("ISBN");
        if (this.isbn == null) {
            this.finish();
            return;
        }
        if (LocaleManager.isBookSearchUrl(this.isbn)) {
            this.setTitle(this.getString(R.string.sbc_name));
        } else {
            this.setTitle(this.getString(R.string.sbc_name) + ": ISBN " + this.isbn);
        }
        this.setContentView(R.layout.search_book_contents);
        this.queryTextView = (EditText)this.findViewById(R.id.query_text_view);
        String initialQuery = intent.getStringExtra("QUERY");
        if (initialQuery != null && !initialQuery.isEmpty()) {
            this.queryTextView.setText((CharSequence)initialQuery);
        }
        this.queryTextView.setOnKeyListener(this.keyListener);
        this.queryButton = this.findViewById(R.id.query_button);
        this.queryButton.setOnClickListener(this.buttonListener);
        this.resultListView = (ListView)this.findViewById(R.id.result_list_view);
        LayoutInflater factory = LayoutInflater.from((Context)this);
        this.headerView = (TextView)factory.inflate(R.layout.search_book_contents_header, (ViewGroup)this.resultListView, false);
        this.resultListView.addHeaderView((View)this.headerView);
    }

    protected void onResume() {
        super.onResume();
        this.queryTextView.selectAll();
    }

    protected void onPause() {
        AsyncTask<String, ?, ?> oldTask = this.networkTask;
        if (oldTask != null) {
            oldTask.cancel(true);
            this.networkTask = null;
        }
        super.onPause();
    }

    private void launchSearch() {
        String query = this.queryTextView.getText().toString();
        if (query != null && !query.isEmpty()) {
            AsyncTask<String, ?, ?> oldTask = this.networkTask;
            if (oldTask != null) {
                oldTask.cancel(true);
            }
            this.networkTask = new NetworkTask();
            this.networkTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[]{query, this.isbn});
            this.headerView.setText(R.string.msg_sbc_searching_book);
            this.resultListView.setAdapter(null);
            this.queryTextView.setEnabled(false);
            this.queryButton.setEnabled(false);
        }
    }

    private final class NetworkTask
    extends AsyncTask<String, Object, JSONObject> {
        private NetworkTask() {
        }

        protected JSONObject doInBackground(String ... args) {
            try {
                String uri;
                String theQuery = args[0];
                String theIsbn = args[1];
                if (LocaleManager.isBookSearchUrl(theIsbn)) {
                    int equals = theIsbn.indexOf(61);
                    String volumeId = theIsbn.substring(equals + 1);
                    uri = "http://www.google.com/books?id=" + volumeId + "&jscmd=SearchWithinVolume2&q=" + theQuery;
                } else {
                    uri = "http://www.google.com/books?vid=isbn" + theIsbn + "&jscmd=SearchWithinVolume2&q=" + theQuery;
                }
                CharSequence content = HttpHelper.downloadViaHttp(uri, HttpHelper.ContentType.JSON);
                return new JSONObject(content.toString());
            }
            catch (IOException | JSONException ioe) {
                Log.w((String)TAG, (String)"Error accessing book search", (Throwable)ioe);
                return null;
            }
        }

        protected void onPostExecute(JSONObject result) {
            if (result == null) {
                SearchBookContentsActivity.this.headerView.setText(R.string.msg_sbc_failed);
            } else {
                this.handleSearchResults(result);
            }
            SearchBookContentsActivity.this.queryTextView.setEnabled(true);
            SearchBookContentsActivity.this.queryTextView.selectAll();
            SearchBookContentsActivity.this.queryButton.setEnabled(true);
        }

        private void handleSearchResults(JSONObject json) {
            try {
                int count = json.getInt("number_of_results");
                SearchBookContentsActivity.this.headerView.setText((CharSequence)(SearchBookContentsActivity.this.getString(R.string.msg_sbc_results) + " : " + count));
                if (count > 0) {
                    JSONArray results = json.getJSONArray("search_results");
                    SearchBookContentsResult.setQuery(SearchBookContentsActivity.this.queryTextView.getText().toString());
                    ArrayList<SearchBookContentsResult> items = new ArrayList<SearchBookContentsResult>(count);
                    for (int x = 0; x < count; ++x) {
                        items.add(this.parseResult(results.getJSONObject(x)));
                    }
                    SearchBookContentsActivity.this.resultListView.setOnItemClickListener((AdapterView.OnItemClickListener)new BrowseBookListener(SearchBookContentsActivity.this, items));
                    SearchBookContentsActivity.this.resultListView.setAdapter((ListAdapter)new SearchBookContentsAdapter((Context)SearchBookContentsActivity.this, items));
                } else {
                    String searchable = json.optString("searchable");
                    if ("false".equals(searchable)) {
                        SearchBookContentsActivity.this.headerView.setText(R.string.msg_sbc_book_not_searchable);
                    }
                    SearchBookContentsActivity.this.resultListView.setAdapter(null);
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"Bad JSON from book search", (Throwable)e);
                SearchBookContentsActivity.this.resultListView.setAdapter(null);
                SearchBookContentsActivity.this.headerView.setText(R.string.msg_sbc_failed);
            }
        }

        private SearchBookContentsResult parseResult(JSONObject json) {
            boolean valid;
            String snippet;
            String pageNumber;
            String pageId;
            try {
                pageId = json.getString("page_id");
                pageNumber = json.optString("page_number");
                snippet = json.optString("snippet_text");
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
                return new SearchBookContentsResult(SearchBookContentsActivity.this.getString(R.string.msg_sbc_no_page_returned), "", "", false);
            }
            pageNumber = pageNumber == null || pageNumber.isEmpty() ? "" : SearchBookContentsActivity.this.getString(R.string.msg_sbc_page) + ' ' + pageNumber;
            boolean bl = valid = snippet != null && !snippet.isEmpty();
            if (valid) {
                snippet = TAG_PATTERN.matcher(snippet).replaceAll("");
                snippet = LT_ENTITY_PATTERN.matcher(snippet).replaceAll("<");
                snippet = GT_ENTITY_PATTERN.matcher(snippet).replaceAll(">");
                snippet = QUOTE_ENTITY_PATTERN.matcher(snippet).replaceAll("'");
                snippet = QUOT_ENTITY_PATTERN.matcher(snippet).replaceAll("\"");
            } else {
                snippet = '(' + SearchBookContentsActivity.this.getString(R.string.msg_sbc_snippet_unavailable) + ')';
            }
            return new SearchBookContentsResult(pageId, pageNumber, snippet, valid);
        }
    }
}

