/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.util.Log;
import java.util.concurrent.RejectedExecutionException;

final class InactivityTimer {
    private static final String TAG = InactivityTimer.class.getSimpleName();
    private static final long INACTIVITY_DELAY_MS = 300000L;
    private final Activity activity;
    private final BroadcastReceiver powerStatusReceiver;
    private boolean registered;
    private AsyncTask<Object, Object, Object> inactivityTask;

    InactivityTimer(Activity activity) {
        this.activity = activity;
        this.powerStatusReceiver = new PowerStatusReceiver();
        this.registered = false;
        this.onActivity();
    }

    synchronized void onActivity() {
        this.cancel();
        this.inactivityTask = new InactivityAsyncTask();
        try {
            this.inactivityTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
        }
        catch (RejectedExecutionException ree) {
            Log.w((String)TAG, (String)"Couldn't schedule inactivity task; ignoring");
        }
    }

    synchronized void onPause() {
        this.cancel();
        if (this.registered) {
            this.activity.unregisterReceiver(this.powerStatusReceiver);
            this.registered = false;
        } else {
            Log.w((String)TAG, (String)"PowerStatusReceiver was never registered?");
        }
    }

    synchronized void onResume() {
        if (this.registered) {
            Log.w((String)TAG, (String)"PowerStatusReceiver was already registered?");
        } else {
            this.activity.registerReceiver(this.powerStatusReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            this.registered = true;
        }
        this.onActivity();
    }

    private synchronized void cancel() {
        AsyncTask<Object, Object, Object> task = this.inactivityTask;
        if (task != null) {
            task.cancel(true);
            this.inactivityTask = null;
        }
    }

    void shutdown() {
        this.cancel();
    }

    private final class InactivityAsyncTask
    extends AsyncTask<Object, Object, Object> {
        private InactivityAsyncTask() {
        }

        protected Object doInBackground(Object ... objects) {
            try {
                Thread.sleep(300000L);
                Log.i((String)TAG, (String)"Finishing activity due to inactivity");
                InactivityTimer.this.activity.finish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }

    private final class PowerStatusReceiver
    extends BroadcastReceiver {
        private PowerStatusReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                boolean onBatteryNow;
                boolean bl = onBatteryNow = intent.getIntExtra("plugged", -1) <= 0;
                if (onBatteryNow) {
                    InactivityTimer.this.onActivity();
                } else {
                    InactivityTimer.this.cancel();
                }
            }
        }
    }
}

