/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class HttpHelper {
    private static final Collection<String> REDIRECTOR_DOMAINS = new HashSet<String>(Arrays.asList("amzn.to", "bit.ly", "bitly.com", "fb.me", "goo.gl", "is.gd", "j.mp", "lnkd.in", "ow.ly", "R.BEETAGG.COM", "r.beetagg.com", "SCN.BY", "su.pr", "t.co", "tinyurl.com", "tr.im"));

    private HttpHelper() {
    }

    public static CharSequence downloadViaHttp(String uri, ContentType type) throws IOException {
        return HttpHelper.downloadViaHttp(uri, type, Integer.MAX_VALUE);
    }

    public static CharSequence downloadViaHttp(String uri, ContentType type, int maxChars) throws IOException {
        String contentTypes;
        switch (type) {
            case HTML: {
                contentTypes = "application/xhtml+xml,text/html,text/*,*/*";
                break;
            }
            case JSON: {
                contentTypes = "application/json,text/*,*/*";
                break;
            }
            case XML: {
                contentTypes = "application/xml,text/*,*/*";
                break;
            }
            default: {
                contentTypes = "text/*,*/*";
            }
        }
        return HttpHelper.downloadViaHttp(uri, contentTypes, maxChars);
    }

    private static CharSequence downloadViaHttp(String uri, String contentTypes, int maxChars) throws IOException {
        int redirects = 0;
        block9: while (redirects < 5) {
            URL url = new URL(uri);
            HttpURLConnection connection = HttpHelper.safelyOpenConnection(url);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Accept", contentTypes);
            connection.setRequestProperty("Accept-Charset", "utf-8,*");
            connection.setRequestProperty("User-Agent", "ZXing (Android)");
            try {
                int responseCode = HttpHelper.safelyConnect(connection);
                switch (responseCode) {
                    case 200: {
                        CharSequence charSequence = HttpHelper.consume(connection, maxChars);
                        return charSequence;
                    }
                    case 302: {
                        String location = connection.getHeaderField("Location");
                        if (location != null) {
                            uri = location;
                            ++redirects;
                            continue block9;
                        }
                        throw new IOException("No Location");
                    }
                }
                throw new IOException("Bad HTTP response: " + responseCode);
            }
            finally {
                connection.disconnect();
            }
        }
        throw new IOException("Too many redirects");
    }

    private static String getEncoding(URLConnection connection) {
        int charsetStart;
        String contentTypeHeader = connection.getHeaderField("Content-Type");
        if (contentTypeHeader != null && (charsetStart = contentTypeHeader.indexOf("charset=")) >= 0) {
            return contentTypeHeader.substring(charsetStart + "charset=".length());
        }
        return "UTF-8";
    }

    private static CharSequence consume(URLConnection connection, int maxChars) throws IOException {
        String encoding = HttpHelper.getEncoding(connection);
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(connection.getInputStream(), encoding);){
            int charsRead;
            char[] buffer = new char[1024];
            while (out.length() < maxChars && (charsRead = in.read(buffer)) > 0) {
                out.append(buffer, 0, charsRead);
            }
        }
        return out;
    }

    /*
     * Exception decompiling
     */
    public static URI unredirect(URI uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 4[CASE]], but top level block is 6[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static HttpURLConnection safelyOpenConnection(URL url) throws IOException {
        URLConnection conn;
        try {
            conn = url.openConnection();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Expected HttpURLConnection but got " + conn.getClass());
        }
        return (HttpURLConnection)conn;
    }

    private static int safelyConnect(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        try {
            return connection.getResponseCode();
        }
        catch (IllegalArgumentException | NullPointerException | StringIndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    public static enum ContentType {
        HTML,
        JSON,
        XML,
        TEXT;

    }
}

