/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.vhall.zxing.client.android.AmbientLightManager;
import com.vhall.zxing.client.android.BeepManager;
import com.vhall.zxing.client.android.CaptureActivityHandler;
import com.vhall.zxing.client.android.DecodeFormatManager;
import com.vhall.zxing.client.android.DecodeHintManager;
import com.vhall.zxing.client.android.FinishListener;
import com.vhall.zxing.client.android.HelpActivity;
import com.vhall.zxing.client.android.InactivityTimer;
import com.vhall.zxing.client.android.IntentSource;
import com.vhall.zxing.client.android.PreferencesActivity;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.ScanFromWebPageManager;
import com.vhall.zxing.client.android.ViewfinderView;
import com.vhall.zxing.client.android.camera.CameraManager;
import com.vhall.zxing.client.android.clipboard.ClipboardInterface;
import com.vhall.zxing.client.android.history.HistoryActivity;
import com.vhall.zxing.client.android.history.HistoryItem;
import com.vhall.zxing.client.android.history.HistoryManager;
import com.vhall.zxing.client.android.result.ResultButtonListener;
import com.vhall.zxing.client.android.result.ResultHandler;
import com.vhall.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import com.vhall.zxing.client.android.share.ShareActivity;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;

public final class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final String TAG = CaptureActivity.class.getSimpleName();
    private static final long DEFAULT_INTENT_RESULT_DURATION_MS = 1500L;
    private static final long BULK_MODE_SCAN_DELAY_MS = 1000L;
    private static final String[] ZXING_URLS = new String[]{"http://zxing.appspot.com/scan", "zxing://scan/"};
    private static final int HISTORY_REQUEST_CODE = 47820;
    private static final Collection<ResultMetadataType> DISPLAYABLE_METADATA_TYPES = EnumSet.of(ResultMetadataType.ISSUE_NUMBER, ResultMetadataType.SUGGESTED_PRICE, ResultMetadataType.ERROR_CORRECTION_LEVEL, ResultMetadataType.POSSIBLE_COUNTRY);
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private Result savedResultToShow;
    private ViewfinderView viewfinderView;
    private TextView statusView;
    private View resultView;
    private Result lastResult;
    private boolean hasSurface;
    private boolean copyToClipboard;
    private IntentSource source;
    private String sourceUrl;
    private ScanFromWebPageManager scanFromWebPageManager;
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, ?> decodeHints;
    private String characterSet;
    private HistoryManager historyManager;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private AmbientLightManager ambientLightManager;

    ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Window window = this.getWindow();
        window.addFlags(128);
        this.setContentView(R.layout.capture);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        this.beepManager = new BeepManager(this);
        this.ambientLightManager = new AmbientLightManager((Context)this);
        PreferenceManager.setDefaultValues((Context)this, (int)R.xml.preferences, (boolean)false);
    }

    protected void onResume() {
        super.onResume();
        this.historyManager = new HistoryManager(this);
        this.historyManager.trimHistory();
        this.cameraManager = new CameraManager((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.resultView = this.findViewById(R.id.result_view);
        this.statusView = (TextView)this.findViewById(R.id.status_view);
        this.handler = null;
        this.lastResult = null;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (prefs.getBoolean("preferences_orientation", true)) {
            this.setRequestedOrientation(this.getCurrentOrientation());
        } else {
            this.setRequestedOrientation(6);
        }
        this.resetStatusView();
        this.beepManager.updatePrefs();
        this.ambientLightManager.start(this.cameraManager);
        this.inactivityTimer.onResume();
        Intent intent = this.getIntent();
        this.copyToClipboard = prefs.getBoolean("preferences_copy_to_clipboard", true) && (intent == null || intent.getBooleanExtra("SAVE_HISTORY", true));
        this.source = IntentSource.NONE;
        this.sourceUrl = null;
        this.scanFromWebPageManager = null;
        this.decodeFormats = null;
        this.characterSet = null;
        if (intent != null) {
            String action = intent.getAction();
            String dataString = intent.getDataString();
            if ("com.google.zxing.client.android.SCAN".equals(action)) {
                String customPromptMessage;
                int cameraId;
                this.source = IntentSource.NATIVE_APP_INTENT;
                this.decodeFormats = DecodeFormatManager.parseDecodeFormats(intent);
                this.decodeHints = DecodeHintManager.parseDecodeHints(intent);
                if (intent.hasExtra("SCAN_WIDTH") && intent.hasExtra("SCAN_HEIGHT")) {
                    int width = intent.getIntExtra("SCAN_WIDTH", 0);
                    int height = intent.getIntExtra("SCAN_HEIGHT", 0);
                    if (width > 0 && height > 0) {
                        this.cameraManager.setManualFramingRect(width, height);
                    }
                }
                if (intent.hasExtra("SCAN_CAMERA_ID") && (cameraId = intent.getIntExtra("SCAN_CAMERA_ID", -1)) >= 0) {
                    this.cameraManager.setManualCameraId(cameraId);
                }
                if ((customPromptMessage = intent.getStringExtra("PROMPT_MESSAGE")) != null) {
                    this.statusView.setText((CharSequence)customPromptMessage);
                }
            } else if (dataString != null && dataString.contains("http://www.google") && dataString.contains("/m/products/scan")) {
                this.source = IntentSource.PRODUCT_SEARCH_LINK;
                this.sourceUrl = dataString;
                this.decodeFormats = DecodeFormatManager.PRODUCT_FORMATS;
            } else if (CaptureActivity.isZXingURL(dataString)) {
                this.source = IntentSource.ZXING_LINK;
                this.sourceUrl = dataString;
                Uri inputUri = Uri.parse((String)dataString);
                this.scanFromWebPageManager = new ScanFromWebPageManager(inputUri);
                this.decodeFormats = DecodeFormatManager.parseDecodeFormats(inputUri);
                this.decodeHints = DecodeHintManager.parseDecodeHints(inputUri);
            }
            this.characterSet = intent.getStringExtra("CHARACTER_SET");
        }
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    private int getCurrentOrientation() {
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        if (this.getResources().getConfiguration().orientation == 2) {
            switch (rotation) {
                case 0: 
                case 1: {
                    return 0;
                }
            }
            return 8;
        }
        switch (rotation) {
            case 0: 
            case 3: {
                return 1;
            }
        }
        return 9;
    }

    private static boolean isZXingURL(String dataString) {
        if (dataString == null) {
            return false;
        }
        for (String url : ZXING_URLS) {
            if (!dataString.startsWith(url)) continue;
            return true;
        }
        return false;
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.ambientLightManager.stop();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.source == IntentSource.NATIVE_APP_INTENT) {
                    this.setResult(0);
                    this.finish();
                    return true;
                }
                if (this.source != IntentSource.NONE && this.source != IntentSource.ZXING_LINK || this.lastResult == null) break;
                this.restartPreviewAfterDelay(0L);
                return true;
            }
            case 27: 
            case 80: {
                return true;
            }
            case 25: {
                this.cameraManager.setTorch(false);
                return true;
            }
            case 24: {
                this.cameraManager.setTorch(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.capture, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(524288);
        int itemId = item.getItemId();
        if (itemId == R.id.menu_share) {
            intent.setClassName((Context)this, ShareActivity.class.getName());
            this.startActivity(intent);
        } else if (itemId == R.id.menu_history) {
            intent.setClassName((Context)this, HistoryActivity.class.getName());
            this.startActivityForResult(intent, 47820);
        } else if (itemId == R.id.menu_settings) {
            intent.setClassName((Context)this, PreferencesActivity.class.getName());
            this.startActivity(intent);
        } else if (itemId == R.id.menu_help) {
            intent.setClassName((Context)this, HelpActivity.class.getName());
            this.startActivity(intent);
        } else {
            return super.onOptionsItemSelected(item);
        }
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        int itemNumber;
        if (resultCode == -1 && requestCode == 47820 && this.historyManager != null && (itemNumber = intent.getIntExtra("ITEM_NUMBER", -1)) >= 0) {
            HistoryItem historyItem = this.historyManager.buildHistoryItem(itemNumber);
            this.decodeOrStoreSavedBitmap(null, historyItem.getResult());
        }
    }

    private void decodeOrStoreSavedBitmap(Bitmap bitmap, Result result) {
        if (this.handler == null) {
            this.savedResultToShow = result;
        } else {
            if (result != null) {
                this.savedResultToShow = result;
            }
            if (this.savedResultToShow != null) {
                Message message = Message.obtain((Handler)this.handler, (int)R.id.decode_succeeded, (Object)this.savedResultToShow);
                this.handler.sendMessage(message);
            }
            this.savedResultToShow = null;
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            Log.e((String)TAG, (String)"*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void handleDecode(Result rawResult, Bitmap barcode, float scaleFactor) {
        this.inactivityTimer.onActivity();
        this.lastResult = rawResult;
        Intent intent1 = new Intent();
        intent1.putExtra("qrcode", rawResult.getText().toString());
        this.setResult(-1, intent1);
        this.finish();
    }

    private void drawResultPoints(Bitmap barcode, float scaleFactor, Result rawResult) {
        ResultPoint[] points = rawResult.getResultPoints();
        if (points != null && points.length > 0) {
            Canvas canvas = new Canvas(barcode);
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(R.color.result_points));
            if (points.length == 2) {
                paint.setStrokeWidth(4.0f);
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
            } else if (points.length == 4 && (rawResult.getBarcodeFormat() == BarcodeFormat.UPC_A || rawResult.getBarcodeFormat() == BarcodeFormat.EAN_13)) {
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
                CaptureActivity.drawLine(canvas, paint, points[2], points[3], scaleFactor);
            } else {
                paint.setStrokeWidth(10.0f);
                for (ResultPoint point : points) {
                    if (point == null) continue;
                    canvas.drawPoint(scaleFactor * point.getX(), scaleFactor * point.getY(), paint);
                }
            }
        }
    }

    private static void drawLine(Canvas canvas, Paint paint, ResultPoint a, ResultPoint b, float scaleFactor) {
        if (a != null && b != null) {
            canvas.drawLine(scaleFactor * a.getX(), scaleFactor * a.getY(), scaleFactor * b.getX(), scaleFactor * b.getY(), paint);
        }
    }

    private void handleDecodeInternally(Result rawResult, ResultHandler resultHandler, Bitmap barcode) {
        this.maybeSetClipboard(resultHandler);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (resultHandler.getDefaultButtonID() != null && prefs.getBoolean("preferences_auto_open_web", false)) {
            resultHandler.handleButtonPress(resultHandler.getDefaultButtonID());
            return;
        }
        this.statusView.setVisibility(8);
        this.viewfinderView.setVisibility(8);
        this.resultView.setVisibility(0);
        ImageView barcodeImageView = (ImageView)this.findViewById(R.id.barcode_image_view);
        if (barcode == null) {
            barcodeImageView.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.launcher_icon));
        } else {
            barcodeImageView.setImageBitmap(barcode);
        }
        TextView formatTextView = (TextView)this.findViewById(R.id.format_text_view);
        formatTextView.setText((CharSequence)rawResult.getBarcodeFormat().toString());
        TextView typeTextView = (TextView)this.findViewById(R.id.type_text_view);
        typeTextView.setText((CharSequence)resultHandler.getType().toString());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        TextView timeTextView = (TextView)this.findViewById(R.id.time_text_view);
        timeTextView.setText((CharSequence)formatter.format(rawResult.getTimestamp()));
        TextView metaTextView = (TextView)this.findViewById(R.id.meta_text_view);
        View metaTextViewLabel = this.findViewById(R.id.meta_text_view_label);
        metaTextView.setVisibility(8);
        metaTextViewLabel.setVisibility(8);
        Map metadata = rawResult.getResultMetadata();
        if (metadata != null) {
            StringBuilder metadataText = new StringBuilder(20);
            for (Map.Entry entry : metadata.entrySet()) {
                if (!DISPLAYABLE_METADATA_TYPES.contains(entry.getKey())) continue;
                metadataText.append(entry.getValue()).append('\n');
            }
            if (metadataText.length() > 0) {
                metadataText.setLength(metadataText.length() - 1);
                metaTextView.setText((CharSequence)metadataText);
                metaTextView.setVisibility(0);
                metaTextViewLabel.setVisibility(0);
            }
        }
        CharSequence displayContents = resultHandler.getDisplayContents();
        TextView contentsTextView = (TextView)this.findViewById(R.id.contents_text_view);
        contentsTextView.setText(displayContents);
        int scaledSize = Math.max(22, 32 - displayContents.length() / 4);
        contentsTextView.setTextSize(2, (float)scaledSize);
        TextView supplementTextView = (TextView)this.findViewById(R.id.contents_supplement_text_view);
        supplementTextView.setText((CharSequence)"");
        supplementTextView.setOnClickListener(null);
        if (PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("preferences_supplemental", true)) {
            SupplementalInfoRetriever.maybeInvokeRetrieval(supplementTextView, resultHandler.getResult(), this.historyManager, (Context)this);
        }
        int buttonCount = resultHandler.getButtonCount();
        ViewGroup buttonView = (ViewGroup)this.findViewById(R.id.result_button_view);
        buttonView.requestFocus();
        for (int x = 0; x < 4; ++x) {
            TextView button = (TextView)buttonView.getChildAt(x);
            if (x < buttonCount) {
                button.setVisibility(0);
                button.setText(resultHandler.getButtonText(x));
                button.setOnClickListener((View.OnClickListener)new ResultButtonListener(resultHandler, x));
                continue;
            }
            button.setVisibility(8);
        }
    }

    private void handleDecodeExternally(Result rawResult, ResultHandler resultHandler, Bitmap barcode) {
        long resultDurationMS;
        if (barcode != null) {
            this.viewfinderView.drawResultBitmap(barcode);
        }
        if ((resultDurationMS = this.getIntent() == null ? 1500L : this.getIntent().getLongExtra("RESULT_DISPLAY_DURATION_MS", 1500L)) > 0L) {
            String rawResultString = String.valueOf(rawResult);
            if (rawResultString.length() > 32) {
                rawResultString = rawResultString.substring(0, 32) + " ...";
            }
            this.statusView.setText((CharSequence)(this.getString(resultHandler.getDisplayTitle()) + " : " + rawResultString));
        }
        this.maybeSetClipboard(resultHandler);
        switch (this.source) {
            case NATIVE_APP_INTENT: {
                Map metadata;
                Intent intent = new Intent(this.getIntent().getAction());
                intent.addFlags(524288);
                intent.putExtra("SCAN_RESULT", rawResult.toString());
                intent.putExtra("SCAN_RESULT_FORMAT", rawResult.getBarcodeFormat().toString());
                byte[] rawBytes = rawResult.getRawBytes();
                if (rawBytes != null && rawBytes.length > 0) {
                    intent.putExtra("SCAN_RESULT_BYTES", rawBytes);
                }
                if ((metadata = rawResult.getResultMetadata()) != null) {
                    Iterable byteSegments;
                    String ecLevel;
                    Number orientation;
                    if (metadata.containsKey(ResultMetadataType.UPC_EAN_EXTENSION)) {
                        intent.putExtra("SCAN_RESULT_UPC_EAN_EXTENSION", metadata.get(ResultMetadataType.UPC_EAN_EXTENSION).toString());
                    }
                    if ((orientation = (Number)metadata.get(ResultMetadataType.ORIENTATION)) != null) {
                        intent.putExtra("SCAN_RESULT_ORIENTATION", orientation.intValue());
                    }
                    if ((ecLevel = (String)metadata.get(ResultMetadataType.ERROR_CORRECTION_LEVEL)) != null) {
                        intent.putExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL", ecLevel);
                    }
                    if ((byteSegments = (Iterable)metadata.get(ResultMetadataType.BYTE_SEGMENTS)) != null) {
                        int i = 0;
                        for (byte[] byteSegment : byteSegments) {
                            intent.putExtra("SCAN_RESULT_BYTE_SEGMENTS_" + i, byteSegment);
                            ++i;
                        }
                    }
                }
                this.sendReplyMessage(R.id.return_scan_result, intent, resultDurationMS);
                break;
            }
            case PRODUCT_SEARCH_LINK: {
                int end = this.sourceUrl.lastIndexOf("/scan");
                String productReplyURL = this.sourceUrl.substring(0, end) + "?q=" + resultHandler.getDisplayContents() + "&source=zxing";
                this.sendReplyMessage(R.id.launch_product_query, productReplyURL, resultDurationMS);
                break;
            }
            case ZXING_LINK: {
                if (this.scanFromWebPageManager == null || !this.scanFromWebPageManager.isScanFromWebPage()) break;
                String linkReplyURL = this.scanFromWebPageManager.buildReplyURL(rawResult, resultHandler);
                this.scanFromWebPageManager = null;
                this.sendReplyMessage(R.id.launch_product_query, linkReplyURL, resultDurationMS);
            }
        }
    }

    private void maybeSetClipboard(ResultHandler resultHandler) {
        if (this.copyToClipboard && !resultHandler.areContentsSecure()) {
            ClipboardInterface.setText(resultHandler.getDisplayContents(), (Context)this);
        }
    }

    private void sendReplyMessage(int id2, Object arg, long delayMS) {
        if (this.handler != null) {
            Message message = Message.obtain((Handler)this.handler, (int)id2, (Object)arg);
            if (delayMS > 0L) {
                this.handler.sendMessageDelayed(message, delayMS);
            } else {
                this.handler.sendMessage(message);
            }
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            Log.w((String)TAG, (String)"initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.decodeHints, this.characterSet, this.cameraManager);
            }
            this.decodeOrStoreSavedBitmap(null, null);
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)this.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, (DialogInterface.OnClickListener)new FinishListener(this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener(this));
        builder.show();
    }

    public void restartPreviewAfterDelay(long delayMS) {
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(R.id.restart_preview, delayMS);
        }
        this.resetStatusView();
    }

    private void resetStatusView() {
        this.resultView.setVisibility(8);
        this.statusView.setText(R.string.msg_default_status);
        this.statusView.setVisibility(0);
        this.viewfinderView.setVisibility(0);
        this.lastResult = null;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }
}

