/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField field, PolynomialGF2mSmallM gp) {
        int j;
        int i;
        int m = field.getDegree();
        int n = 1 << m;
        int t = gp.getDegree();
        int[][] hArray = new int[t][n];
        int[][] yz = new int[t][n];
        for (int j2 = 0; j2 < n; ++j2) {
            yz[0][j2] = field.inverse(gp.evaluateAt(j2));
        }
        for (i = 1; i < t; ++i) {
            for (j = 0; j < n; ++j) {
                yz[i][j] = field.mult(yz[i - 1][j], j);
            }
        }
        for (i = 0; i < t; ++i) {
            for (j = 0; j < n; ++j) {
                for (int k = 0; k <= i; ++k) {
                    hArray[i][j] = field.add(hArray[i][j], field.mult(yz[k][j], gp.getCoefficient(t + k - i)));
                }
            }
        }
        int[][] result = new int[t * m][n + 31 >>> 5];
        for (j = 0; j < n; ++j) {
            int q = j >>> 5;
            int r = 1 << (j & 0x1F);
            for (int i2 = 0; i2 < t; ++i2) {
                int e = hArray[i2][j];
                for (int u = 0; u < m; ++u) {
                    int b = e >>> u & 1;
                    if (b == 0) continue;
                    int ind = (i2 + 1) * m - u - 1;
                    int[] nArray = result[ind];
                    int n2 = q;
                    nArray[n2] = nArray[n2] ^ r;
                }
            }
        }
        return new GF2Matrix(n, result);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix h, SecureRandom sr) {
        GF2Matrix sInv;
        GF2Matrix hp;
        Permutation p;
        int n = h.getNumColumns();
        GF2Matrix s = null;
        boolean found = false;
        do {
            p = new Permutation(n, sr);
            hp = (GF2Matrix)h.rightMultiply(p);
            sInv = hp.getLeftSubMatrix();
            try {
                found = true;
                s = (GF2Matrix)sInv.computeInverse();
            }
            catch (ArithmeticException ae) {
                found = false;
            }
        } while (!found);
        GF2Matrix shp = (GF2Matrix)s.rightMultiply(hp);
        GF2Matrix m = shp.getRightSubMatrix();
        return new MaMaPe(sInv, m, p);
    }

    public static GF2Vector syndromeDecode(GF2Vector syndVec, GF2mField field, PolynomialGF2mSmallM gp, PolynomialGF2mSmallM[] sqRootMatrix) {
        int n = 1 << field.getDegree();
        GF2Vector errors = new GF2Vector(n);
        if (!syndVec.isZero()) {
            PolynomialGF2mSmallM syndrome = new PolynomialGF2mSmallM(syndVec.toExtensionFieldVector(field));
            PolynomialGF2mSmallM t = syndrome.modInverse(gp);
            PolynomialGF2mSmallM tau = t.addMonomial(1);
            tau = tau.modSquareRootMatrix(sqRootMatrix);
            PolynomialGF2mSmallM[] ab = tau.modPolynomialToFracton(gp);
            PolynomialGF2mSmallM a2 = ab[0].multiply(ab[0]);
            PolynomialGF2mSmallM b2 = ab[1].multiply(ab[1]);
            PolynomialGF2mSmallM xb2 = b2.multWithMonomial(1);
            PolynomialGF2mSmallM a2plusXb2 = a2.add(xb2);
            int headCoeff = a2plusXb2.getHeadCoefficient();
            int invHeadCoeff = field.inverse(headCoeff);
            PolynomialGF2mSmallM elp = a2plusXb2.multWithElement(invHeadCoeff);
            for (int i = 0; i < n; ++i) {
                int z = elp.evaluateAt(i);
                if (z != 0) continue;
                errors.setBit(i);
            }
        }
        return errors;
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix g, int[] setJ) {
            this.g = g;
            this.setJ = setJ;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix s, GF2Matrix h, Permutation p) {
            this.s = s;
            this.h = h;
            this.p = p;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }
}

