/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.utils.rxutils;

import android.text.TextUtils;
import com.vhall.logmanager.VLog;
import java.util.HashMap;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;

public class BasePresenter {
    protected static String vssToken = null;
    protected static String roomId = null;
    protected static ResponseRoomInfo roomInfo = new ResponseRoomInfo();

    public String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        return String.format("%s%s%s", VssApiConstant.API_HOST, VssApiConstant.API_AREA, api);
    }

    public HashMap<String, String> getDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, String> param = new HashMap<String, String>(size + 3);
        if (!TextUtils.isEmpty((CharSequence)vssToken)) {
            param.put("vss_token", vssToken);
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            param.put("room_id", roomId);
        }
        param.put("app_id", VssSdk.getInstance().getAppId());
        param.put("from", "android_app");
        param.put("client_version", VssSdk.getInstance().getClient_version());
        return param;
    }

    public HashMap<String, Object> getObjectDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, Object> param = new HashMap<String, Object>(size);
        if (!TextUtils.isEmpty((CharSequence)vssToken)) {
            param.put("vss_token", vssToken);
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            param.put("room_id", roomId);
        }
        return param;
    }

    public void dealError(Throwable e, CallBack callback, String tag) {
        String msg;
        if (callback == null) {
            return;
        }
        if (e instanceof ApiException) {
            ApiException exception = CustomException.handleException(-1, e);
            if (TextUtils.isEmpty((CharSequence)exception.getDisplayMessage())) {
                callback.onError(exception.getCode(), exception.getMessage());
                msg = exception.getMessage();
            } else {
                callback.onError(exception.getCode(), exception.getDisplayMessage());
                msg = exception.getDisplayMessage();
            }
        } else {
            callback.onError(-1, e.getMessage());
            msg = e.getMessage();
        }
        VLog.e((String)tag, (String)msg);
    }
}

