/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.net;

import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseJe;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;

public class VssNetCallback<T>
implements IVHNetCallback {
    private CallBack callback;
    private Class<T> clz;

    public VssNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public VssNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    public void onFailure(VHNetResponse response, Exception e) {
        if (this.callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            this.callback.onError(exception.getCode(), exception.getMessage());
        }
    }

    public void response(VHNetResponse response) {
        if (this.callback != null && response != null) {
            ResponseJe<T> data = new ResponseJe<T>(response.getResult(), this.clz);
            if (data.getCode() != 200) {
                this.callback.onError(data.getCode(), data.getMsg());
                return;
            }
            if (null != this.clz) {
                this.callback.onSuccess(data.getData());
            } else {
                this.callback.onSuccess(response.getResult());
            }
        }
    }
}

