/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.module.rtc;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.logmanager.VLog;
import java.util.HashMap;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

public class VssRtcManager
extends BasePresenter {
    private static String TAG = "VssRtcManager";
    private static volatile VssRtcManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssRtcManager getInstance() {
        if (roomInfo == null) {
            VLog.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssRtcManager> clazz = VssRtcManager.class;
        synchronized (VssRtcManager.class) {
            if (instance != null) return instance;
            instance = new VssRtcManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setDeviceStatus(String device, String status, CallBack callBack) {
        this.setDeviceStatus(device, status, "", callBack);
    }

    public void setDeviceStatus(String device, String status, String userId, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("device", device);
        params.put("status", status);
        if (TextUtils.isEmpty((CharSequence)userId)) {
            params.put("receive_account_id", roomInfo.getThird_party_user_id());
            if (!VssRoleManager.getInstance().canOpenCameraVoice()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u5f00\u5173\u81ea\u5df1\u7684\u97f3\u89c6\u9891\u6743\u9650");
                }
                VLog.e((String)TAG, (String)"\u6ca1\u6709\u5f00\u5173\u81ea\u5df1\u7684\u97f3\u89c6\u9891\u6743\u9650");
                return;
            }
        } else {
            if (!VssRoleManager.getInstance().canChangeOtherVoiceCamera()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u5f00\u5173\u522b\u4eba\u7684\u97f3\u89c6\u9891\u6743\u9650");
                }
                VLog.e((String)TAG, (String)"\u6ca1\u6709\u5f00\u5173\u522b\u4eba\u7684\u97f3\u89c6\u9891\u6743\u9650");
                return;
            }
            params.put("receive_account_id", userId);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-device-status")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setStream(String layout, String definition, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("layout", layout);
        params.put("definition", definition);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-stream")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void apply(CallBack callBack) {
        if (!VssRoleManager.getInstance().canApplySpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u7533\u8bf7\u4e0a\u9ea6\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u7533\u8bf7\u4e0a\u9ea6\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/apply")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void rejectInvite(CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("account_id", roomInfo.getThird_party_user_id());
        params.put("receive_account_id", String.valueOf(roomInfo.getAccount_id()));
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/reject-invite")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void cancelApply(CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("account_id", roomInfo.getThird_party_user_id());
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/cancel-apply")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void agreeInvite(CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", String.valueOf(roomInfo.getAccount_id()));
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/agree-invite")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void unpublish(String id, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        if (TextUtils.isEmpty((CharSequence)id)) {
            if (!VssRoleManager.getInstance().canOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u4e0b\u9ea6\u63a7\u5236\u6743\u9650");
                }
                VLog.e((String)TAG, (String)"\u6ca1\u6709\u4e0b\u9ea6\u63a7\u5236\u6743\u9650");
                return;
            }
            params.put("receive_account_id", roomInfo == null ? VssSdk.getInstance().getUserId() : roomInfo.getThird_party_user_id());
        } else {
            if (!VssRoleManager.getInstance().canOperateOtherOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u4e0b\u9ea6\u4ed6\u4eba\u63a7\u5236\u6743\u9650");
                }
                VLog.e((String)TAG, (String)"\u6ca1\u6709\u4e0b\u9ea6\u4ed6\u4eba\u63a7\u5236\u6743\u9650");
                return;
            }
            params.put("receive_account_id", id);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/nospeak")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void agreeApply(String userId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u540c\u610f\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u540c\u610f\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("receive_account_id", userId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/agree-apply")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void rejectApply(String userId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u62d2\u7edd\u7528\u6237\u4e0a\u9ea6\u7533\u8bf7\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u62d2\u7edd\u7528\u6237\u4e0a\u9ea6\u7533\u8bf7\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", userId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/reject-apply")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setHandsUp(String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canRaiseHandSwitch()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8bbe\u7f6e\u4e3e\u624b\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u8bbe\u7f6e\u4e3e\u624b\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-handsup")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void invite(String receiveJoinId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u9080\u8bf7\u7528\u6237\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u9080\u8bf7\u7528\u6237\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/invite")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void publish(CallBack callBack) {
        if (instance == null) {
            return;
        }
        HashMap<String, String> params = instance.getDefaultParam(vssToken, roomId, 3);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/speak")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setBanned(String receiveJoinId, String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatBanned()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u7981\u8a00\u6216\u53d6\u6d88\u7981\u8a00\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u7981\u8a00\u6216\u53d6\u6d88\u7981\u8a00\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-banned")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }
}

