/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.module.question;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import java.util.HashMap;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.CreateQuestionParam;
import vhall.com.vss2.data.VssQuestionListData;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

public class VssQuestionManager
extends BasePresenter {
    private static volatile VssQuestionManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssQuestionManager getInstance() {
        if (instance != null) return instance;
        Class<VssQuestionManager> clazz = VssQuestionManager.class;
        synchronized (VssQuestionManager.class) {
            if (instance != null) return instance;
            instance = new VssQuestionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void questionCreate(CreateQuestionParam createQuestionParam, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 10);
        if (createQuestionParam != null) {
            params.put("title", createQuestionParam.getTitle());
            params.put("definition", createQuestionParam.getDescription());
            params.put("question_id", createQuestionParam.getQuestion_id());
            params.put("cover", createQuestionParam.getCover());
            params.put("extend", createQuestionParam.getExtend());
            params.put("is_public", createQuestionParam.getIs_public());
            params.put("account_id", createQuestionParam.getAccount_id());
            params.put("app_id", createQuestionParam.getApp_id());
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/create")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionAnswer(String answerId, String questionId, String extend, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("answer_id", answerId);
        params.put("question_id", questionId);
        if (!TextUtils.isEmpty((CharSequence)extend)) {
            params.put("extend", extend);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/answer")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionStatisticsList(String page, String pageSize, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("page", page);
        params.put("pagesize", pageSize);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/statistics-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionList(CallBack callBack) {
        this.questionList("", "", "", "", "", callBack);
    }

    public void questionList(String keyword, String publish, String isPublic, String page, String pageSize, CallBack<VssQuestionListData> callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 7);
        params.put("page", page);
        params.put("pagesize", pageSize);
        params.put("keyword", keyword);
        params.put("is_public", isPublic);
        params.put("publish", publish);
        params.put("from_room_id", roomId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionCancelPublish(String vssToken, String roomId, String questionId, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("question_id", questionId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/cancel-publish")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionPublish(String vssToken, String roomId, String questionId, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("question_id", questionId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/publish")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionUpdate(String vssToken, CreateQuestionParam createQuestionParam, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, null, 7);
        params.put("question_id", createQuestionParam.getQuestion_id());
        params.put("definition", createQuestionParam.getDescription());
        params.put("title", createQuestionParam.getTitle());
        params.put("extend", createQuestionParam.getExtend());
        params.put("cover", createQuestionParam.getCover());
        params.put("account_id", createQuestionParam.getAccount_id());
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/update")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionWatchList(String vssToken, String roomId, String keyword, String page, String pageSize, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("keyword", keyword);
        params.put("page", page);
        params.put("pagesize", pageSize);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("question/watch-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    static {
        TAG = "VssQaManager";
    }
}

