/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.module.chat;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.logmanager.VLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseGetUserStateList;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.VHJSON;
import vhall.com.vss2.utils.rxutils.BasePresenter;

public class VssChatManager
extends BasePresenter {
    private static volatile VssChatManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssChatManager getInstance() {
        if (roomInfo == null) {
            VLog.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssChatManager> clazz = VssChatManager.class;
        synchronized (VssChatManager.class) {
            if (instance != null) return instance;
            instance = new VssChatManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void chatLists(String currPage, String pageSize, String startTime, CallBack<List<ResponseChatInfo>> callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        if (!TextUtils.isEmpty((CharSequence)currPage)) {
            params.put("curr_page", currPage);
        }
        if (!TextUtils.isEmpty((CharSequence)startTime)) {
            params.put("start_time", startTime);
        }
        if (!TextUtils.isEmpty((CharSequence)pageSize)) {
            params.put("page_size", pageSize);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("chat/list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback, new ArrayList<ResponseChatInfo>(){}.getClass()));
    }

    public void chatList(String currPage, String pageSize, String startTime, final CallBack<List<ResponseChatInfo>> callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        if (!TextUtils.isEmpty((CharSequence)currPage)) {
            params.put("curr_page", currPage);
        }
        if (!TextUtils.isEmpty((CharSequence)startTime)) {
            params.put("start_time", startTime);
        }
        if (!TextUtils.isEmpty((CharSequence)pageSize)) {
            params.put("page_size", pageSize);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("chat/list")).build();
        VHNetApi.getNetApi().doPost(request, new IVHNetCallback(){

            public void onFailure(VHNetResponse response, Exception e) {
                VssChatManager.this.dealError(e, callback, TAG);
            }

            public void response(VHNetResponse response) {
                if (callback != null) {
                    List s = (List)VHJSON.parseObject(response.getResult(), new ArrayList<ResponseChatInfo>(){}.getClass());
                    for (ResponseChatInfo info : s) {
                        String contentText = info.getData().getText_content();
                        if (info.getContext().getAtList() == null || info.getContext().getAtList().size() <= 0) continue;
                        for (ResponseChatInfo.ContextBean.AtListBean bean : info.getContext().getAtList()) {
                            contentText = contentText.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                        }
                        info.getData().setText_content(contentText);
                    }
                    callback.onSuccess(s);
                }
            }
        });
    }

    public void getBannedList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatOperateList()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("pagesize", pageSize);
        params.put("page", page);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/get-banned-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseGetUserStateList>(callBack, ResponseGetUserStateList.class));
    }

    public void getKickedList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatOperateList()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("pagesize", pageSize);
        params.put("page", page);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/get-kicked-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseGetUserStateList>(callBack, ResponseGetUserStateList.class));
    }

    public void getOnlineList(String nickname, String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatMemberList()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("pagesize", pageSize);
        params.put("page", page);
        params.put("nickname", nickname);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/get-online-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseGetUserStateList>(callBack, ResponseGetUserStateList.class));
    }

    public void getSpecialList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatMemberList()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            }
            VLog.e((String)TAG, (String)"\u6ca1\u6709\u83b7\u53d6\u6210\u5458\u5217\u8868\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("pagesize", pageSize);
        params.put("page", page);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/get-special-list")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseGetUserStateList>(callBack, ResponseGetUserStateList.class));
    }

    public void chatImageUpload(File file, CallBack<String> callback) {
        if (file == null) {
            callback.onError(-1, "file is  null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)"vss_token")) {
            if (callback != null) {
                callback.onError(-1, "vssToken \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"image/"), (File)file);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), fileBody).addFormDataPart("vss_token", vssToken).addFormDataPart("app_id", VssSdk.getInstance().getAppId()).addFormDataPart("from", "android_app").build();
    }

    static {
        TAG = "VssChatManager";
    }
}

