/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import vhall.com.vss2.data.ResponseChatInfo;

public class VssMessageChatData
implements Serializable {
    private String text_content;
    private String type;
    private String room_id;
    private String nickname;
    private String avatar;
    private String userId;
    private String time;
    private String image_url;
    private boolean isMy;
    private List<String> image_urls;
    private String roleName;
    private String target_id;
    public String event = "msg";
    public static final String eventOnlineKey = "online";
    public static final String eventOfflineKey = "offline";
    public static final String eventMsgKey = "msg";
    public static final String eventCustomKey = "custom_broadcast";
    public static final String eventQuestion = "question";
    private ReplyMsgBean replyMsg;
    private List<ResponseChatInfo.ContextBean.AtListBean> atList;

    public List<ResponseChatInfo.ContextBean.AtListBean> getAtlist() {
        return this.atList;
    }

    public void setAtlist(List<ResponseChatInfo.ContextBean.AtListBean> atlist) {
        this.atList = atlist;
    }

    public String getText_content() {
        return this.text_content;
    }

    public void setText_content(String text_content) {
        this.text_content = text_content;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoom_id() {
        return this.room_id;
    }

    public void setRoom_id(String room_id) {
        this.room_id = room_id;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTarget_id() {
        return this.target_id;
    }

    public void setTarget_id(String target_id) {
        this.target_id = target_id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public boolean isMy() {
        return this.isMy;
    }

    public void setMy(boolean my) {
        this.isMy = my;
    }

    public String getImage_url() {
        return this.image_url;
    }

    public void setImage_url(String image_url) {
        this.image_url = image_url;
    }

    public List<String> getImage_urls() {
        return this.image_urls;
    }

    public void setImage_urls(List<String> image_urls) {
        this.image_urls = image_urls;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public VssMessageChatData getMsgData(ResponseChatInfo chatInfo) {
        VssMessageChatData chatData = new VssMessageChatData();
        chatData.setUserId(chatInfo.getThird_party_user_id());
        chatData.setAvatar(chatInfo.getAvatar());
        chatData.setNickname(chatInfo.getNickname());
        chatData.setTime(chatInfo.getDate_time());
        String contentString = chatInfo.getData().getText_content();
        List<ResponseChatInfo.ContextBean.AtListBean> atList = chatInfo.getContext().getAtList();
        if (atList != null && atList.size() > 0) {
            for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                contentString = contentString.replace("***" + bean.getNickName(), "@" + bean.getNickName());
            }
        }
        chatData.setText_content(contentString);
        chatData.setType(chatInfo.getData().getType());
        chatData.setImage_urls(chatInfo.getData().getImage_urls());
        return chatData;
    }

    public ReplyMsgBean getReplyMsg() {
        return this.replyMsg;
    }

    public void setReplyMsg(ReplyMsgBean replyMsg) {
        this.replyMsg = replyMsg;
    }

    public static class ReplyMsgBean {
        private String type;
        private String avatar;
        private String sendId;
        private String nickName;
        private String roleName;
        private VssMessageChatData content;
        private String showTime;
        private String sendTime;
        private String client;
        private int count;
        private String msgId;
        private String channel;
        private boolean isHistoryMsg;
        private List<?> replyMsg;
        private List<?> atList;

        public ReplyMsgBean(JSONObject object) {
            this.type = object.optString("type");
            this.avatar = object.optString("avatar");
            this.sendId = object.optString("sendId");
            this.nickName = object.optString("nickName");
            this.roleName = object.optString("roleName");
            this.showTime = object.optString("showTime");
            this.sendTime = object.optString("sendTime");
            this.client = object.optString("client");
            this.count = object.optInt("count");
            this.msgId = object.optString("msgId");
            this.channel = object.optString("channel");
            this.isHistoryMsg = object.optBoolean("isHistoryMsg");
            JSONObject contentObject = object.optJSONObject("content");
            if (contentObject != null) {
                JSONObject replyObject;
                this.content = new VssMessageChatData();
                this.content.text_content = contentObject.optString("text_content");
                this.content.type = contentObject.optString("type");
                this.content.image_url = contentObject.optString("image_url");
                this.content.nickname = contentObject.optString("nickname");
                this.content.avatar = contentObject.optString("avatar");
                this.content.userId = contentObject.optString("userId");
                this.content.time = contentObject.optString("time");
                JSONArray image_urlsArray = contentObject.optJSONArray("image_urls");
                if (image_urlsArray != null) {
                    this.content.image_urls = new ArrayList();
                    for (int i = 0; i < image_urlsArray.length(); ++i) {
                        this.content.image_urls.add(image_urlsArray.optString(i));
                    }
                }
                if ((replyObject = contentObject.optJSONObject("replyMsg")) != null) {
                    this.content.replyMsg = new ReplyMsgBean(replyObject);
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAvatar() {
            return this.avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getSendId() {
            return this.sendId;
        }

        public void setSendId(String sendId) {
            this.sendId = sendId;
        }

        public String getNickName() {
            return this.nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public VssMessageChatData getContent() {
            return this.content;
        }

        public void setContent(VssMessageChatData content) {
            this.content = content;
        }

        public String getShowTime() {
            return this.showTime;
        }

        public void setShowTime(String showTime) {
            this.showTime = showTime;
        }

        public String getSendTime() {
            return this.sendTime;
        }

        public void setSendTime(String sendTime) {
            this.sendTime = sendTime;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public void setMsgId(String msgId) {
            this.msgId = msgId;
        }

        public String getChannel() {
            return this.channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public boolean isIsHistoryMsg() {
            return this.isHistoryMsg;
        }

        public void setIsHistoryMsg(boolean isHistoryMsg) {
            this.isHistoryMsg = isHistoryMsg;
        }

        public List<?> getReplyMsg() {
            return this.replyMsg;
        }

        public void setReplyMsg(List<?> replyMsg) {
            this.replyMsg = replyMsg;
        }

        public List<?> getAtList() {
            return this.atList;
        }

        public void setAtList(List<?> atList) {
            this.atList = atList;
        }
    }
}

