/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.network;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.CouponInfoData;
import com.vhall.vhss.data.GiftListData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.LotteryCheckData;
import com.vhall.vhss.data.LotteryPrizeData;
import com.vhall.vhss.data.LotteryPrizeListData;
import com.vhall.vhss.data.LotteryWinnerListData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.data.SurveyInfoData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;
import com.vhall.vhss.network.BaseNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class InteractToolsNetworkRequest
extends BaseNetwork {
    public static void lotteryGetWinner(String room_id, String lottery_id, CallBack<LotteryWinnerListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/users-get"), new CoreNetCallback<LotteryWinnerListData>(callBack, LotteryWinnerListData.class));
    }

    public static void getPrizeInfo(String webinar_id, CallBack<ArrayList<LotteryPrizeListData>> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", webinar_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/watch/get-draw-prize-info"), new CoreNetCallback(callBack, new ArrayList<LotteryPrizeListData>(){}.getClass()));
    }

    public static void getPrizeInfo(String webinar_id, String lottery_id, CallBack<LotteryPrizeData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", webinar_id);
        params.put("lottery_id", lottery_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/get-receive-award-setting"), new CoreNetCallback<LotteryPrizeData>(callBack, LotteryPrizeData.class));
    }

    public static void lotteryCheck(CallBack<LotteryCheckData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/check"), new CoreNetCallback<LotteryCheckData>(callBack, LotteryCheckData.class));
    }

    public static void lotteryJoin(String room_id, String lottery_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/participation"), new CoreNetCallback(callBack));
    }

    public static void lotteryCommit(String room_id, String lottery_id, String lottery_user_name, String lottery_user_phone, String lottery_user_remark, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        params.put("lottery_user_name", lottery_user_name);
        params.put("lottery_user_phone", lottery_user_phone);
        params.put("lottery_user_remark", lottery_user_remark);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/award"), new CoreNetCallback(callBack));
    }

    public static void lotteryWinningDetail(String room_id, String lottery_id, CallBack<LotteryWinningDetailData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/user-detail"), new CoreNetCallback<LotteryWinningDetailData>(callBack, LotteryWinningDetailData.class));
    }

    public static void lotteryWinningUserInfo(String room_id, CallBack<LotteryWinningUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/user-info"), new CoreNetCallback<LotteryWinningUserInfoData>(callBack, LotteryWinningUserInfoData.class));
    }

    public static void signJoin(String room_id, String sign_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("sign_id", sign_id);
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/sign/user-sign"), new CoreNetCallback(callBack));
    }

    public static void getHistorySurvey(String switchId, String room_id, String webinar_id, CallBack<ArrayList<SurveyInfoData>> callBack) {
        block2: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("room_id", room_id);
            params.put("webinar_id", webinar_id);
            params.put("switch_id", switchId);
            try {
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/survey/get-webinar-history-survey"), new CoreNetCallback(callBack, new ArrayList<SurveyInfoData>(){}.getClass()));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getHistoryLotteryList(String show_all, CallBack<ArrayList<LotteryCheckData>> callBack) {
        block2: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("show_all", show_all);
            try {
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "vss/lottery/check-list"), new CoreNetCallback(callBack, new ArrayList<LotteryCheckData>(){}.getClass()));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getTimerInfo(CallBack<TimerInfoData> callBack) {
        block2: {
            try {
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(null), "interacts/timer/info"), new CoreNetCallback<TimerInfoData>(callBack, TimerInfoData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void userLike(String room_id, String num, CallBack callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", room_id);
                params.put("num", num);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/like/create-user-like"), new CoreNetCallback(callBack));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getRoomLike(String room_id, final CallBack<Integer> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", room_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/like/get-room-like"), new CoreNetCallback(new CallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        block6: {
                            try {
                                JSONObject objectResult = new JSONObject(result);
                                if (!TextUtils.isEmpty((CharSequence)objectResult.optString("data"))) {
                                    JSONObject objectData = new JSONObject(objectResult.optString("data"));
                                    int total = objectData.optInt("total");
                                    if (callBack != null) {
                                        callBack.onSuccess(total);
                                    }
                                } else if (callBack != null) {
                                    callBack.onError(-1, "no data");
                                }
                            }
                            catch (Exception e) {
                                if (callBack == null) break block6;
                                callBack.onError(-1, e.getMessage());
                            }
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callBack != null) {
                            callBack.onError(eventCode, msg);
                        }
                    }
                }));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getAllLike(final CallBack<Integer> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/like/get-all-like"), new CoreNetCallback(new CallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        block6: {
                            try {
                                JSONObject objectResult = new JSONObject(result);
                                if (!TextUtils.isEmpty((CharSequence)objectResult.optString("data"))) {
                                    JSONObject objectData = new JSONObject(objectResult.optString("data"));
                                    int total = objectData.optInt("total");
                                    if (callBack != null) {
                                        callBack.onSuccess(total);
                                    }
                                } else if (callBack != null) {
                                    callBack.onError(-1, "no data");
                                }
                            }
                            catch (Exception e) {
                                if (callBack == null) break block6;
                                callBack.onError(-1, e.getMessage());
                            }
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callBack != null) {
                            callBack.onError(eventCode, msg);
                        }
                    }
                }));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getGiftList(String room_id, CallBack<GiftListData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", room_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/gift/get-webinar-using-gift-list"), new CoreNetCallback<GiftListData>(callBack, GiftListData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void sendGift(String room_id, String gift_id, String channel, String service_code, String open_id, CallBack callBack) {
        block3: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", room_id);
                params.put("gift_id", gift_id);
                params.put("channel", channel);
                params.put("service_code", service_code);
                if (!TextUtils.isEmpty((CharSequence)open_id)) {
                    params.put("open_id", open_id);
                }
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/gift/send-gift"), new CoreNetCallback(callBack));
            }
            catch (Exception e) {
                if (callBack == null) break block3;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void wechatSubmit(String webinar_id, String phone, String code, CallBack callBack) {
        block3: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("phone", phone);
                if (!TextUtils.isEmpty((CharSequence)code)) {
                    params.put("code", code);
                }
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/notice/notice-wechat-submit"), new CoreNetCallback(callBack));
            }
            catch (Exception e) {
                if (callBack == null) break block3;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getCardList(String webinar_id, String switch_id, int curr_page, int page_size, CallBack<CardsInfoData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("switch_id", switch_id);
                params.put("curr_page", curr_page + "");
                params.put("page_size", page_size + "");
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/push-screen-card/push-list"), new CoreNetCallback<CardsInfoData>(callBack, CardsInfoData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getCardInfo(String webinar_id, String card_id, CallBack<CardsInfoData.CardInfo> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("id", card_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/push-screen-card/info"), new CoreNetCallback<CardsInfoData.CardInfo>(callBack, CardsInfoData.CardInfo.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void cardClicked(String webinar_id, String switch_id, String card_id, CallBack<String> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("card_id", card_id);
                params.put("switch_id", switch_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequest(InteractToolsNetworkRequest.getSignParam(params), "interacts/push-screen-card/click"), new CoreNetCallback(callBack, null));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getGoodsList(String webinar_id, int status, CallBack<ArrayList<GoodsInfoData.GoodsInfo>> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("status", status + "");
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequestGET(InteractToolsNetworkRequest.getSignParam(params), "goods/webinar/get-online-goods"), new CoreNetCallback(callBack, new ArrayList<GoodsInfoData.GoodsInfo>(){}.getClass()));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getGoodsInfo(String goods_id, CallBack<GoodsInfoData.GoodsInfo> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("goods_id", goods_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequestGET(InteractToolsNetworkRequest.getSignParam(params), "goods/webinar/get-online-goods-info"), new CoreNetCallback<GoodsInfoData.GoodsInfo>(callBack, GoodsInfoData.GoodsInfo.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getGoodsOrderSetting(String webinar_id, CallBack<GoodsOrderSetting> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequestGET(InteractToolsNetworkRequest.getSignParam(params), "goods/webinar-setting/get-info"), new CoreNetCallback<GoodsOrderSetting>(callBack, GoodsOrderSetting.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getGoodsPartnerList(String webinar_id, CallBack<String> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getBaseRequestGET(InteractToolsNetworkRequest.getSignParam(params), "goods/partner/get-list"), new CoreNetCallback<String>(callBack, String.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void goodsOrderCreate(JSONObject params, CallBack<OrderInfoData> callBack) throws JSONException {
        VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getJsonBaseRequest(InteractToolsNetworkRequest.getJsonSignParam(params), "goods/order/create"), new CoreNetCallback<OrderInfoData>(callBack, OrderInfoData.class));
    }

    public static void getGoodsOrderInfo(String order_no, CallBack<OrderInfoData> callBack) {
        block2: {
            try {
                JSONObject params = new JSONObject();
                params.put("order_no", (Object)order_no);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getJsonBaseRequest(InteractToolsNetworkRequest.getJsonSignParam(params), "goods/order/my-order-info"), new CoreNetCallback<OrderInfoData>(callBack, OrderInfoData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getCouponAvailableList(String webinar_id, String goods_id, Integer goods_num, CallBack<ArrayList<CouponInfoData.CouponItem>> callBack) {
        block2: {
            try {
                JSONObject params = new JSONObject();
                params.put("webinar_id", (Object)webinar_id);
                params.put("goods_id", (Object)goods_id);
                params.put("goods_num", (Object)goods_num);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getJsonBaseRequest(InteractToolsNetworkRequest.getJsonSignParam(params), "goods/coupon-webinar/available-list"), new CoreNetCallback(callBack, new ArrayList<CouponInfoData.CouponItem>(){}.getClass()));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getCouponUnavailableList(String webinar_id, String goods_id, Integer goods_num, CallBack<ArrayList<CouponInfoData.CouponItem>> callBack) {
        block2: {
            try {
                JSONObject params = new JSONObject();
                params.put("webinar_id", (Object)webinar_id);
                params.put("goods_id", (Object)goods_id);
                params.put("goods_num", (Object)goods_num);
                VHNetApi.getNetApi().doPost(InteractToolsNetworkRequest.getJsonBaseRequest(InteractToolsNetworkRequest.getJsonSignParam(params), "goods/coupon-webinar/unavailable-list"), new CoreNetCallback(callBack, new ArrayList<CouponInfoData.CouponItem>(){}.getClass()));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }
}

