/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.network;

import android.text.TextUtils;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.WatchAuthInfo;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.CallBackV2;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.AgreementData;
import com.vhall.vhss.data.CommonConfigData;
import com.vhall.vhss.data.CreateRecordData;
import com.vhall.vhss.data.DirectorSeatListData;
import com.vhall.vhss.data.FilesData;
import com.vhall.vhss.data.GuestJoinInfoData;
import com.vhall.vhss.data.LabelListInfoData;
import com.vhall.vhss.data.LanguageListData;
import com.vhall.vhss.data.NoticeListInfoData;
import com.vhall.vhss.data.PlayerConfigData;
import com.vhall.vhss.data.PrivilegeInfoData;
import com.vhall.vhss.data.RecordChaptersData;
import com.vhall.vhss.data.RecordsData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.RoomToolsStatusData;
import com.vhall.vhss.data.RoundUserListData;
import com.vhall.vhss.data.ScrollInfoData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.data.WatermarkInfoData;
import com.vhall.vhss.data.WebinarBaseInfoData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.data.WebinarinfoListData;
import com.vhall.vhss.exception.ApiException;
import com.vhall.vhss.exception.CustomException;
import com.vhall.vhss.netutils.CoreNetCallback;
import com.vhall.vhss.network.BaseNetwork;
import com.vhall.vhss.network.InteractNetworkRequest;
import com.vhall.vhss.params.CreateWebinarParams;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityNetworkRequest
extends BaseNetwork {
    private static String _visitorId = null;

    public static void initBefore(String webinarId, final CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/webinar/init-before"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                block9: {
                    try {
                        JSONObject objectResult = new JSONObject(result);
                        if (!TextUtils.isEmpty((CharSequence)objectResult.optString("data"))) {
                            JSONObject objectData = new JSONObject(objectResult.optString("data"));
                            String id = objectData.optString("user_id");
                            if (!TextUtils.isEmpty((CharSequence)id)) {
                                if (callBack != null) {
                                    callBack.onSuccess(id);
                                }
                            } else if (callBack != null) {
                                callBack.onError(-1, "no id");
                            }
                        } else if (callBack != null) {
                            callBack.onError(-1, "no data");
                        }
                    }
                    catch (Exception e) {
                        if (callBack == null) break block9;
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getWebinarList(int page, String user_id, String webinar_state, CallBack<WebinarinfoListData> callBack) {
        if (page == 0) {
            if (callBack != null) {
                callBack.onError(-1, "\u9875\u7801\u4ece1\u5f00\u59cb");
            }
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(10));
        params.put("pos", String.valueOf((page - 1) * 10));
        params.put("user_id", user_id);
        params.put("order_type", "1");
        params.put("need_flash", "0");
        if (!TextUtils.isEmpty((CharSequence)webinar_state)) {
            params.put("webinar_state", webinar_state);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/webinar/get-list"), new CoreNetCallback<WebinarinfoListData>(callBack, WebinarinfoListData.class));
    }

    public static void guestJoinWebinar(String webinarId, String password, String nickname, String type, String visitorId, CallBack<GuestJoinInfoData> callBack) {
        ActivityNetworkRequest.guestJoinWebinar(webinarId, password, nickname, "", type, visitorId, callBack);
    }

    public static void guestJoinWebinar(String webinarId, String password, String nickname, String avatar, String type, String visitorId, final CallBack<GuestJoinInfoData> callBack) {
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        params.put("nickname", TextUtils.isEmpty((CharSequence)nickname) ? "" : nickname.trim());
        params.put("password", TextUtils.isEmpty((CharSequence)password) ? "" : password.trim());
        params.put("type", TextUtils.isEmpty((CharSequence)type) ? "" : type.trim());
        if (!TextUtils.isEmpty((CharSequence)visitorId)) {
            params.put("visitor_id", visitorId.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)avatar)) {
            params.put("avatar", avatar.trim());
        }
        ActivityNetworkRequest.initBefore(webinarId, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(BaseNetwork.getSignParam(params), "webinars/live/role-login"), new CoreNetCallback<GuestJoinInfoData>(callBack, GuestJoinInfoData.class));
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(BaseNetwork.getSignParam(params), "webinars/live/role-login"), new CoreNetCallback<GuestJoinInfoData>(callBack, GuestJoinInfoData.class));
            }
        });
    }

    public static void getRoomToolsState(String roomId, CallBack<RoomToolsStatusData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", roomId);
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/room/get-inav-tool-status"), new CoreNetCallback<RoomToolsStatusData>(callBack, RoomToolsStatusData.class));
    }

    public static void getPrivilegeInfo(String webinar_id, CallBack<PrivilegeInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/privilege/info"), new CoreNetCallback<PrivilegeInfoData>(callBack, PrivilegeInfoData.class));
    }

    public static void setPrivilegeOpen(String webinar_id, int is_privilege, CallBack<PrivilegeInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        params.put("is_privilege", String.valueOf(is_privilege));
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/privilege/open-privilege"), new CoreNetCallback<PrivilegeInfoData>(callBack, PrivilegeInfoData.class));
    }

    public static void getWebinarState(String webinarId, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_ids", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/webinar/get-webinar-state"), new CoreNetCallback<VhssUserInfoData>(callBack, VhssUserInfoData.class));
    }

    public static void createWebinar(CreateWebinarParams createWebinarParams, final CallBack myCallBack) {
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(createWebinarParams.getParams(), "webinars/webinar/create"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                String webinar_id = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            webinar_id = data.optString("webinar_id");
                        } else if (myCallBack != null) {
                            myCallBack.onError(code, "create webinar error");
                        }
                    } else if (myCallBack != null) {
                        myCallBack.onError(code, objectResult.optString("msg"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinar_id);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void updateWebinar(CreateWebinarParams createWebinarParams, final CallBack myCallBack) {
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(createWebinarParams.getParams(), "webinars/webinar/edit"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                String webinar_id = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            webinar_id = data.optString("webinar_id");
                        } else if (myCallBack != null) {
                            myCallBack.onError(code, "update webinar error");
                        }
                    } else if (myCallBack != null) {
                        myCallBack.onError(code, objectResult.optString("msg"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinar_id);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getDirectorSeatList(String webinarId, CallBack<DirectorSeatListData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/director/get-seat-list"), new CoreNetCallback<DirectorSeatListData>(myCallBack, DirectorSeatListData.class));
    }

    public static void directorSelectSeat(String webinarId, String seatId, String uuid, CallBack myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        params.put("seat_id", TextUtils.isEmpty((CharSequence)seatId) ? "" : seatId.trim());
        params.put("uuid", TextUtils.isEmpty((CharSequence)uuid) ? "" : uuid.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/director/select-seat"), new CoreNetCallback(myCallBack));
    }

    public static void getDirectorStatus(String webinarId, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/director/get-status"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                block3: {
                    try {
                        JSONObject objectResult = new JSONObject(result);
                        JSONObject data = objectResult.optJSONObject("data");
                        int code = objectResult.optInt("code");
                        if (code == 200 && myCallBack != null) {
                            myCallBack.onSuccess(data.optString("director_status"));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        if (myCallBack == null) break block3;
                        myCallBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getDirectorStreamStatus(String webinarId, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/director/get-stream-status"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                block3: {
                    try {
                        JSONObject objectResult = new JSONObject(result);
                        JSONObject data = objectResult.optJSONObject("data");
                        int code = objectResult.optInt("code");
                        if (code == 200 && myCallBack != null) {
                            myCallBack.onSuccess(data.optString("director_stream"));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        if (myCallBack == null) break block3;
                        myCallBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getDirectorSeatInfo(String webinarId, String seat_id, CallBack<WebinarInfoData> myCallBack) {
        ActivityNetworkRequest.getDirectorSeatInfo(webinarId, seat_id, "0", myCallBack);
    }

    public static void getDirectorSeatInfo(final String webinarId, final String seat_id, final String check_online, final CallBack<WebinarInfoData> myCallBack) {
        ActivityNetworkRequest.initBefore(webinarId, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                ActivityNetworkRequest.getDirectorSeatInit(webinarId, seat_id, check_online, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                ActivityNetworkRequest.getDirectorSeatInit(webinarId, seat_id, check_online, myCallBack);
            }
        });
    }

    private static void getDirectorSeatInit(String webinarId, String seatId, String check_online, final CallBack<WebinarInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)seatId)) {
            params.put("seat_id", seatId.trim());
        }
        params.put("check_online", check_online);
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/live/director-seat-init"), new CoreNetCallback<WebinarInfoData>(new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(WebinarInfoData webinarInfoData) {
                if (TextUtils.isEmpty((CharSequence)TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinarInfoData);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }

    public static void getLiveInfo(final String webinarId, final String liveToken, final String nickName, final String email, final CallBack<WebinarInfoData> myCallBack) {
        ActivityNetworkRequest.initBefore(webinarId, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                ActivityNetworkRequest.getLiveInit(webinarId, liveToken, nickName, email, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                ActivityNetworkRequest.getLiveInit(webinarId, liveToken, nickName, email, myCallBack);
            }
        });
    }

    private static void getLiveInit(final String webinarId, String liveToken, String nickName, String email, final CallBack<WebinarInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)liveToken)) {
            params.put("live_token", liveToken.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)email)) {
            params.put("email", email.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)nickName)) {
            params.put("nickname", nickName.trim());
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/live/init"), new CoreNetCallback<WebinarInfoData>(new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(final WebinarInfoData webinarInfoData) {
                TokenManger.setInteractToken(webinarInfoData.interact.interact_token);
                if (TextUtils.isEmpty((CharSequence)TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                InteractNetworkRequest.setDevice(webinarInfoData.interact.room_id, "1", null);
                ActivityNetworkRequest.commonConfig(webinarId, new CallBack<CommonConfigData>(){

                    @Override
                    public void onSuccess(CommonConfigData result) {
                        if (result != null) {
                            webinarInfoData.roomToolsStatusData = result.roomTool;
                            webinarInfoData.filters = result.keyWord;
                            webinarInfoData.like = result.like;
                            webinarInfoData.noticeListInfoData = result.noticeListInfoData;
                            webinarInfoData.skinData = result.skinData;
                            webinarInfoData.menuListInfoData = result.menuListInfoData;
                        }
                        ActivityNetworkRequest.playerConfig(webinarId, new CallBack<PlayerConfigData>(){

                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        ActivityNetworkRequest.playerConfig(webinarId, new CallBack<PlayerConfigData>(){

                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }

    public static void liveStart(String webinarId, String liveToken, String start_type, CallBack callBack) {
        ActivityNetworkRequest.liveStart(webinarId, liveToken, start_type, "0", callBack);
    }

    public static void liveStart(String webinarId, String liveToken, String start_type, String live_type, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)liveToken)) {
            params.put("live_token", liveToken);
        }
        if (!TextUtils.isEmpty((CharSequence)start_type)) {
            params.put("start_type", start_type);
        }
        if (!TextUtils.isEmpty((CharSequence)live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/live/start"), new CoreNetCallback(callBack));
    }

    public static void liveEnd(String webinarId, String liveToken, String end_type, CallBack callBack) {
        ActivityNetworkRequest.liveEnd(webinarId, liveToken, end_type, "0", callBack);
    }

    public static void liveEnd(String webinarId, String liveToken, String end_type, String live_type, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)liveToken)) {
            params.put("live_token", liveToken);
        }
        if (!TextUtils.isEmpty((CharSequence)end_type)) {
            params.put("end_type", end_type);
        }
        if (!TextUtils.isEmpty((CharSequence)live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/live/end"), new CoreNetCallback(callBack));
    }

    public static void getWebinarBaseInfo(String webinarId, String is_no_check, CallBack<WebinarBaseInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)is_no_check)) {
            params.put("is_no_check", is_no_check.trim());
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/webinar/info"), new CoreNetCallback<WebinarBaseInfoData>(callBack, WebinarBaseInfoData.class));
    }

    public static void getWatchAuth(String webinarId, String type, String verifyValue, final CallBackV2<WatchAuthInfo> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)verifyValue)) {
            params.put("type", String.valueOf(type));
            params.put("verify_value", verifyValue);
        }
        if (!TextUtils.isEmpty((CharSequence)_visitorId)) {
            params.put("visitor_id", _visitorId);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/watch/sdk-auth"), new CoreNetCallback<WatchAuthInfo>(new CallBackV2<WatchAuthInfo>(){

            @Override
            public void onSuccess(WatchAuthInfo result) {
                _visitorId = result.visitor_id;
                if (null != callBack) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }

            @Override
            public void onError(int eventCode, String msg, WatchAuthInfo result) {
                if (null != callBack) {
                    callBack.onError(eventCode, msg, result);
                }
            }
        }, WatchAuthInfo.class));
    }

    public static void getWatchInfo(String webinarId, String recordId, String nickname, String email, String pass, CallBack<WebinarInfoData> myCallBack) {
        ActivityNetworkRequest.getWatchInit(webinarId, recordId, nickname, email, pass, "", null, myCallBack);
    }

    public static void getWatchInfo(final String webinarId, final String recordId, final String nickname, final String email, final String pass, final String k_id, final HashMap<String, String> authConfig, final CallBack<WebinarInfoData> myCallBack) {
        ActivityNetworkRequest.initBefore(webinarId, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                ActivityNetworkRequest.getWatchInit(webinarId, recordId, nickname, email, pass, k_id, authConfig, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                ActivityNetworkRequest.getWatchInit(webinarId, recordId, nickname, email, pass, k_id, authConfig, myCallBack);
            }
        });
    }

    private static void getWatchInit(final String webinarId, String recordId, String nickname, String email, String pass, String k_id, HashMap<String, String> authConfig, final CallBack<WebinarInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty((CharSequence)recordId)) {
            params.put("record_id", recordId.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)email)) {
            params.put("email", email.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)nickname)) {
            params.put("nickname", nickname.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)pass)) {
            params.put("pass", pass.trim());
        }
        if (!TextUtils.isEmpty((CharSequence)k_id)) {
            params.put("k_id", k_id.trim());
        }
        if (null != authConfig && authConfig.containsKey("auth_model")) {
            params.put("auth_model", authConfig.get("auth_model"));
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/watch/sdk-init"), new CoreNetCallback<WebinarInfoData>(new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(final WebinarInfoData webinarInfoData) {
                TokenManger.setInteractToken(webinarInfoData.interact.interact_token);
                if (TextUtils.isEmpty((CharSequence)TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                InteractNetworkRequest.setDevice(webinarInfoData.interact.room_id, "1", null);
                ActivityNetworkRequest.commonConfig(webinarId, new CallBack<CommonConfigData>(){

                    @Override
                    public void onSuccess(CommonConfigData commonConfigData) {
                        if (commonConfigData != null) {
                            webinarInfoData.roomToolsStatusData = commonConfigData.roomTool;
                            webinarInfoData.filters = commonConfigData.keyWord;
                            webinarInfoData.like = commonConfigData.like;
                            webinarInfoData.noticeListInfoData = commonConfigData.noticeListInfoData;
                            webinarInfoData.skinData = commonConfigData.skinData;
                            webinarInfoData.menuListInfoData = commonConfigData.menuListInfoData;
                        }
                        ActivityNetworkRequest.playerConfig(webinarId, new CallBack<PlayerConfigData>(){

                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        ActivityNetworkRequest.playerConfig(webinarId, new CallBack<PlayerConfigData>(){

                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }

    public static void getNoticeList(String room_id, int pos, int limit, CallBack<NoticeListInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        limit = limit == 0 ? 10 : limit;
        params.put("room_id", room_id);
        params.put("limit", String.valueOf(limit));
        params.put("pos", String.valueOf(pos * limit));
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/chat/get-announcement-list"), new CoreNetCallback<NoticeListInfoData>(callBack, NoticeListInfoData.class));
    }

    public static void getWatermark(String webinar_id, CallBack<WatermarkInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/players/get-watermark-config"), new CoreNetCallback<WatermarkInfoData>(callBack, WatermarkInfoData.class));
    }

    public static void getScrolling(String webinar_id, CallBack<ScrollInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/players/get-scrolling-screen-config"), new CoreNetCallback<ScrollInfoData>(callBack, ScrollInfoData.class));
    }

    public static void getAgreement(String webinar_id, CallBack<AgreementData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/agreement/get-agreement"), new CoreNetCallback<AgreementData>(callBack, AgreementData.class));
    }

    public static void setUserAgreeAgreement(String webinar_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/agreement/set-user-agree"), new CoreNetCallback(callBack));
    }

    public static void createRecord(String webinar_id, CallBack<CreateRecordData> callBack) {
        ActivityNetworkRequest.createRecord(webinar_id, "0", callBack);
    }

    public static void createRecord(String webinar_id, String live_type, CallBack<CreateRecordData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        if (!TextUtils.isEmpty((CharSequence)live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/record/live-create-record"), new CoreNetCallback<CreateRecordData>(callBack, CreateRecordData.class));
    }

    public static void setDefaultRecord(String record_id, CallBack<ScrollInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("record_id", TextUtils.isEmpty((CharSequence)record_id) ? "" : record_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/record/set-default"), new CoreNetCallback<ScrollInfoData>(callBack, ScrollInfoData.class));
    }

    public static void uploadFile(String resfile, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "webinars/img_url");
        params.put("resfile", resfile);
        params.put("type", "image");
        params.put("method", "base64");
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "commons/upload/index"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                String imageUrl = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            imageUrl = data.optString("domain_url");
                        } else if (myCallBack != null) {
                            myCallBack.onError(code, "upload image error");
                        }
                    } else if (myCallBack != null) {
                        myCallBack.onError(code, objectResult.optString("msg"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(imageUrl);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getActivityLanguage(String webinar_id, CallBack<LanguageListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/webinar-language/get-list"), new CoreNetCallback<LanguageListData>(callBack, LanguageListData.class));
    }

    public static void refreshToken(final CallBack<String> callBack) {
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(null), "users/user/refresh-token"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (callBack != null) {
                            callBack.onSuccess(data.optString("token"));
                        }
                        TokenManger.setToken(data.optString("token"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        }));
    }

    public static void getShareInfo(String webinar_id, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/share/info"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (myCallBack != null) {
                    myCallBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getRoleName(String webinar_id, CallBack<RoleNameData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/privilege/get-role-name"), new CoreNetCallback<RoleNameData>(myCallBack, RoleNameData.class));
    }

    public static void editRoleName(String webinar_id, String type, String name, CallBack<RoleNameData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        params.put("type", TextUtils.isEmpty((CharSequence)type) ? "" : type.trim());
        params.put("name", TextUtils.isEmpty((CharSequence)name) ? "" : name.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/privilege/edit-role-name"), new CoreNetCallback<RoleNameData>(myCallBack, RoleNameData.class));
    }

    public static void getConfigList(String webinar_id, String webinar_user_id, CallBack<String> myCallBack) {
        ActivityNetworkRequest.getConfigList("2", webinar_id, webinar_user_id, myCallBack);
    }

    public static void getConfigList(String scene_id, String webinar_id, String webinar_user_id, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)scene_id)) {
            params.put("scene_id", scene_id);
        }
        params.put("webinar_user_id", webinar_user_id);
        if (!TextUtils.isEmpty((CharSequence)webinar_id) && !TextUtils.isEmpty((CharSequence)webinar_user_id)) {
            params.put("webinar_id", webinar_id);
            params.put("webinar_user_id", webinar_user_id);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "users/permission/get-config-list"), new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (myCallBack != null) {
                    myCallBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    public static void getLabelList(String webinar_id, String name, String pos, String limit, CallBack<LabelListInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("webinar_id", TextUtils.isEmpty((CharSequence)webinar_id) ? "" : webinar_id.trim());
        if (!TextUtils.isEmpty((CharSequence)name)) {
            params.put("name", name);
        }
        if (!TextUtils.isEmpty((CharSequence)pos)) {
            params.put("pos", pos);
        }
        if (!TextUtils.isEmpty((CharSequence)limit)) {
            params.put("limit", limit);
        }
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/label/get-list"), new CoreNetCallback<LabelListInfoData>(myCallBack, LabelListInfoData.class));
    }

    public static void createLabelList(String name, CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", TextUtils.isEmpty((CharSequence)name) ? "" : name.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/label/create"), new CoreNetCallback(myCallBack));
    }

    public static void getRoundUsers(String room_id, String is_next, CallBack<RoundUserListData> myCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", TextUtils.isEmpty((CharSequence)room_id) ? "" : room_id.trim());
        params.put("is_next", TextUtils.isEmpty((CharSequence)is_next) ? "" : is_next.trim());
        VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/video-round/get-round-users"), new CoreNetCallback<RoundUserListData>(myCallBack, RoundUserListData.class));
    }

    public static void commonConfig(String webinar_id, CallBack<CommonConfigData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("tags", "skin,screen-poster,room-tool,webinar-tag,menu,goods-default,adv-default,invite-card,keywords,like,announcement,sign,timer");
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/union/common-config"), new CoreNetCallback<CommonConfigData>(callBack, CommonConfigData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void playerConfig(String webinar_id, CallBack<PlayerConfigData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("tags", "definition,screen-config,water-mark");
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/union/player-config"), new CoreNetCallback<PlayerConfigData>(callBack, PlayerConfigData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getStreamPushAddress(String webinar_id, CallBack<PlayerConfigData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/live/get-stream-push-address"), new CoreNetCallback<PlayerConfigData>(callBack, PlayerConfigData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getWarmInfo(String webinar_id, CallBack<WarmInfoData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/warm/info"), new CoreNetCallback<WarmInfoData>(callBack, WarmInfoData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getRecordChaptersList(String record_id, CallBack<RecordChaptersData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("record_id", record_id);
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/record/get-doc-info-from-rid"), new CoreNetCallback<RecordChaptersData>(callBack, RecordChaptersData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getRecordList(String webinar_id, int pos, int limit, CallBack<RecordsData> callBack) {
        block2: {
            try {
                String vhallId = VhallSDK.getUserId();
                vhallId = vhallId == null ? "" : vhallId;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("pos", pos + "");
                params.put("limit", limit + "");
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "webinars/record/get-list"), new CoreNetCallback<RecordsData>(callBack, RecordsData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getFilesList(String webinar_id, String menu_id, CallBack<FilesData> callBack) {
        block2: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("menu_id", menu_id);
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/data-download/data-download-list"), new CoreNetCallback<FilesData>(callBack, FilesData.class));
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    public static void getFileDownLoadUrl(String webinar_id, String menu_id, String file_id, final CallBack<String> callBack) {
        block2: {
            try {
                String vhallId = VhallSDK.getUserId();
                vhallId = vhallId == null ? "" : vhallId;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("webinar_id", webinar_id);
                params.put("menu_id", menu_id);
                params.put("file_id", file_id);
                params.put("visit_id", vhallId);
                params.put("download_type", "3");
                VHNetApi.getNetApi().doPost(ActivityNetworkRequest.getBaseRequest(ActivityNetworkRequest.getSignParam(params), "interacts/data-download/check-download"), new IVHNetCallback(){

                    public void onFailure(VHNetResponse response, Exception e) {
                        if (callBack != null) {
                            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
                            if (callBack instanceof CallBackV2) {
                                this.response(response);
                            } else {
                                callBack.onError(exception.getCode(), exception.getMessage());
                            }
                        }
                    }

                    public void response(VHNetResponse response) {
                        if (callBack != null && response != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response.getResult());
                                int code = jsonObject.optInt("code");
                                String msg = jsonObject.optString("msg");
                                if (code == 200) {
                                    callBack.onSuccess(jsonObject.optJSONObject("data").optString("download_url"));
                                } else {
                                    callBack.onError(code, msg);
                                }
                            }
                            catch (JSONException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                if (callBack == null) break block2;
                callBack.onError(-1, e.getMessage());
            }
        }
    }
}

