/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.data;

import android.text.TextUtils;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class WatermarkInfoData
implements Serializable {
    public String webinar_id;
    public int watermark_open;
    public String img_url;
    public int img_alpha;
    public int img_position;
    public WatermarkTypeInfo doc_watermark_type;
    public String doc_font_size;
    public String doc_font_color;
    public String doc_transparency;
    public String doc_watermark_open;
    public String raw;

    public WatermarkInfoData(JSONObject object) {
        this.raw = object.toString();
        this.webinar_id = object.optString("webinar_id");
        this.img_url = object.optString("img_url");
        this.img_alpha = object.optInt("img_alpha");
        this.img_position = object.optInt("img_position");
        this.watermark_open = object.optInt("watermark_open");
        String docWatermarkTypeOrigin = object.optString("doc_watermark_type");
        if (!TextUtils.isEmpty((CharSequence)docWatermarkTypeOrigin)) {
            try {
                JSONObject watermarkType = new JSONObject(docWatermarkTypeOrigin);
                WatermarkTypeInfo typeInfo = new WatermarkTypeInfo();
                typeInfo.text = watermarkType.optString("text");
                typeInfo.user_id = watermarkType.optString("user_id");
                typeInfo.nick_name = watermarkType.optString("nick_name");
                typeInfo.text_value = watermarkType.optString("text_value");
                this.doc_watermark_type = typeInfo;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (null != this.doc_watermark_type) {
                this.doc_font_size = object.optString("doc_font_size");
                this.doc_font_color = object.optString("doc_font_color");
                this.doc_transparency = object.optString("doc_transparency");
                this.doc_watermark_open = object.optString("doc_watermark_open");
            }
        }
    }

    public WatermarkInfoData() {
    }

    public boolean isDocWatermarkEnable() {
        return TextUtils.equals((CharSequence)"1", (CharSequence)this.doc_watermark_open) && null != this.doc_watermark_type && this.doc_watermark_type.isConfigEnable();
    }

    public static class WatermarkTypeInfo
    implements Serializable {
        public String text;
        public String user_id;
        public String nick_name;
        public String text_value;

        public boolean isConfigEnable() {
            return !TextUtils.isEmpty((CharSequence)this.text_value) && (TextUtils.equals((CharSequence)"1", (CharSequence)this.text) || TextUtils.equals((CharSequence)"1", (CharSequence)this.user_id) || TextUtils.equals((CharSequence)"1", (CharSequence)this.nick_name));
        }

        public String getWatermarkText(String userId, String nickName) {
            String split;
            String combinedText = "";
            if (TextUtils.equals((CharSequence)"1", (CharSequence)this.text) && !TextUtils.isEmpty((CharSequence)this.text_value)) {
                combinedText = combinedText + this.text_value;
            }
            if (TextUtils.equals((CharSequence)"1", (CharSequence)this.user_id) && !TextUtils.isEmpty((CharSequence)userId)) {
                split = "";
                if (!TextUtils.isEmpty((CharSequence)combinedText)) {
                    split = "-";
                }
                combinedText = combinedText + split + userId;
            }
            if (TextUtils.equals((CharSequence)"1", (CharSequence)this.nick_name) && !TextUtils.isEmpty((CharSequence)nickName)) {
                split = "";
                if (!TextUtils.isEmpty((CharSequence)combinedText)) {
                    split = "-";
                }
                combinedText = combinedText + split + nickName;
            }
            return combinedText;
        }
    }
}

