/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.data;

import android.text.TextUtils;
import android.widget.ImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GoodsInfoData
implements Serializable {
    public int total = 0;
    public List<GoodsInfo> list;
    public String raw;

    public GoodsInfoData() {
    }

    public GoodsInfoData(JSONArray object) {
        this.raw = object.toString();
        JSONArray listArray = object;
        if (listArray != null) {
            this.list = new ArrayList<GoodsInfo>();
            for (int i = 0; i < listArray.length(); ++i) {
                this.list.add(new GoodsInfo(listArray.optJSONObject(i)));
            }
            this.total = this.list.size();
        }
    }

    public List<GoodsInfo> getList() {
        return this.list;
    }

    public void setList(List<GoodsInfo> list) {
        this.list = list;
    }

    public static class GoodsInfo
    implements Serializable {
        public String goods_id;
        public String name;
        public String description;
        public String price;
        public String discount_price;
        public Integer buy_type;
        public String third_goods_id;
        public String url;
        public Boolean shop_show;
        public String shop_url;
        public String cover_img;
        public ImageView.ScaleType cover_img_scale_type;
        public List<ImageInfo> images;
        public String tao_password;
        public String scheme_template;
        public String qr_code_url;
        public Integer status;
        public Integer push_status;
        public Integer order_num;
        public String webinar_goods_id;
        public String cdn_url;
        public Integer action;
        public List<String> del_goods_ids;

        public GoodsInfo() {
        }

        public GoodsInfo(JSONObject object) {
            JSONArray listArray;
            if (object == null) {
                return;
            }
            this.goods_id = object.optString("goods_id");
            this.third_goods_id = object.optString("third_goods_id");
            this.scheme_template = object.optString("scheme_template");
            this.qr_code_url = object.optString("qr_code_url");
            this.webinar_goods_id = object.optString("webinar_goods_id");
            this.name = object.optString("name");
            this.order_num = object.optInt("order_num");
            this.description = object.optString("description");
            this.price = object.optString("price");
            this.discount_price = object.optString("discount_price");
            this.price = TextUtils.isEmpty((CharSequence)this.price) ? "" : this.price;
            this.discount_price = TextUtils.isEmpty((CharSequence)this.discount_price) ? "" : this.discount_price;
            this.url = object.optString("url");
            this.shop_show = object.optInt("shop_show") == 1;
            this.tao_password = object.optString("tao_password");
            this.shop_url = object.optString("shop_url");
            this.status = object.optInt("status");
            this.push_status = object.optInt("push_status");
            this.buy_type = object.optInt("buy_type");
            this.cover_img = object.optString("cover_img");
            this.cover_img_scale_type = ImageView.ScaleType.FIT_CENTER;
            if (!TextUtils.isEmpty((CharSequence)this.cover_img) && this.cover_img.contains("https://")) {
                if (this.cover_img.contains("mode=1")) {
                    this.cover_img_scale_type = ImageView.ScaleType.FIT_XY;
                } else if (this.cover_img.contains("mode=3")) {
                    this.cover_img_scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
            if (TextUtils.isEmpty((CharSequence)this.name)) {
                this.name = object.optString("goods_name");
            }
            if ((listArray = object.optJSONArray("images")) != null) {
                this.images = new ArrayList<ImageInfo>();
                for (int i = 0; i < listArray.length(); ++i) {
                    ImageInfo image = new ImageInfo(listArray.optJSONObject(i));
                    if (TextUtils.isEmpty((CharSequence)this.cover_img) && image.is_cover.booleanValue()) {
                        this.cover_img = image.img_url;
                        this.cover_img_scale_type = image.scale_type;
                    }
                    this.images.add(image);
                }
            }
        }
    }

    public static class ImageInfo
    implements Serializable {
        public String img_id;
        public Boolean is_cover;
        public String img_url;
        public ImageView.ScaleType scale_type;

        public ImageInfo(JSONObject object) {
            this.img_id = object.optString("img_id");
            this.is_cover = object.optInt("is_cover") == 1;
            this.img_url = object.optString("img_url");
            this.scale_type = ImageView.ScaleType.FIT_CENTER;
            if (!TextUtils.isEmpty((CharSequence)this.img_url) && this.img_url.contains("https://")) {
                if (this.img_url.contains("mode=1")) {
                    this.scale_type = ImageView.ScaleType.FIT_XY;
                } else if (this.img_url.contains("mode=3")) {
                    this.scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
        }
    }
}

