/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.vhall.business.MessageServer;
import com.vhall.business.R;
import com.vhall.business.utils.LogManager;
import java.util.ArrayList;
import java.util.List;

public abstract class DocumentView
extends ImageView {
    protected static final int TYPE_PATH = 1;
    protected static final int TYPE_TEXT = 4;
    protected static final int TYPE_OVAL = 20;
    protected static final int TYPE_RECT = 22;
    protected static final int TYPE_ARROW = 30;
    protected static final int TYPE_DARROW = 31;
    protected static final int TYPE_ANCHOR = 7;
    private static int defaultStrokeWidth = 2;
    private static final String TAG = "DocumentView";
    protected Context mContext;
    private Paint mPaint;
    float scaleX = 0.0f;
    float scaleY = 0.0f;
    float transX = 0.0f;
    float transY = 0.0f;

    public DocumentView(Context context) {
        super(context);
        this.init(context);
    }

    public DocumentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DocumentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void init(Context context) {
        this.mContext = context;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.calcRT();
    }

    public abstract void setSteps(String var1, List<MessageServer.MsgInfo> var2);

    public abstract void setStep(MessageServer.MsgInfo var1);

    protected void paint(MessageServer.MsgInfo msgInfo, Canvas canvas) {
        if (msgInfo == null || msgInfo.step == null) {
            return;
        }
        MessageServer.Step step = msgInfo.step;
        this.mPaint.setARGB(178, Color.red((int)step.color), Color.green((int)step.color), Color.blue((int)step.color));
        switch (step.type) {
            case 1: {
                this.mPaint.setStrokeWidth((float)step.lineSize);
                Path path = new Path();
                ArrayList<MessageServer.Position> points = step.points;
                if (points != null && points.size() > 0) {
                    for (int j = 0; j < points.size(); ++j) {
                        if (j == 0) {
                            path.moveTo((float)points.get((int)j).x, (float)points.get((int)j).y);
                            continue;
                        }
                        path.lineTo((float)points.get((int)j).x, (float)points.get((int)j).y);
                    }
                }
                canvas.drawPath(path, this.mPaint);
                break;
            }
            case 4: {
                this.mPaint.setStrokeWidth(0.0f);
                Typeface typeface = null;
                typeface = step.fb == 1 && step.fi == 0 ? Typeface.create((Typeface)Typeface.DEFAULT_BOLD, (int)1) : (step.fb == 1 && step.fi == 1 ? Typeface.create((Typeface)Typeface.MONOSPACE, (int)3) : (step.fb == 0 && step.fi == 1 ? Typeface.create((Typeface)Typeface.MONOSPACE, (int)2) : Typeface.create((Typeface)Typeface.DEFAULT, (int)0)));
                this.mPaint.setTypeface(typeface);
                this.mPaint.setTextSize((float)step.fs);
                canvas.drawText(step.ft, (float)step.sPoint.x, (float)step.sPoint.y + (float)step.fs, this.mPaint);
                break;
            }
            case 20: {
                float bottom;
                float top;
                float right;
                float left;
                this.mPaint.setStrokeWidth((float)defaultStrokeWidth);
                if (step.sPoint.x < step.tPoint.x) {
                    left = (float)step.sPoint.x;
                    right = (float)step.tPoint.x;
                } else {
                    left = (float)step.tPoint.x;
                    right = (float)step.sPoint.x;
                }
                if (step.sPoint.y < step.tPoint.y) {
                    top = (float)step.sPoint.y;
                    bottom = (float)step.tPoint.y;
                } else {
                    top = (float)step.tPoint.y;
                    bottom = (float)step.sPoint.y;
                }
                RectF rect = new RectF(left, top, right, bottom);
                canvas.drawOval(rect, this.mPaint);
                break;
            }
            case 22: {
                float bottomF;
                float topF;
                float rightF;
                float leftF;
                this.mPaint.setStrokeWidth((float)defaultStrokeWidth);
                if (step.sPoint.x < step.tPoint.x) {
                    leftF = (float)step.sPoint.x;
                    rightF = (float)step.tPoint.x;
                } else {
                    leftF = (float)step.tPoint.x;
                    rightF = (float)step.sPoint.x;
                }
                if (step.sPoint.y < step.tPoint.y) {
                    topF = (float)step.sPoint.y;
                    bottomF = (float)step.tPoint.y;
                } else {
                    topF = (float)step.tPoint.y;
                    bottomF = (float)step.sPoint.y;
                }
                RectF rectF = new RectF(leftF, topF, rightF, bottomF);
                canvas.drawRect(rectF, this.mPaint);
                break;
            }
            case 30: {
                this.mPaint.setStrokeWidth((float)defaultStrokeWidth);
                this.drawAL((int)step.sPoint.x, (int)step.sPoint.y, (int)step.tPoint.x, (int)step.tPoint.y, this.mPaint, canvas, false);
                break;
            }
            case 31: {
                this.mPaint.setStrokeWidth((float)defaultStrokeWidth);
                this.drawAL((int)step.sPoint.x, (int)step.sPoint.y, (int)step.tPoint.x, (int)step.tPoint.y, this.mPaint, canvas, true);
                break;
            }
            case 7: {
                Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.point);
                if (step.color == 0) {
                    canvas.drawBitmap(bitmap, (float)step.sPoint.x, (float)step.sPoint.y, this.mPaint);
                    break;
                }
                canvas.drawBitmap(this.replaceBitmapColor(bitmap, step.color), (float)step.sPoint.x, (float)step.sPoint.y, this.mPaint);
            }
        }
    }

    private void calcRT() {
        Drawable d = this.getDrawable();
        if (d != null && d.getIntrinsicHeight() > 0 && d.getIntrinsicWidth() > 0) {
            int dwidth = d.getIntrinsicWidth();
            int dheight = d.getIntrinsicHeight();
            int vwidth = this.getWidth();
            int vheight = this.getHeight();
            LogManager.innerLog(TAG, "view.width:" + vwidth + " view.height:" + vheight + "drawable.width:" + dwidth + "drawable.height:" + dheight);
            if ((double)vwidth * 1.0 / (double)vheight > (double)dwidth * 1.0 / (double)dheight) {
                this.scaleX = this.scaleY = (float)vheight * 1.0f / (float)dheight;
                this.transX = ((float)vwidth - (float)dwidth * this.scaleX) * 0.5f;
                this.transY = 0.0f;
            } else {
                this.scaleX = this.scaleY = (float)vwidth * 1.0f / (float)dwidth;
                this.transX = 0.0f;
                this.transY = ((float)vheight - (float)dheight * this.scaleY) * 0.5f;
            }
        } else {
            this.scaleY = 0.0f;
            this.scaleX = 0.0f;
            this.transY = 0.0f;
            this.transX = 0.0f;
        }
        LogManager.innerLog(TAG, "scaleX:" + this.scaleX + " scaleY:" + this.scaleY + "transX:" + this.transX + "transY:" + this.transY);
    }

    protected void drawAL(int sx, int sy, int ex, int ey, Paint mPaint, Canvas canvas, boolean isdouble) {
        if (sx == ex && sy == ey) {
            ex = isdouble ? (ex += 16) : (ex += 8);
            this.drawAL(sx, sy, ex, ey, mPaint, canvas, isdouble);
            return;
        }
        canvas.drawLine((float)sx, (float)sy, (float)ex, (float)ey, mPaint);
        double H = 8.0;
        double L = 3.5;
        double awrad = Math.atan(L / H);
        double arraow_len = Math.sqrt(L * L + H * H);
        double[] arrXY_1 = this.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = this.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        double x_3 = (double)ex - arrXY_1[0];
        double y_3 = (double)ey - arrXY_1[1];
        double x_4 = (double)ex - arrXY_2[0];
        double y_4 = (double)ey - arrXY_2[1];
        Double X3 = new Double(x_3);
        int x3 = X3.intValue();
        Double Y3 = new Double(y_3);
        int y3 = Y3.intValue();
        Double X4 = new Double(x_4);
        int x4 = X4.intValue();
        Double Y4 = new Double(y_4);
        int y4 = Y4.intValue();
        Path triangle = new Path();
        triangle.moveTo((float)ex, (float)ey);
        triangle.lineTo((float)x3, (float)y3);
        triangle.lineTo((float)x4, (float)y4);
        triangle.close();
        canvas.drawPath(triangle, mPaint);
        if (isdouble) {
            double[] arrXY_3 = this.rotateVec(sx - ex, sy - ey, awrad, true, arraow_len);
            double[] arrXY_4 = this.rotateVec(sx - ex, sy - ey, -awrad, true, arraow_len);
            double x_5 = (double)sx - arrXY_3[0];
            double y_5 = (double)sy - arrXY_3[1];
            double x_6 = (double)sx - arrXY_4[0];
            double y_6 = (double)sy - arrXY_4[1];
            Path triangle2 = new Path();
            triangle2.moveTo((float)sx, (float)sy);
            triangle2.lineTo((float)x_5, (float)y_5);
            triangle2.lineTo((float)x_6, (float)y_6);
            triangle2.close();
            canvas.drawPath(triangle2, mPaint);
        }
    }

    protected double[] rotateVec(int px, int py, double ang, boolean isChLen, double newLen) {
        double[] mathstr = new double[2];
        double vx = (double)px * Math.cos(ang) - (double)py * Math.sin(ang);
        double vy = (double)px * Math.sin(ang) + (double)py * Math.cos(ang);
        if (isChLen) {
            double d = Math.sqrt(vx * vx + vy * vy);
            vx = vx / d * newLen;
            vy = vy / d * newLen;
            mathstr[0] = vx;
            mathstr[1] = vy;
        }
        return mathstr;
    }

    protected Bitmap replaceBitmapColor(Bitmap oldBitmap, int newColor) {
        Bitmap mBitmap = oldBitmap.copy(Bitmap.Config.ARGB_8888, true);
        int mBitmapWidth = mBitmap.getWidth();
        int mBitmapHeight = mBitmap.getHeight();
        for (int i = 0; i < mBitmapHeight; ++i) {
            for (int j = 0; j < mBitmapWidth; ++j) {
                int color = mBitmap.getPixel(j, i);
                if (color == 0) continue;
                mBitmap.setPixel(j, i, Color.argb((int)Color.alpha((int)color), (int)Color.red((int)newColor), (int)Color.green((int)newColor), (int)Color.blue((int)newColor)));
            }
        }
        return mBitmap;
    }
}

