/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.utils;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.SurveyInfoData;
import java.util.HashMap;
import java.util.Map;
import vhall.com.vss2.VssSdk;

public class SurveyInternal {
    public static final String KEY_SURVEY_ID = "survey_id";
    public static final String KEY_ROOMID = "roomId";
    public static final String KEY_WEBINAR_ID = "webinar_id";
    public static final String KEY_APPID = "appId";
    public static final String KEY_PAAS_ACCESS_TOKEN = "paas_access_token";
    public static final String KEY_USER_ID = "user_id";
    public static final String KEY_TOKEN = "token";
    public static final String KEY_INTERACT_TOKEN = "interact-token";

    public static String createSurveyUrl(WebinarInfo webinarInfo, SurveyInfoData info) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_SURVEY_ID, info.question_id);
        params.put(KEY_ROOMID, webinarInfo.vss_room_id);
        params.put(KEY_WEBINAR_ID, webinarInfo.webinar_id);
        params.put(KEY_APPID, VssSdk.getInstance().getAppId());
        if (webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().interact != null) {
            params.put(KEY_PAAS_ACCESS_TOKEN, webinarInfo.getWebinarInfoData().interact.paas_access_token);
        }
        params.put(KEY_USER_ID, webinarInfo.user_id);
        params.put(KEY_TOKEN, TokenManger.getToken());
        params.put(KEY_INTERACT_TOKEN, TokenManger.getInteractToken());
        return SurveyInternal.createSurveyUrl(params);
    }

    public static String createSurveyUrl(WebinarInfo webinarInfo, String question_id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_SURVEY_ID, question_id);
        params.put(KEY_ROOMID, webinarInfo.vss_room_id);
        params.put(KEY_WEBINAR_ID, webinarInfo.webinar_id);
        params.put(KEY_APPID, VssSdk.getInstance().getAppId());
        if (webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().interact != null) {
            params.put(KEY_PAAS_ACCESS_TOKEN, webinarInfo.getWebinarInfoData().interact.paas_access_token);
        }
        params.put(KEY_USER_ID, webinarInfo.user_id);
        params.put(KEY_TOKEN, TokenManger.getToken());
        params.put(KEY_INTERACT_TOKEN, TokenManger.getInteractToken());
        return SurveyInternal.createSurveyUrl(params);
    }

    public static String createSurveyUrl(Map<String, String> params) {
        if (NewH5ImManager.enter) {
            StringBuilder builder = new StringBuilder();
            for (String k : params.keySet()) {
                if (builder.length() == 0) {
                    builder.append("?");
                } else {
                    builder.append("&");
                }
                builder.append(String.format("%s=%s", k, params.get(k)));
            }
            return String.format("%s%s%s", VhallSDK.NEW_SURVEY_URL, "/v3/lives/question", builder.toString());
        }
        return VhallSDK.getSurveyUrl(params.get(KEY_SURVEY_ID), params.get(KEY_WEBINAR_ID), params.get(KEY_USER_ID));
    }
}

