/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.utils;

import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.vhall.business.HttpDataSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class FileUtil {
    private static final String app_name = "vhall";
    private static final String cache_dir = "vhall" + File.separator + "sdkcache";

    public static String getFileName(String filePath) {
        String name = "";
        try {
            name = filePath.substring(filePath.lastIndexOf("/"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static boolean isSDCardVisable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getCacheDir() {
        if (!FileUtil.isSDCardVisable()) {
            return null;
        }
        String footDir = Environment.getExternalStorageDirectory().getAbsolutePath();
        String cachPath = footDir + File.separator + cache_dir;
        File file = new File(cachPath);
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public static void downloadFile(final String localPath, String remotePath, final Handler handler) {
        Request request = new Request.Builder().url(remotePath).build();
        HttpDataSource.getOkHttpClient().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                handler.sendEmptyMessage(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                InputStream is = null;
                byte[] buf = new byte[2048];
                int len = 0;
                FileOutputStream fos = null;
                try {
                    is = response.body().byteStream();
                    long total = response.body().contentLength();
                    File file = new File(localPath);
                    fos = new FileOutputStream(file);
                    long sum = 0L;
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                        int progress = (int)((float)(sum += (long)len) * 1.0f / (float)total * 100.0f);
                        Message msg = Message.obtain();
                        msg.what = 2;
                        msg.arg1 = progress;
                        handler.sendMessage(msg);
                    }
                    fos.flush();
                    handler.sendEmptyMessage(1);
                }
                catch (Exception e) {
                    handler.sendEmptyMessage(0);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public static String readFile2String(String localFile) {
        String text = "";
        try {
            String encoding = "utf-8";
            File file = new File(localFile);
            if (file.isFile() && file.exists()) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = fis.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                byte[] b = outStream.toByteArray();
                fis.close();
                outStream.flush();
                outStream.close();
                text = new String(b);
                b = null;
            } else {
                System.out.println("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
            e.printStackTrace();
        }
        return text;
    }
}

