/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.utils;

import android.text.TextUtils;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.ops.WatermarkOption;

public class DocWatermarkHelper {
    public static boolean isDocWatermarkEnable(WebinarInfo webinarInfo) {
        return null != webinarInfo && null != webinarInfo.watermark && webinarInfo.watermark.isDocWatermarkEnable();
    }

    public static WatermarkOption makeWatermarkOption(WebinarInfo.Watermark watermark) {
        String wmText = watermark.docWatermarkType.getWatermarkText(VhallSDK.getUserId(), VhallSDK.getUserNickname());
        if (!TextUtils.isEmpty((CharSequence)wmText)) {
            int wmFontSize;
            float wmOpacity;
            String wmColor = watermark.docFontColor;
            if (!TextUtils.isEmpty((CharSequence)wmColor) && !wmColor.startsWith("#")) {
                wmColor = "#" + wmColor;
            }
            try {
                wmOpacity = Float.parseFloat(watermark.docTransparency) / 100.0f;
            }
            catch (NumberFormatException e) {
                wmOpacity = 1.0f;
            }
            try {
                wmFontSize = Integer.parseInt(watermark.docFontSize);
            }
            catch (NumberFormatException e) {
                wmFontSize = 20;
                e.printStackTrace();
            }
            return new WatermarkOption(wmText, wmColor, 30, wmOpacity, wmFontSize);
        }
        return null;
    }
}

