/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.warmup;

import android.content.Context;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.warmup.WarmUp;
import com.vhall.business.module.warmup.WatchWarmUpNewH5;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vhss.data.WarmInfoData;

public class WatchWarmUp
extends WarmUp {
    private WarmUp warmUp;

    private WatchWarmUp(Builder builder) {
        this.context = builder.context;
        if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
        Builder builder = new Builder();
        builder.callback(this.listener).context(this.context).chatCallback(this.chatCallback).callback(this.listener).messageCallback(this.messageCallback);
        if (this.vodPlayerView != null) {
            builder.vodPlayView(this.vodPlayerView);
        }
        if (webinarInfo.getWebinarInfoData() != null) {
            this.warmUp = new WatchWarmUpNewH5(builder);
        }
        if (this.warmUp != null) {
            this.warmUp.setWebinarInfo(webinarInfo);
        }
    }

    @Override
    public void start(WarmInfoData.RecordListBean recordBean) {
        if (this.warmUp != null) {
            this.warmUp.start(recordBean);
        }
    }

    @Override
    public void stop() {
        if (this.warmUp != null) {
            this.warmUp.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.warmUp != null) {
            this.warmUp.destroy();
        }
    }

    @Override
    public void pause() {
        if (this.warmUp != null) {
            this.warmUp.pause();
        }
    }

    @Override
    public void resume() {
        if (this.warmUp != null) {
            this.warmUp.resume();
        }
    }

    @Override
    public long getDuration() {
        if (this.warmUp != null) {
            return this.warmUp.getDuration();
        }
        return 0L;
    }

    @Override
    public long getCurrentPosition() {
        if (this.warmUp != null) {
            return this.warmUp.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public void seekTo(long position) {
        if (this.warmUp != null) {
            this.warmUp.seekTo(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (this.warmUp != null) {
            return this.warmUp.getPlayerState();
        }
        return null;
    }

    @Override
    public float setSpeed(float speed) {
        if (this.warmUp != null) {
            return this.warmUp.setSpeed(speed);
        }
        return 1.0f;
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.warmUp != null) {
            this.warmUp.setScaleType(scaleType);
        }
    }

    @Override
    public void setDefinition(String definition) {
        if (this.warmUp != null) {
            this.warmUp.setDefinition(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.warmUp != null) {
            return this.warmUp.isPlaying();
        }
        return false;
    }

    public static class Builder {
        Context context;
        VHPlayerListener listener;
        VodPlayerView vodPlayerView;
        ChatServer.Callback chatCallback;
        MessageServer.Callback messageCallback;

        public Builder chatCallback(ChatServer.Callback chatCallback) {
            this.chatCallback = chatCallback;
            return this;
        }

        public Builder messageCallback(MessageServer.Callback messageCallback) {
            this.messageCallback = messageCallback;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder vodPlayView(VodPlayerView vodPlayerView) {
            this.vodPlayerView = vodPlayerView;
            return this;
        }

        public Builder callback(VHPlayerListener listener) {
            this.listener = listener;
            return this;
        }

        public WatchWarmUp build() {
            if (this.vodPlayerView == null) {
                throw new IllegalArgumentException("containerLayout can not be null");
            }
            if (this.context == null) {
                this.context = this.vodPlayerView.getContext();
            }
            return new WatchWarmUp(this);
        }
    }
}

