/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.sign;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.sign.ISign;
import com.vhall.business.module.sign.SignMessageCallBack;

public class SignServer
implements ISign {
    private WebinarInfo webinarInfo;
    private Context context;
    private SignMessageCallBack signMessageCallBack;

    private void SignServer() {
    }

    private SignServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.signMessageCallBack = builder.signMessageCallBack;
        if (this.signMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_sign", this.signMessageCallBack);
        }
    }

    @Override
    public void performSignIn(String signId, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.performSignIn(this.webinarInfo.vss_room_id, signId, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        SignMessageCallBack signMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder signMessageCallBack(SignMessageCallBack signMessageCallBack) {
            this.signMessageCallBack = signMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public SignServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new SignServer(this);
        }
    }
}

