/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.notice;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.notice.INotice;
import com.vhall.business.module.notice.NoticeMessageCallBack;
import com.vhall.vhss.data.NoticeListInfoData;

public class NoticeServer
implements INotice {
    private WebinarInfo webinarInfo;
    private Context context;
    private NoticeMessageCallBack noticeMessageCallBack;

    private void NoticeServer() {
    }

    private NoticeServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.noticeMessageCallBack = builder.noticeMessageCallBack;
        if (this.noticeMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_notice", this.noticeMessageCallBack);
        }
        LogReportManager.doReport("115028");
    }

    @Override
    public void getNoticeList(int page, int limit, RequestDataCallbackV2<NoticeListInfoData> callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.getNoticeList(this.webinarInfo.vss_room_id, page, limit, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        NoticeMessageCallBack noticeMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder noticeMessageCallBack(NoticeMessageCallBack noticeMessageCallBack) {
            this.noticeMessageCallBack = noticeMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public NoticeServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new NoticeServer(this);
        }
    }
}

