/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.message;

import android.text.TextUtils;
import com.vhall.business.MessageServer;
import com.vhall.business.module.exam.ExamMessageCallBack;
import com.vhall.business.module.message.IMessageCallBack;
import java.util.List;
import org.json.JSONObject;
import vhall.com.vss2.data.MessageData;

public class MessageDealUtils {
    public static MessageServer.MsgInfo dealPushExam(MessageData msg, List<IMessageCallBack> messageCallBackList) {
        MessageServer.MsgInfo messageInfo = MessageDealUtils.dealBaseData(msg);
        MessageServer.ExamInfo examInfo = new MessageServer.ExamInfo();
        if (msg != null && msg.getImMessageInfo() != null) {
            JSONObject objData = null;
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
            }
            catch (Exception e) {
                objData = new JSONObject();
            }
            switch (msg.getType()) {
                case "paper_send": {
                    messageInfo.event = 115;
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.send_time = objData.optString("send_time");
                    examInfo.send_time_stamp = objData.optString("send_time_stamp");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    break;
                }
                case "paper_end": {
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = 116;
                    break;
                }
                case "paper_auto_end": {
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = 117;
                    break;
                }
                case "paper_send_rank": {
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = 118;
                    break;
                }
                case "paper_auto_send_rank": {
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = 119;
                }
            }
            messageInfo.examInfo = examInfo;
            if (messageCallBackList != null && messageCallBackList.size() > 0) {
                for (IMessageCallBack iMessageCallBack : messageCallBackList) {
                    if (!(iMessageCallBack instanceof ExamMessageCallBack)) continue;
                    ExamMessageCallBack examMessageCallBack = (ExamMessageCallBack)iMessageCallBack;
                    switch (msg.getType()) {
                        case "paper_send": {
                            examMessageCallBack.examPush(messageInfo);
                            break;
                        }
                        case "paper_end": {
                            examMessageCallBack.examEnd(messageInfo);
                            break;
                        }
                        case "paper_auto_end": {
                            examMessageCallBack.examAutoEnd(messageInfo);
                            break;
                        }
                        case "paper_send_rank": {
                            examMessageCallBack.examSendRank(messageInfo);
                            break;
                        }
                        case "paper_auto_send_rank": {
                            examMessageCallBack.examAutoSendRank(messageInfo);
                        }
                    }
                }
            }
        }
        return messageInfo;
    }

    private static MessageServer.MsgInfo dealBaseData(MessageData msg) {
        MessageServer.MsgInfo messageInfo = new MessageServer.MsgInfo();
        if (msg != null && msg.getImMessageInfo() != null) {
            JSONObject objData;
            String targetId = "";
            String roomJoinId = "";
            String nickName = "";
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
                targetId = objData.optString("target_id");
                roomJoinId = objData.optString("room_join_id");
                String roleName = objData.optString("room_role");
                if (TextUtils.isEmpty((CharSequence)roleName)) {
                    roleName = objData.optString("role_name", "2");
                }
                nickName = objData.optString("nick_name");
                messageInfo.roomJoinId = roomJoinId;
                messageInfo.role = roleName;
                messageInfo.targetId = targetId;
                messageInfo.nick_name = nickName;
            }
            catch (Exception e) {
                objData = new JSONObject();
            }
            messageInfo.mOriginData = objData;
            messageInfo.responseImMessageInfo = msg.getImMessageInfo();
            messageInfo.msg_id = msg.getImMessageInfo().getMsg_id();
        }
        return messageInfo;
    }
}

