/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.card;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.module.card.CardMessageCallBack;
import com.vhall.business.module.card.ICard;
import com.vhall.vhss.data.CardsInfoData;

public class CardServer
implements ICard {
    private WebinarInfo webinarInfo;
    private Context context;
    private CardMessageCallBack cardMessageCallBack;

    private void CardServer() {
    }

    private CardServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.cardMessageCallBack = builder.cardMessageCallBack;
        if (this.cardMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_card", this.cardMessageCallBack);
        }
        LogReportManager.doReport("115044");
    }

    @Override
    public void getCardList(int page, int limit, RequestDataCallbackV2<CardsInfoData> callBack) {
        if (this.webinarInfo != null) {
            limit = limit <= 0 ? 10 : limit;
            page = page < 1 ? 1 : page;
            WebinarInfoRemote.getCardList(this.webinarInfo.webinar_id, this.webinarInfo.switch_id, page, limit, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void getCardInfo(String id, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack) {
        if (this.webinarInfo != null) {
            WebinarInfoRemote.getCardInfo(this.webinarInfo.webinar_id, id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static void getCardInfo(CardsInfoData.CardInfo cardInfo, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack) {
        if (cardInfo != null) {
            CardServer.getCardInfo(cardInfo.webinar_id, cardInfo.id, callBack);
        }
    }

    public static void getCardInfo(String webinar_id, String card_id, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack) {
        if (webinar_id != null) {
            WebinarInfoRemote.getCardInfo(webinar_id, card_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinar_id can not be null");
        }
    }

    public static void cardClicked(CardsInfoData.CardInfo cardInfo, RequestDataCallbackV2<String> callBack) {
        if (cardInfo != null) {
            CardServer.cardClicked(cardInfo.webinar_id, cardInfo.switch_id, cardInfo.id, callBack);
        }
    }

    public static void cardClicked(String webinar_id, String switch_id, String card_id, RequestDataCallbackV2<String> callBack) {
        if (webinar_id != null) {
            WebinarInfoRemote.cardClicked(webinar_id, switch_id, card_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinar_id can not be null");
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        CardMessageCallBack cardMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder cardMessageCallBack(CardMessageCallBack cardMessageCallBack) {
            this.cardMessageCallBack = cardMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public CardServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new CardServer(this);
        }
    }
}

