/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.impl;

import com.vhall.business.VhallSDK;
import com.vhall.business.core.IInteractiveNetApi;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.impl.VhssSimpleCallBack;
import com.vhall.business.support.WrapperCallback;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.GuestJoinInfoData;
import com.vhall.vhss.data.RoundUserListData;
import com.vhall.vhss.data.UserStateListData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.ChatNetworkRequest;
import com.vhall.vhss.network.DocNetworkRequest;
import com.vhall.vhss.network.InteractNetworkRequest;

class InteractiveInternalApi
implements IInteractiveNetApi {
    static String visitorId = "";

    InteractiveInternalApi() {
    }

    @Override
    public void rejectApply(String room_id, String receive_account_id, RequestCallback callBack) {
        InteractNetworkRequest.rejectApply(room_id, receive_account_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void agreeApply(String room_id, String receive_account_id, RequestCallback callBack) {
        InteractNetworkRequest.agreeApply(room_id, receive_account_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void rejectInvite(String room_id, RequestCallback callBack) {
        InteractNetworkRequest.rejectInvite(room_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void agreeInvite(String room_id, RequestCallback callBack) {
        InteractNetworkRequest.agreeInvite(room_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void setMainScreen(String room_id, String receive_account_id, RequestCallback callBack) {
        InteractNetworkRequest.setMainScreen(room_id, receive_account_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void setDeviceStatus(String room_id, String receive_account_id, String device, String status, RequestCallback callBack) {
        InteractNetworkRequest.setDeviceStatus(room_id, receive_account_id, device, status, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void getDocList(String webinar_id, String room_id, int page, int limit, String keyword, RequestDataCallbackV2<DocListInfoData> callBack) {
        DocNetworkRequest.getDocList(webinar_id, room_id, page, limit, keyword, new WrapperCallback<DocListInfoData>(callBack));
    }

    @Override
    public void setMainSpeaker(final String room_id, final String receive_account_id, final RequestCallback callBack) {
        DocNetworkRequest.setDocPermission(room_id, receive_account_id, new CallBack(){

            public void onSuccess(Object result) {
                InteractiveInternalApi.this.setMainScreen(room_id, receive_account_id, callBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                callBack.onError(eventCode, msg);
            }
        });
    }

    @Override
    public void downMic(String room_id, String receive_account_id, RequestCallback callBack) {
        InteractNetworkRequest.onSpeak(room_id, receive_account_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void inviteUserSpeak(String room_id, String receive_account_id, RequestCallback callBack) {
        InteractNetworkRequest.inviteUserSpeak(room_id, receive_account_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void getLimitUserList(String room_id, int pos, int limit, RequestDataCallbackV2<UserStateListData> callBack) {
        ChatNetworkRequest.chatSpecialList(room_id, pos, limit, new WrapperCallback<UserStateListData>(callBack));
    }

    @Override
    public void getOnlineUserList(String room_id, int pos, int limit, RequestDataCallbackV2<UserStateListData> callBack) {
        ChatNetworkRequest.chatOnlineList(room_id, pos, limit, new WrapperCallback<UserStateListData>(callBack));
    }

    @Override
    public void setKickOut(String room_id, String channel_id, String receive_account_id, String status, RequestCallback callBack) {
        ChatNetworkRequest.setKicked(room_id, channel_id, receive_account_id, status, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void setBanned(String room_id, String channel_id, String receive_account_id, String status, RequestCallback callBack) {
        ChatNetworkRequest.setBanned(room_id, channel_id, receive_account_id, status, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void setUserNoSpeak(String room_id, RequestCallback callBack) {
        InteractNetworkRequest.ownerNoSpeak(room_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void cancelApply(String room_id, RequestCallback callBack) {
        InteractNetworkRequest.cancelApply(room_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void apply(String room_id, RequestCallback callBack) {
        InteractNetworkRequest.apply(room_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void setHandsUp(String room_id, String status, RequestCallback callBack) {
        InteractNetworkRequest.setHandsUp(room_id, status, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void joinWebinar(String webinarId, String password, String nickname, String avatar, String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack) {
        ActivityNetworkRequest.guestJoinWebinar(webinarId, password, nickname, avatar, type, visitorId, new GuestJoinRoom(webinarId, callBack));
    }

    @Override
    public void getRoundUsers(String room_id, String isNext, final RequestDataCallback callBack) {
        ActivityNetworkRequest.getRoundUsers(room_id, isNext, new CallBack<RoundUserListData>(){

            @Override
            public void onSuccess(RoundUserListData result) {
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    class GuestJoinRoom
    implements CallBack<GuestJoinInfoData> {
        private String webinarId;
        private WebinarInfoDataSource.LoadWebinarInfoCallback mCallBack;

        public GuestJoinRoom(String webinarId, WebinarInfoDataSource.LoadWebinarInfoCallback mCallBack) {
            this.webinarId = webinarId;
            this.mCallBack = mCallBack;
        }

        @Override
        public void onSuccess(GuestJoinInfoData result) {
            visitorId = result.visitor_id;
            VhallSDK.initBroadcast(this.webinarId, "", result.live_token, "", "", new WebinarInfoDataSource.LoadWebinarInfoCallback(){

                @Override
                public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                    GuestJoinRoom.this.mCallBack.onWebinarInfoLoaded(jsonStr, webinarInfo);
                }

                @Override
                public void onError(int errorCode, String errorMsg) {
                    GuestJoinRoom.this.mCallBack.onError(errorCode, errorMsg);
                }
            });
        }

        @Override
        public void onError(int eventCode, String msg) {
            this.mCallBack.onError(eventCode, msg);
        }
    }
}

