/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.data.source;

import android.content.Context;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.source.UserInfoDataSource;
import org.json.JSONObject;

public class UserInfoRepository
implements UserInfoDataSource {
    private static UserInfoRepository INSTANCE;
    private final UserInfoDataSource userInfoRemoteDataSource;
    private final UserInfoDataSource userInfoLocalDataSource;

    private UserInfoRepository(UserInfoDataSource userInfoRemoteDataSource, UserInfoDataSource userInfoLocalDataSource) {
        this.userInfoRemoteDataSource = userInfoRemoteDataSource;
        this.userInfoLocalDataSource = userInfoLocalDataSource;
    }

    public static UserInfoRepository getInstance(UserInfoDataSource userInfoRemoteDataSource, UserInfoDataSource userInfoLocalDataSource) {
        if (INSTANCE == null) {
            INSTANCE = new UserInfoRepository(userInfoRemoteDataSource, userInfoLocalDataSource);
        }
        return INSTANCE;
    }

    @Override
    public void getUserInfoFromRemote(String username, String userpass, UserInfoDataSource.UserInfoCallback callback) {
        this.userInfoRemoteDataSource.getUserInfoFromRemote(username, userpass, callback);
    }

    @Override
    public void clearUserInfo(Context context) {
        this.userInfoLocalDataSource.clearUserInfo(context);
    }

    @Override
    public void sendChat(String url, String token, String content, RequestCallback callback) {
        this.userInfoRemoteDataSource.sendChat(url, token, content, callback);
    }

    @Override
    public void sendCustom(String url, String token, JSONObject content, RequestCallback callback) {
        this.userInfoRemoteDataSource.sendCustom(url, token, content, callback);
    }

    @Override
    public void sendComment(String webinar_id, String content, String user_id, RequestCallback callback) {
        this.userInfoRemoteDataSource.sendComment(webinar_id, content, user_id, callback);
    }

    @Override
    public void sendQuestion(String user_id, String webinar_id, String content, RequestCallback callback) {
        this.userInfoRemoteDataSource.sendQuestion(user_id, webinar_id, content, callback);
    }

    @Override
    public void saveAppkey(Context context, String app_key) {
        this.userInfoLocalDataSource.saveAppkey(context, app_key);
    }

    @Override
    public String getAppkey(Context context) {
        return this.userInfoLocalDataSource.getAppkey(context);
    }
}

