/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.data;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.HttpDataSource;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.data.source.InteractiveDataSource;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.utils.LogManager;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.vhss.api.CoreApiConstant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebinarInfoRemoteDataSource
implements WebinarInfoDataSource {
    private static final String TAG = WebinarInfoRemoteDataSource.class.getName();
    private static Handler mDelivery;
    private static WebinarInfoRemoteDataSource INSTANCE;

    private WebinarInfoRemoteDataSource() {
    }

    public static WebinarInfoRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebinarInfoRemoteDataSource();
            mDelivery = new Handler(Looper.getMainLooper());
        }
        return INSTANCE;
    }

    @Override
    public void getBroadcastWebinarInfo(String id, final String access_token, String user_id, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("access_token", access_token);
        map.put("user_id", user_id == null ? "" : user_id);
        HttpDataSource.post("webinar/start", "start", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        LogReporter.getInstance().setErr(e.getMessage());
                        LogReporter.getInstance().onCollection("2003", false, null);
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.dealWatchRespone("", access_token, resultStr, callback);
                            LogReporter.getInstance().onCollection("2003", null);
                        } else {
                            LogReporter.getInstance().onCollection("2003", false, null);
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getWatchWebinarInfo(String id, String name, String email, String password, final String vhallId, String record_id, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("name", name == null ? "" : name);
        map.put("email", email == null ? "" : email);
        map.put("record_id", record_id == null ? "" : record_id);
        map.put("pass", password == null ? "" : password);
        map.put("user_id", vhallId == null ? "" : vhallId);
        HttpDataSource.post("webinar/watch", "watch", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        LogReporter.getInstance().onCollection("2004", false, new JSONObject());
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                VLog.e((String)TAG, (String)("getWatchWebinarInfo: " + resultStr));
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.dealWatchRespone(vhallId, "", resultStr, callback);
                            LogReporter.getInstance().onCollection("2004", true, new JSONObject());
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                            LogReporter.getInstance().onCollection("2004", false, new JSONObject());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void stopBroadcast(String id, String access_token, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", access_token);
        map.put("id", id);
        HttpDataSource.post("webinar/stop", "stop", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(resultStr);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                callback.onSuccess();
                            } else {
                                VhallCallback.ErrorCallback(callback, code, msg);
                            }
                        }
                        catch (Exception e) {
                            VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("join_id", join_id);
        map.put("lottery_id", lottery_id);
        map.put("name", name == null ? "" : name);
        map.put("phone", phone == null ? "" : phone);
        HttpDataSource.post("webinar/setlotteryinfo", "setlotteryinfo", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(resultStr);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                callback.onSuccess();
                            } else {
                                VhallCallback.ErrorCallback(callback, code, msg);
                            }
                        }
                        catch (Exception e) {
                            VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getChatHistory(String join_id, String webinar_id, boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("join_id", join_id);
        map.put("webinar_id", webinar_id);
        map.put("show_all", show_all ? "1" : "0");
        HttpDataSource.post("webinar/chat-history", "chathistory", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        chatRecordCallback.onFailed(20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                if (chatRecordCallback != null) {
                    mDelivery.post(new Runnable(){

                        @Override
                        public void run() {
                            if (response.code() == 200) {
                                WebinarInfoRemoteDataSource.this.dealChatHistoryResult(resultStr, chatRecordCallback);
                            } else {
                                chatRecordCallback.onFailed(response.code(), response.message());
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void getCommentHistory(String join_id, String webinar_id, String limit, String pos, final ChatServer.ChatRecordCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("join_id", join_id);
        map.put("webinar_id", webinar_id);
        map.put("limit", limit);
        map.put("pos", pos);
        HttpDataSource.post("webinar/comment-history", "commenthistory", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailed(20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.dealCommentData(resultStr, callback);
                        } else {
                            callback.onFailed(response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void performSignIn(String webinarId, String userId, String name, String signId, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("webinar_id", webinarId);
        map.put("user_id", userId);
        map.put("name", name == null ? "" : name);
        map.put("sign_id", signId);
        HttpDataSource.post("webinar/sign-record", "sign-record", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.dealSignInData(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getPublishURL(String url, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HttpDataSource.get(url, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            callback.onWebinarInfoLoaded(resultStr, null);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getPublishToken(String url, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HttpDataSource.get(url, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            callback.onWebinarInfoLoaded(resultStr, null);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getAnswerList(String userId, String webinarId, final ChatServer.ChatRecordCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            callback.onFailed(20002, "userId error");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user_id", userId);
        map.put("webinar_id", webinarId);
        HttpDataSource.post("question/lists", "lists", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailed(20002, e.getMessage());
                        }
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                LogManager.innerLog(TAG, resultStr);
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.parseJson(resultStr, callback);
                        } else {
                            callback.onFailed(response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onHand(String joinId, String webinarId, int type, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("join_uid", joinId);
        map.put("webinar_id", webinarId);
        map.put("type", String.valueOf(type));
        HttpDataSource.post("interact/handsup", "handsup", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.parseJsonForBase(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getInteractiveInfo(final String webinarId, final String name, final String email, final String pass, final String user_id, final InteractiveDataSource.InteractiveCallback callback) {
        WebinarInfoRemote.getInstance().getWatchWebinarInfo(webinarId, name, email, pass == null ? "" : pass, user_id == null ? "" : user_id, "", "", null, new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (webinarInfo != null) {
                    String userInfoStr = com.vhall.framework.VhallSDK.getInstance().getmUserInfo();
                    if (!TextUtils.isEmpty((CharSequence)userInfoStr)) {
                        try {
                            JSONObject userInfo = new JSONObject(userInfoStr);
                            userInfo.put("pv", webinarInfo.online);
                            com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toString());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    if (callback != null) {
                        callback.onSuccess(webinarInfo);
                    }
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("webinar_id", webinarId);
                    map.put("name", name);
                    map.put("email", email);
                    map.put("pass", pass == null ? "" : pass);
                    map.put("user_id", user_id == null ? "" : user_id);
                    HttpDataSource.post("interact/info", "info", map, new Callback(){

                        public void onFailure(Call call, final IOException e) {
                            mDelivery.post(new Runnable(){

                                @Override
                                public void run() {
                                    VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                                }
                            });
                        }

                        public void onResponse(Call call, final Response response) throws IOException {
                            if (callback == null) {
                                return;
                            }
                            final String resultStr = response.body().string();
                            mDelivery.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (response.code() == 200) {
                                        WebinarInfoRemoteDataSource.this.parseJsonForInfo(resultStr, callback);
                                    } else {
                                        VhallCallback.ErrorCallback(callback, response.code(), response.message());
                                    }
                                }
                            });
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    @Override
    public void replyInvitation(String joinId, String webinarId, int type, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("join_uid", joinId);
        map.put("webinar_id", webinarId);
        map.put("type", String.valueOf(type));
        map.put("api_name", "reply-invite");
        HttpDataSource.post("interact/reply-invite", "reply-invite", map, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resStr = response.body().string();
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            WebinarInfoRemoteDataSource.this.parseJsonForBase(resStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    private void parseJsonForInfo(String resultStr, InteractiveDataSource.InteractiveCallback callback) {
        try {
            JSONObject result = new JSONObject(resultStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.getJSONObject("data");
                WebinarInfo webinarInfo = new WebinarInfo();
                webinarInfo.enterToken = data.optString("room_token");
                webinarInfo.msg_server = data.optString("msg_server");
                webinarInfo.msg_token = data.optString("msg_token");
                webinarInfo.join_id = data.optString("join_uid");
                webinarInfo.vss_room_id = data.optString("vss_room_id");
                webinarInfo.vss_token = data.optString("vss_token");
                if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                    webinarInfo.is_new_version = 1;
                }
                webinarInfo.webinar_id = String.valueOf(data.optInt("webinar_id"));
                webinarInfo.role_name = String.valueOf(data.optString("role_name"));
                webinarInfo.nick_name = String.valueOf(data.optString("nick_name"));
                if (webinarInfo.data_report == null) {
                    webinarInfo.data_report = new WebinarInfo.Report();
                }
                if (data.has("data_report")) {
                    JSONObject dataReport = data.optJSONObject("data_report");
                    if (dataReport == null) {
                        return;
                    }
                    webinarInfo.data_report.topic = dataReport.optString("topic");
                    webinarInfo.data_report.vtype = dataReport.optString("vtype");
                    webinarInfo.data_report.guid = dataReport.optString("guid");
                    webinarInfo.data_report.vfid = dataReport.optString("vfid");
                    webinarInfo.data_report.vid = dataReport.optString("vid");
                    webinarInfo.data_report.host = dataReport.optString("host");
                }
                callback.onSuccess(webinarInfo);
            } else {
                callback.onError(code, msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void parseJsonForBase(String resultStr, RequestCallback callback) {
        try {
            JSONObject result = new JSONObject(resultStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                callback.onSuccess();
            } else {
                callback.onError(code, msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void parseJson(String resultStr, ChatServer.ChatRecordCallback callback) {
        ArrayList<ChatServer.ChatInfo> answerList = new ArrayList<ChatServer.ChatInfo>();
        try {
            JSONObject result = new JSONObject(resultStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONArray answerArray = result.optJSONArray("data");
                for (int i = 0; i < answerArray.length(); ++i) {
                    ChatServer.ChatInfo chatInfo = new ChatServer.ChatInfo();
                    JSONObject obj = answerArray.optJSONObject(i);
                    ChatServer.ChatInfo.QuestionData questionData = new ChatServer.ChatInfo.QuestionData();
                    questionData.id = obj.optString("id");
                    questionData.nick_name = obj.optString("nick_name");
                    questionData.content = obj.optString("content");
                    questionData.join_id = obj.optString("join_id");
                    questionData.created_at = obj.optString("created_at");
                    questionData.role_name = obj.optString("role_name");
                    questionData.avatar = obj.optString("avatar");
                    questionData.type = obj.optString("type");
                    JSONObject answerObj = obj.optJSONObject("answer");
                    if (answerObj != null) {
                        ChatServer.ChatInfo.QuestionData answerData = new ChatServer.ChatInfo.QuestionData();
                        answerData.id = answerObj.optString("id");
                        answerData.avatar = answerObj.optString("avatar");
                        answerData.nick_name = answerObj.optString("nick_name");
                        answerData.content = answerObj.optString("content");
                        answerData.join_id = answerObj.optString("join_id");
                        answerData.created_at = answerObj.optString("created_at");
                        answerData.role_name = answerObj.optString("role_name");
                        answerData.is_open = answerObj.optInt("is_open");
                        questionData.answer = answerData;
                    }
                    chatInfo.questionData = questionData;
                    answerList.add(chatInfo);
                }
                callback.onDataLoaded(answerList);
            } else {
                callback.onFailed(code, msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void dealCommentData(String jsonStr, ChatServer.ChatRecordCallback callback) {
        ArrayList<ChatServer.ChatInfo> commentList = new ArrayList<ChatServer.ChatInfo>();
        JSONObject data = null;
        try {
            data = new JSONObject(jsonStr);
            String msg = data.optString("msg");
            int code = data.optInt("code");
            if (code == 200) {
                JSONArray array = data.optJSONArray("data");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.optJSONObject(i);
                    ChatServer.ChatInfo info = new ChatServer.ChatInfo();
                    info.account_id = obj.optString("account_id");
                    info.id = obj.optString("id");
                    info.user_name = obj.optString("user_name");
                    info.avatar = obj.optString("avatar");
                    info.room = obj.optString("room");
                    info.time = obj.optString("time");
                    info.role = obj.optString("role_name");
                    info.roleName = ChatServer.changeRoleToRoleName(info.role);
                    info.event = "msg";
                    JSONObject dataText = obj.optJSONObject("data");
                    JSONArray atListArray = obj.optJSONArray("atList");
                    ArrayList<ChatServer.ChatInfo.AtListBean> atList = new ArrayList<ChatServer.ChatInfo.AtListBean>();
                    if (atListArray != null) {
                        for (int j = 0; j < atListArray.length(); ++j) {
                            JSONObject atObj = atListArray.optJSONObject(j);
                            ChatServer.ChatInfo.AtListBean atBean = new ChatServer.ChatInfo.AtListBean();
                            atBean.nickName = atObj.optString("nickName");
                            atBean.accountId = atObj.optString("accountId");
                            atBean.index = atObj.optInt("index");
                            atList.add(atBean);
                        }
                    }
                    info.atList = atList;
                    ChatServer.ChatInfo.ChatData msgData = new ChatServer.ChatInfo.ChatData();
                    String text = dataText.optString("text");
                    for (ChatServer.ChatInfo.AtListBean bean : atList) {
                        text = text.replace("***" + bean.nickName, "@" + bean.nickName);
                    }
                    msgData.text = text;
                    info.msgData = msgData;
                    ChatServer.ChatInfo.ReplyMsg replyMsg = new ChatServer.ChatInfo.ReplyMsg();
                    JSONObject replyObj = obj.optJSONObject("replyMsg");
                    if (replyObj != null) {
                        replyMsg.type = replyObj.optString("type");
                        replyMsg.avatar = replyObj.optString("avatar");
                        replyMsg.account_id = replyObj.optString("sendId");
                        replyMsg.user_name = replyObj.optString("nickName");
                        replyMsg.role = replyObj.optString("roleName");
                        replyMsg.roleName = ChatServer.changeRoleToRoleName(replyMsg.role);
                        ChatServer.ChatInfo.ReplyMsg.Content content = new ChatServer.ChatInfo.ReplyMsg.Content();
                        JSONObject contentObj = replyObj.optJSONObject("content");
                        content.type = contentObj.optString("type");
                        content.textContent = contentObj.optString("text_content");
                        replyMsg.content = content;
                        replyMsg.time = replyObj.optString("sendTime");
                        info.replyMsg = replyMsg;
                    } else {
                        info.replyMsg = null;
                    }
                    if (info == null) continue;
                    commentList.add(info);
                }
                callback.onDataLoaded(commentList);
            } else {
                callback.onFailed(code, msg);
            }
        }
        catch (Exception e) {
            callback.onFailed(20002, e.getMessage());
        }
    }

    private void dealWatchRespone(String user_id, String broToken, String responseStr, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        try {
            JSONObject obj = new JSONObject(responseStr);
            String msg = obj.optString("msg");
            int code = obj.optInt("code");
            if (code == 200) {
                JSONArray quality;
                JSONObject dataResult = obj.optJSONObject("data");
                WebinarInfo webinarInfo = new WebinarInfo();
                int userforbid = dataResult.optInt("user_forbidchat");
                int allforbid = dataResult.optInt("all_forbidchat");
                webinarInfo.chatforbid = userforbid == 1 || allforbid == 1;
                webinarInfo.media_srv = dataResult.optString("media_srv");
                webinarInfo.streamtoken = dataResult.optString("streamtoken");
                webinarInfo.dispatch_host = dataResult.optString("dispatch_host");
                webinarInfo.webinar_id = dataResult.optString("webinar_id");
                webinarInfo.msg_token = dataResult.optString("msg_token");
                webinarInfo.host = dataResult.optString("host");
                webinarInfo.layout = dataResult.optInt("layout");
                webinarInfo.buffer = dataResult.optInt("buffer");
                webinarInfo.video = dataResult.optString("video");
                webinarInfo.rtmp_video = dataResult.optString("rtmp_video");
                webinarInfo.docurl = dataResult.optString("docurl");
                webinarInfo.status = dataResult.optInt("status");
                webinarInfo.page = dataResult.optInt("page");
                webinarInfo.doc = dataResult.optString("doc");
                webinarInfo.join_id = dataResult.optString("join_id");
                LogReporter.getInstance().setUserid("".equals(VhallSDK.getUserId()) ? webinarInfo.join_id : VhallSDK.getUserId());
                webinarInfo.msg_server = dataResult.optString("msg_server");
                webinarInfo.chat_server = dataResult.optString("chat_server");
                webinarInfo.chat_token = dataResult.optString("chat_token");
                webinarInfo.publish_server = dataResult.optString("publish_server");
                webinarInfo.session_id = dataResult.optString("session_id");
                webinarInfo.user_id = user_id;
                webinarInfo.broadcastToken = broToken;
                webinarInfo.use_white_board = dataResult.optInt("use_white_board");
                webinarInfo.use_doc = dataResult.optInt("use_doc");
                webinarInfo.is_publish_vr = dataResult.optInt("is_publish_vr");
                webinarInfo.against_url = dataResult.optString("against_url");
                webinarInfo.against_token = dataResult.optString("against_token");
                webinarInfo.video_path = dataResult.optString("video_path");
                webinarInfo.is_interact = dataResult.optString("is_interact");
                webinarInfo.hands_up = dataResult.optString("hands_up");
                webinarInfo.enterToken = dataResult.optString("room_token");
                webinarInfo.vss_room_id = dataResult.optString("vss_room_id");
                webinarInfo.vss_token = dataResult.optString("vss_token");
                webinarInfo.mainId = dataResult.optString("mainId");
                if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                    webinarInfo.is_new_version = 1;
                }
                if (TextUtils.isEmpty((CharSequence)webinarInfo.hands_up)) {
                    webinarInfo.hands_up = "0";
                }
                webinarInfo.online = dataResult.optInt("online");
                webinarInfo.question_status = dataResult.optInt("question_status");
                webinarInfo.setCast_screen(dataResult.optInt("cast_screen"));
                WebinarInfo.Notice notice = new WebinarInfo.Notice();
                JSONObject noticeObj = dataResult.optJSONObject("notice");
                if (noticeObj != null) {
                    notice.content = noticeObj.optString("content");
                    notice.publish_release_time = noticeObj.optString("publish_release_time");
                    if (noticeObj.has("duration")) {
                        notice.duration = noticeObj.optInt("duration");
                    }
                }
                webinarInfo.cheat_num = dataResult.optDouble("cheat_num");
                webinarInfo.notice = notice;
                WebinarInfo.Watermark watermark = new WebinarInfo.Watermark();
                JSONObject watermarkObj = dataResult.optJSONObject("watermark");
                if (watermarkObj != null) {
                    watermark.imgUrl = watermarkObj.optString("img_url");
                    if (!watermark.imgUrl.contains("http")) {
                        watermark.imgUrl = "https:" + watermark.imgUrl;
                    }
                    watermark.imgAlpha = Float.valueOf(watermarkObj.optString("img_alpha")).floatValue() / 100.0f;
                    String position = watermarkObj.optString("img_position");
                    watermark.imgPosition = TextUtils.isEmpty((CharSequence)position) ? 0 : Integer.parseInt(position);
                }
                webinarInfo.watermark = watermark;
                if (webinarInfo.status == 1) {
                    JSONObject definitionsResult;
                    JSONArray streams;
                    JSONObject rtmpResult;
                    JSONObject hlsdefinitionsResult;
                    JSONArray streams2;
                    JSONObject hlsResult = dataResult.optJSONObject("hls");
                    if (hlsResult != null && (streams2 = hlsResult.optJSONArray("streams")) != null && streams2.length() > 0) {
                        for (int i = 0; i < streams2.length(); ++i) {
                            JSONObject jsonObject2 = (JSONObject)streams2.opt(i);
                            WebinarInfo.Stream stream = new WebinarInfo().new WebinarInfo.Stream();
                            stream.name = jsonObject2.optString("name");
                            stream.src = jsonObject2.optString("src");
                            webinarInfo.hlsStreams.add(stream);
                        }
                    }
                    if ((hlsdefinitionsResult = hlsResult.optJSONObject("definitions")) != null) {
                        JSONObject styleUHDResult;
                        JSONObject styleHDResult;
                        JSONObject styleSDResult;
                        JSONObject styleAResult = hlsdefinitionsResult.optJSONObject("A");
                        if (styleAResult != null) {
                            webinarInfo.HLS_A.value = styleAResult.optString("value");
                            webinarInfo.HLS_A.valid = styleAResult.optInt("valid");
                        }
                        if ((styleSDResult = hlsdefinitionsResult.optJSONObject("SD")) != null) {
                            webinarInfo.HLS_SD.value = styleSDResult.optString("value");
                            webinarInfo.HLS_SD.valid = styleSDResult.optInt("valid");
                        }
                        if ((styleHDResult = hlsdefinitionsResult.optJSONObject("HD")) != null) {
                            webinarInfo.HLS_HD.value = styleHDResult.optString("value");
                            webinarInfo.HLS_HD.valid = styleHDResult.optInt("valid");
                        }
                        if ((styleUHDResult = hlsdefinitionsResult.optJSONObject("UHD")) != null) {
                            webinarInfo.HLS_UHD.value = styleUHDResult.optString("value");
                            webinarInfo.HLS_UHD.valid = styleUHDResult.optInt("valid");
                        }
                    }
                    if ((rtmpResult = dataResult.optJSONObject("rtmp")) != null && (streams = rtmpResult.optJSONArray("streams")) != null && streams.length() > 0) {
                        for (int i = 0; i < streams.length(); ++i) {
                            JSONObject jsonObject2 = (JSONObject)streams.opt(i);
                            WebinarInfo.Stream stream = new WebinarInfo().new WebinarInfo.Stream();
                            stream.name = jsonObject2.optString("name");
                            stream.src = jsonObject2.optString("src");
                            webinarInfo.streams.add(stream);
                        }
                    }
                    if ((definitionsResult = rtmpResult.optJSONObject("definitions")) != null) {
                        JSONObject styleUHDResult;
                        JSONObject styleHDResult;
                        JSONObject styleSDResult;
                        JSONObject styleAResult = definitionsResult.optJSONObject("A");
                        if (styleAResult != null) {
                            webinarInfo.A.value = styleAResult.optString("value");
                            webinarInfo.A.valid = styleAResult.optInt("valid");
                        }
                        if ((styleSDResult = definitionsResult.optJSONObject("SD")) != null) {
                            webinarInfo.SD.value = styleSDResult.optString("value");
                            webinarInfo.SD.valid = styleSDResult.optInt("valid");
                        }
                        if ((styleHDResult = definitionsResult.optJSONObject("HD")) != null) {
                            webinarInfo.HD.value = styleHDResult.optString("value");
                            webinarInfo.HD.valid = styleHDResult.optInt("valid");
                        }
                        if ((styleUHDResult = definitionsResult.optJSONObject("UHD")) != null) {
                            webinarInfo.UHD.value = styleUHDResult.optString("value");
                            webinarInfo.UHD.valid = styleUHDResult.optInt("valid");
                        }
                    }
                }
                WebinarInfo.Report report = new WebinarInfo.Report();
                JSONObject reportJson = dataResult.optJSONObject("data_report");
                if (reportJson != null) {
                    report.guid = reportJson.optString("guid");
                    report.vid = reportJson.optString("vid");
                    report.vfid = reportJson.optString("vfid");
                    report.vtype = reportJson.optString("vtype");
                    report.topic = reportJson.optString("topic");
                    report.host = reportJson.optString("host");
                }
                webinarInfo.data_report = report;
                webinarInfo.report_extra = dataResult.optString("report_extra");
                JSONArray filterarr = dataResult.optJSONArray("filters");
                if (filterarr != null) {
                    ArrayList<String> filters = new ArrayList<String>();
                    for (int i = 0; i < filterarr.length(); ++i) {
                        filters.add((String)filterarr.get(i));
                    }
                    webinarInfo.filters = filters;
                }
                if ((quality = dataResult.optJSONArray("quality")) != null) {
                    webinarInfo.qualitiesjson = quality.toString();
                    webinarInfo.qualities = new ArrayList<String>();
                    for (int i = 0; i < quality.length(); ++i) {
                        webinarInfo.qualities.add((String)quality.get(i));
                    }
                } else {
                    webinarInfo.qualitiesjson = "[]";
                }
                callback.onWebinarInfoLoaded(responseStr, webinarInfo);
            } else {
                VhallCallback.ErrorCallback(callback, code, msg);
            }
        }
        catch (Exception e) {
            VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
            e.printStackTrace();
        }
    }

    private void dealSignInData(String jsonStr, RequestCallback callback) {
        JSONObject data = null;
        try {
            data = new JSONObject(jsonStr);
            String msg = data.optString("msg");
            int code = data.optInt("code");
            if (code == 200) {
                callback.onSuccess();
            } else {
                VhallCallback.ErrorCallback(callback, code, msg);
            }
        }
        catch (Exception e) {
            VhallCallback.ErrorCallback(callback, 20002, e.getMessage());
        }
    }

    private void dealChatHistoryResult(String responseStr, ChatServer.ChatRecordCallback chatHistoryCallback) {
        ArrayList<ChatServer.ChatInfo> chatList = new ArrayList<ChatServer.ChatInfo>();
        try {
            JSONObject result = new JSONObject(responseStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONArray array = result.optJSONArray("data");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.optJSONObject(i);
                    ChatServer.ChatInfo info = ChatServer.getMessageInfo(obj, false);
                    if (info == null) continue;
                    chatList.add(info);
                }
                chatHistoryCallback.onDataLoaded(chatList);
            } else {
                chatHistoryCallback.onFailed(code, msg);
            }
        }
        catch (Exception e) {
            chatHistoryCallback.onFailed(20002, e.getMessage());
            e.printStackTrace();
        }
    }
}

