/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.data;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.business.R;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.VHEventManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.UserInfoData;
import com.vhall.business.data.WatchAuthInfo;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.impl.VhssSimpleCallBack;
import com.vhall.business.support.VHSupportUtils;
import com.vhall.business.support.WrapperCallback;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.httpclient.utils.OKHttpUtils;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.CallBackV2;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.CreateRecordData;
import com.vhall.vhss.data.DirectorSeatListData;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.FilesData;
import com.vhall.vhss.data.GiftListData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.NoticeListInfoData;
import com.vhall.vhss.data.RecordChaptersData;
import com.vhall.vhss.data.RecordsData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.RoomToolsStatusData;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.data.WebinarBaseInfoData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.DocNetworkRequest;
import com.vhall.vhss.network.InteractNetworkRequest;
import com.vhall.vhss.network.InteractToolsNetworkRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class WebinarInfoRemote {
    private static final String TAG = WebinarInfoRemote.class.getName();
    private static Handler mDelivery;
    private static WebinarInfoRemote INSTANCE;
    private static final String ANDROID = "10";
    private static final String SDK = "6";
    public static final String TIME_PATTERN3 = "yyyy-MM-dd HH:mm:ss";

    private WebinarInfoRemote() {
    }

    public static WebinarInfoRemote getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebinarInfoRemote();
            mDelivery = new Handler(Looper.getMainLooper());
        }
        return INSTANCE;
    }

    public void getBroadcastWebinarInfo(String id, String access_token, String nickName, String email, String user_id, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        this.getBroadcastWebinarInfo(id, access_token, "", nickName, email, user_id, callback);
    }

    public void getCloudBroadcastWebinarInfo(String id, String seatId, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        ActivityNetworkRequest.getDirectorSeatInfo(id, seatId, new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(WebinarInfoData result) {
                WebinarInfoRemote.this.dealResponse(true, false, "", "", result, callback);
                LogReporter.getInstance().onCollection("2002", false, null);
            }

            @Override
            public void onError(final int eventCode, final String msg) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        LogReporter.getInstance().setErr(msg);
                        LogReporter.getInstance().onCollection("2002", false, null);
                        VhallCallback.ErrorCallback(callback, eventCode, msg);
                    }
                });
            }
        });
    }

    public void getConfigList(String scene_id, String webinar_id, String webinar_user_id, final RequestDataCallbackV2<String> callBack) {
        ActivityNetworkRequest.getConfigList(scene_id, webinar_id, webinar_user_id, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String data = jsonObject.optString("data");
                        JSONObject dataObject = new JSONObject(data);
                        if (!TextUtils.isEmpty((CharSequence)dataObject.optString("permissions"))) {
                            callBack.onSuccess(dataObject.optString("permissions"));
                        } else {
                            callBack.onSuccess("");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    public void getNoticeList(String room_id, int pos, int limit, RequestDataCallbackV2<NoticeListInfoData> callBack) {
        ActivityNetworkRequest.getNoticeList(room_id, pos, limit, new WrapperCallback<NoticeListInfoData>(callBack));
    }

    public void getGiftList(String room_id, RequestDataCallbackV2<GiftListData> callBack) {
        InteractToolsNetworkRequest.getGiftList(room_id, new WrapperCallback<GiftListData>(callBack));
    }

    public static void getDocList(String webinar_id, String room_id, int page, int limit, String keyword, RequestDataCallbackV2<DocListInfoData> callBack) {
        DocNetworkRequest.getDocList(webinar_id, room_id, page, limit, keyword, new WrapperCallback<DocListInfoData>(callBack));
    }

    public static void getRecordList(String webinar_id, int pos, int limit, RequestDataCallbackV2<RecordsData> callBack) {
        ActivityNetworkRequest.getRecordList(webinar_id, pos, limit, new WrapperCallback<RecordsData>(callBack));
    }

    public static void getRecordChaptersList(String record_id, RequestDataCallbackV2<RecordChaptersData> callBack) {
        ActivityNetworkRequest.getRecordChaptersList(record_id, new WrapperCallback<RecordChaptersData>(callBack));
    }

    public static void getCardList(String webinar_id, String switch_id, int curr_page, int page_size, RequestDataCallbackV2<CardsInfoData> callBack) {
        InteractToolsNetworkRequest.getCardList(webinar_id, switch_id, curr_page, page_size, new WrapperCallback<CardsInfoData>(callBack));
    }

    public static void getCardInfo(String webinar_id, String card_id, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack) {
        InteractToolsNetworkRequest.getCardInfo(webinar_id, card_id, new WrapperCallback<CardsInfoData.CardInfo>(callBack));
    }

    public static void cardClicked(String webinar_id, String switch_id, String card_id, RequestDataCallbackV2<String> callBack) {
        InteractToolsNetworkRequest.cardClicked(webinar_id, switch_id, card_id, new WrapperCallback<String>(callBack));
    }

    public static void getFilesList(String webinar_id, String menu_id, RequestDataCallbackV2<FilesData> callBack) {
        ActivityNetworkRequest.getFilesList(webinar_id, menu_id, new WrapperCallback<FilesData>(callBack));
    }

    public static void getFileDownLoadUrl(String webinar_id, String menu_id, String file_id, RequestDataCallbackV2<String> callBack) {
        ActivityNetworkRequest.getFileDownLoadUrl(webinar_id, menu_id, file_id, new WrapperCallback<String>(callBack));
    }

    public static void getGoodsList(String webinar_id, int status, final RequestDataCallbackV2<GoodsInfoData> callBack) {
        InteractToolsNetworkRequest.getGoodsList(webinar_id, status, new CallBack<ArrayList<GoodsInfoData.GoodsInfo>>(){

            @Override
            public void onSuccess(ArrayList<GoodsInfoData.GoodsInfo> result) {
                if (callBack != null) {
                    GoodsInfoData data = new GoodsInfoData();
                    data.list = result;
                    data.total = result.size();
                    callBack.onSuccess(data);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    public static void getGoodsInfo(String goods_id, RequestDataCallbackV2<GoodsInfoData.GoodsInfo> callBack) {
        InteractToolsNetworkRequest.getGoodsInfo(goods_id, new WrapperCallback<GoodsInfoData.GoodsInfo>(callBack));
    }

    public static void getGoodsOrderSetting(String webinar_id, RequestDataCallbackV2<GoodsOrderSetting> callBack) {
        InteractToolsNetworkRequest.getGoodsOrderSetting(webinar_id, new WrapperCallback<GoodsOrderSetting>(callBack));
    }

    public static void getGoodsPartnerList(String webinar_id, RequestDataCallbackV2<String> callBack) {
        InteractToolsNetworkRequest.getGoodsPartnerList(webinar_id, new WrapperCallback<String>(callBack));
    }

    public static void getWarmInfo(String webinar_id, RequestDataCallbackV2<WarmInfoData> callBack) {
        ActivityNetworkRequest.getWarmInfo(webinar_id, new WrapperCallback<WarmInfoData>(callBack));
    }

    public static void getRoomToolsState(String roomID, RequestDataCallbackV2<RoomToolsStatusData> callBack) {
        ActivityNetworkRequest.getRoomToolsState(roomID, new WrapperCallback<RoomToolsStatusData>(callBack));
    }

    public static void createRecord(String webinar_id, String live_type, RequestDataCallbackV2<CreateRecordData> callBack) {
        ActivityNetworkRequest.createRecord(webinar_id, live_type, new WrapperCallback<CreateRecordData>(callBack));
    }

    public void sendGift(String room_id, String gift_id, String channel, String service_code, String open_id, RequestCallback callBack) {
        InteractToolsNetworkRequest.sendGift(room_id, gift_id, channel, service_code, open_id, new VhssSimpleCallBack(callBack));
    }

    public void getBaseWebinarInfo(String id, final RequestDataCallback callBack) {
        ActivityNetworkRequest.getWebinarBaseInfo(id, "0", new CallBack<WebinarBaseInfoData>(){

            @Override
            public void onSuccess(WebinarBaseInfoData result) {
                if (callBack != null) {
                    WebinarInfoRemote.this.dealBaseResponse(result, callBack);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    public void getDirectorStatus(String id, final RequestDataCallback callBack) {
        ActivityNetworkRequest.getDirectorStatus(id, new CallBack<String>(){

            @Override
            public void onSuccess(String director_status) {
                if (callBack != null) {
                    callBack.onSuccess(director_status);
                }
            }

            @Override
            public void onError(int eventCode, String errorMsg) {
                if (callBack != null) {
                    callBack.onError(eventCode, errorMsg);
                }
            }
        });
    }

    public void setDevice(String room_id, String status, RequestCallback callBack) {
        InteractNetworkRequest.setDevice(room_id, status, new VhssSimpleCallBack(callBack));
    }

    public void getDirectorStreamStatus(String id, final RequestDataCallback callBack) {
        ActivityNetworkRequest.getDirectorStreamStatus(id, new CallBack<String>(){

            @Override
            public void onSuccess(String director_status) {
                if (callBack != null) {
                    callBack.onSuccess(director_status);
                }
            }

            @Override
            public void onError(int eventCode, String errorMsg) {
                if (callBack != null) {
                    callBack.onError(eventCode, errorMsg);
                }
            }
        });
    }

    public void getDirectorSeatList(String id, final RequestDataCallback callBack) {
        ActivityNetworkRequest.getDirectorSeatList(id, new CallBack<DirectorSeatListData>(){

            @Override
            public void onSuccess(DirectorSeatListData director_status) {
                if (callBack != null) {
                    callBack.onSuccess(director_status);
                }
            }

            @Override
            public void onError(int eventCode, String errorMsg) {
                if (callBack != null) {
                    callBack.onError(eventCode, errorMsg);
                }
            }
        });
    }

    public void directorSelectSeat(String id, String seatId, RequestCallback callBack) {
        ActivityNetworkRequest.directorSelectSeat(id, seatId, "android_sdk_" + VhallSDK.getmIMEI(), new VhssSimpleCallBack(callBack));
    }

    public void getBroadcastWebinarInfo(String id, final String access_token, String liveToken, String nickName, String email, final String user_id, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        ActivityNetworkRequest.getLiveInfo(id, liveToken, nickName, email, new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(WebinarInfoData result) {
                WebinarInfoRemote.this.dealResponse(true, false, user_id, access_token, result, callback);
                LogReporter.getInstance().onCollection("2002", false, null);
            }

            @Override
            public void onError(final int eventCode, final String msg) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        LogReporter.getInstance().setErr(msg);
                        LogReporter.getInstance().onCollection("2002", false, null);
                        VhallCallback.ErrorCallback(callback, eventCode, msg);
                    }
                });
            }
        });
    }

    public void queryWatchAuth(String webinarId, String type, String verifyValue, final WebinarInfoDataSource.WatchAuthQueryCallback callback) {
        ActivityNetworkRequest.getWatchAuth(webinarId, type, verifyValue, new CallBackV2<WatchAuthInfo>(){

            @Override
            public void onSuccess(WatchAuthInfo result) {
                if (null != callback) {
                    WatchAuthInfo.QueryInfo queryInfo = new WatchAuthInfo.QueryInfo();
                    queryInfo.type = result.type;
                    queryInfo.auth_status = false;
                    callback.onSucceed(queryInfo);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }

            @Override
            public void onError(int eventCode, String msg, WatchAuthInfo result) {
                if (null != callback) {
                    WatchAuthInfo.QueryInfo queryInfo = new WatchAuthInfo.QueryInfo();
                    queryInfo.auth_status = eventCode == 512528 || eventCode == 512532;
                    String string2 = queryInfo.type = null == result ? "" : result.type;
                    if (queryInfo.auth_status) {
                        callback.onSucceed(queryInfo);
                    } else {
                        callback.onError(eventCode, msg);
                    }
                }
            }
        });
    }

    public void checkWatchAuth(String webinarId, String type, String verifyValue, final WebinarInfoDataSource.WatchAuthCallback callback) {
        ActivityNetworkRequest.getWatchAuth(webinarId, type, verifyValue, new CallBackV2<WatchAuthInfo>(){

            @Override
            public void onSuccess(WatchAuthInfo result) {
                if (null != callback) {
                    callback.onSucceed(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }

            @Override
            public void onError(int eventCode, String msg, WatchAuthInfo result) {
                if (null != callback) {
                    if (null == result) {
                        result = new WatchAuthInfo(new JSONObject());
                    }
                    callback.onFailed(eventCode, msg, TextUtils.isEmpty((CharSequence)result.type) ? null : result);
                }
            }
        });
    }

    public void getWatchWebinarInfo(String id, String name, String email, String password, String vhallId, String record_id, String k_id, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        this.getWatchWebinarInfo(true, id, name, email, password, vhallId, record_id, k_id, null, callback);
    }

    public void getWatchWebinarInfo(String id, String name, String email, String password, String vhallId, String record_id, String k_id, HashMap<String, String> authConfig, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        this.getWatchWebinarInfo(true, id, name, email, password, vhallId, record_id, k_id, authConfig, callback);
    }

    public void getWatchWebinarInfo(final boolean setUserInfo, String id, String name, String email, String password, final String vhallId, String record_id, String k_id, HashMap<String, String> authConfig, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        ActivityNetworkRequest.getWatchInfo(id, record_id == null ? "" : record_id, name, email == null ? "" : email, password == null ? "" : password, k_id == null ? "" : k_id, authConfig, new CallBack<WebinarInfoData>(){

            @Override
            public void onSuccess(WebinarInfoData result) {
                WebinarInfoRemote.this.dealResponse(setUserInfo, true, vhallId, "", result, callback);
            }

            @Override
            public void onError(final int eventCode, final String msg) {
                mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        LogReporter.getInstance().onCollection("2004", false, new JSONObject());
                        VhallCallback.ErrorCallback(callback, eventCode, msg);
                    }
                });
            }
        });
    }

    private void dealBaseResponse(WebinarBaseInfoData result, RequestDataCallback callback) {
        if (VhallSDK.versionBall) {
            if (callback != null) {
                callback.onError(20022, VhallSDK.mContext.getString(R.string.error_server));
            }
            return;
        }
        WebinarInfo webinarInfo = new WebinarInfo();
        webinarInfo.webinar_show_type = result.webinar_show_type;
        webinarInfo.is_new_version = 3;
        webinarInfo.inav_num = result.inav_num;
        webinarInfo.no_delay_webinar = result.no_delay_webinar;
        webinarInfo.is_director = result.is_director;
        webinarInfo.webinar_type = result.webinar_type;
        try {
            webinarInfo.status = WebinarInfoData.getStatusStr(Integer.parseInt(result.webinar_state));
        }
        catch (Exception exception) {
            // empty catch block
        }
        webinarInfo.webinarBaseInfoData = result;
        if (callback != null) {
            callback.onSuccess(webinarInfo);
        }
    }

    private void dealResponse(boolean setUserInfo, boolean isWatch, String user_id, String access_token, WebinarInfoData result, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        UserInfoData userInfo;
        if (VhallSDK.versionBall) {
            if (callback != null) {
                callback.onError(20022, VhallSDK.mContext.getString(R.string.error_server));
            }
            return;
        }
        WebinarInfo webinarInfo = new WebinarInfo();
        webinarInfo.setWebinarInfoData(result);
        LogReporter.getInstance().setUserid("".equals(VhallSDK.getUserId()) ? webinarInfo.join_id : VhallSDK.getUserId());
        webinarInfo.chatforbid = result.join_info.is_gag == 1;
        webinarInfo.chatOwnForbid = result.join_info.is_gag == 1;
        webinarInfo.webinar_id = result.webinar.id;
        webinarInfo.vss_room_id = result.interact.room_id;
        webinarInfo.join_id = result.join_info.getJoin_id();
        webinarInfo.user_id = result.join_info.third_party_user_id;
        webinarInfo.role_name = result.join_info.role_name;
        webinarInfo.nick_name = result.join_info.nickname;
        webinarInfo.webinar_show_type = result.webinar.webinar_show_type;
        if (webinarInfo.webinar_show_type == -1) {
            webinarInfo.webinar_show_type = result.webinar_show_type;
        }
        if (result.permissionKey != null) {
            webinarInfo.live_rehearsal = result.permissionKey.live_rehearsal;
        }
        webinarInfo.cheat_num = result.cheat_num;
        webinarInfo.versionType = "6.23.0";
        webinarInfo.cast_screen = result.cast_screen;
        webinarInfo.is_interact = TextUtils.equals((CharSequence)result.webinar.mode, (CharSequence)"3") ? "1" : "0";
        webinarInfo.is_new_version = 3;
        webinarInfo.inav_num = result.webinar.inav_num;
        webinarInfo.no_delay_webinar = result.webinar.no_delay_webinar;
        webinarInfo.is_director = result.webinar.is_director;
        webinarInfo.subject = result.webinar.subject;
        webinarInfo.introduction = result.webinar.introduction;
        webinarInfo.img_url = result.webinar.img_url;
        webinarInfo.start_time = result.webinar.start_time;
        webinarInfo.permission = result.permission;
        webinarInfo.hostName = result.webinar.userinfo.nickname;
        webinarInfo.hostAvatar = result.webinar.userinfo.avatar;
        webinarInfo.hostId = result.webinar.userinfo.user_id;
        webinarInfo.mainId = result.webinar.userinfo.user_id;
        webinarInfo.hands_up = "0";
        webinarInfo.live_type = result.live_type;
        webinarInfo.layout = "1".equals(result.webinar.mode) ? 2 : 3;
        if (result.seatBean != null) {
            webinarInfo.seatName = result.seatBean.name;
        }
        webinarInfo.director_stream = result.director_stream;
        try {
            VhallBaseSDK.getInstance().initBeautify(result.interact.paas_access_token, new IVHBeautifyInitListener(){

                public void onSuccess() {
                    LogReportManager.doReport("115019");
                    VLog.v((String)"initBeautify", (String)"onSuccess");
                }

                public void onError(int i, String s) {
                    VHEventManager.share().notifyEvent(i, s, "", null);
                    VLog.e((String)"initBeautify", (String)("onError  msg:   " + s));
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        webinarInfo.webinar_type = result.webinar.mode;
        webinarInfo.status = WebinarInfoData.getStatusStr(result.webinar.type);
        String string2 = webinarInfo.broadcastToken = TextUtils.isEmpty((CharSequence)access_token) ? "access_token" : access_token;
        if (result.pv != null) {
            webinarInfo.pv = result.pv.real;
            webinarInfo.pvVirtual = result.pv.virtual;
            webinarInfo.pvShow = result.pv.show;
        }
        if (result.online != null) {
            webinarInfo.online = result.online.real;
            webinarInfo.onlineVirtual = result.online.virtual;
            webinarInfo.onlineShow = result.online.show;
        }
        if (result.ssoBean != null && result.ssoBean.enabled == 1) {
            userInfo = new UserInfoData(result.join_info.third_party_user_id, result.join_info.nickname, VHSupportUtils.getHeaderIcon(result), TextUtils.isEmpty((CharSequence)result.join_info.role_name) ? "2" : result.join_info.role_name, "3", "1", String.valueOf(result.join_info.is_gag), result.ssoBean.kick_id, VhallSDK.getmIMEI() + result.webinar.id, String.valueOf(webinarInfo.pv), VhallSDK.third_account_id);
            userInfo.audience = isWatch;
            userInfo.setPrivacies(result.join_info.privacies);
            if (setUserInfo) {
                com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.onlineToString());
            }
        } else {
            userInfo = new UserInfoData(result.join_info.third_party_user_id, result.join_info.nickname, VHSupportUtils.getHeaderIcon(result), TextUtils.isEmpty((CharSequence)result.join_info.role_name) ? "2" : result.join_info.role_name, "3", "1", String.valueOf(result.join_info.is_gag), String.valueOf(webinarInfo.pv), VhallSDK.third_account_id);
            if (isWatch) {
                userInfo.setAudience(true);
            } else {
                userInfo.setAudience(false);
            }
            userInfo.setPrivacies(result.join_info.privacies);
            if (setUserInfo) {
                com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toJsonString());
            }
        }
        if (result.switchBean != null) {
            webinarInfo.switch_id = result.switchBean.switch_id;
        }
        if (result.roomToolsStatusData != null) {
            webinarInfo.use_doc = result.roomToolsStatusData.is_doc;
            webinarInfo.question_status = result.roomToolsStatusData.question_status;
            webinarInfo.hands_up = String.valueOf(result.roomToolsStatusData.is_handsup);
            if (TextUtils.isEmpty((CharSequence)webinarInfo.hands_up)) {
                webinarInfo.hands_up = "0";
            }
            if (result.roomToolsStatusData.all_banned == 1) {
                webinarInfo.chatforbid = true;
                webinarInfo.chatAllForbid = true;
            }
            webinarInfo.question_name = result.roomToolsStatusData.question_name;
            webinarInfo.private_chat_status = result.roomToolsStatusData.private_chat_status;
            webinarInfo.chat_status = result.roomToolsStatusData.chat_status;
            webinarInfo.qa_status = result.roomToolsStatusData.qa_status;
            webinarInfo.is_adi_watch_doc = result.roomToolsStatusData.is_adi_watch_doc;
            webinarInfo.is_open_switch = result.roomToolsStatusData.is_open_switch;
            webinarInfo.inter_active_type = result.roomToolsStatusData.layout;
            webinarInfo.speakerAndShowLayout = result.roomToolsStatusData.speakerAndShowLayout;
            webinarInfo.mainId = result.roomToolsStatusData.main_screen;
            LogReportManager.doReport("115044", new String[]{"enable"}, new String[]{String.valueOf(1 == webinarInfo.speakerAndShowLayout)});
        }
        if (result.menuListInfoData != null && result.menuListInfoData.list != null) {
            for (MenuListInfoData.MenuItem item : result.menuListInfoData.list) {
                if (item.type != 9) continue;
                webinarInfo.file_download_menu = item;
                webinarInfo.is_file_download = item.status;
                break;
            }
        }
        WebinarInfo.Watermark watermark = new WebinarInfo.Watermark();
        if (result.watermarkInfoData != null) {
            if (result.watermarkInfoData.watermark_open == 1) {
                watermark.imgAlpha = (float)((double)result.watermarkInfoData.img_alpha * 0.01);
                watermark.imgUrl = result.watermarkInfoData.img_url;
                watermark.imgPosition = result.watermarkInfoData.img_position;
            }
            if (result.watermarkInfoData.isDocWatermarkEnable()) {
                watermark.docWatermarkType = result.watermarkInfoData.doc_watermark_type;
                watermark.docWatermarkOpen = result.watermarkInfoData.doc_watermark_open;
                watermark.docFontColor = result.watermarkInfoData.doc_font_color;
                watermark.docFontSize = result.watermarkInfoData.doc_font_size;
                watermark.docTransparency = result.watermarkInfoData.doc_transparency;
            }
        }
        webinarInfo.watermark = watermark;
        if (result.report_data != null) {
            webinarInfo.report_extra = result.report_data.report_extra;
            LogInfo.getInstance().setExtraData(webinarInfo.report_extra);
            LogInfo.getInstance().vfid = result.report_data.vfid;
            LogInfo.getInstance().vid = result.report_data.vid;
            LogInfo.getInstance().guid = result.report_data.guid;
            LogInfo.getInstance().setSaasHasBiz(true, result.report_data.biz_id);
        }
        if (result.record != null) {
            webinarInfo.record_id = result.record.record_id;
        }
        WebinarInfoRemote.report(webinarInfo);
        webinarInfo.filters = result.filters;
        webinarInfo.like_num = result.like;
        if (result.noticeListInfoData != null && result.noticeListInfoData.list != null && result.noticeListInfoData.list.size() > 0) {
            WebinarInfo.Notice notice = new WebinarInfo.Notice();
            if (result.noticeListInfoData.list.get((int)0).content != null) {
                notice.content = result.noticeListInfoData.list.get((int)0).content.content;
            }
            notice.publish_release_time = result.noticeListInfoData.list.get((int)0).created_at;
            notice.duration = result.noticeListInfoData.list.get((int)0).duration;
            webinarInfo.notice = notice;
        }
        this.dealGetRoleName(callback, result, webinarInfo);
    }

    private void dealGetRoleName(final WebinarInfoDataSource.LoadWebinarInfoCallback callback, final WebinarInfoData result, final WebinarInfo webinarInfo) {
        ActivityNetworkRequest.getRoleName(result.webinar.id, new CallBack<RoleNameData>(){

            @Override
            public void onSuccess(RoleNameData result2) {
                if (result2 != null) {
                    webinarInfo.roleNameData = result2;
                    callback.onWebinarInfoLoaded(result2.toString(), webinarInfo);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                webinarInfo.roleNameData = new RoleNameData();
                callback.onWebinarInfoLoaded(result.toString(), webinarInfo);
            }
        });
    }

    private static void report(WebinarInfo webinarInfo) {
        if (webinarInfo == null || TextUtils.isEmpty((CharSequence)VhallSDK.reportUrl) || TextUtils.isEmpty((CharSequence)webinarInfo.webinar_id)) {
            return;
        }
        String reportHost = String.format("%s/login?k=%s&id=%s&s=%s&token=%s", VhallSDK.reportUrl, "606001", "Android" + System.currentTimeMillis(), UUID.randomUUID().toString(), WebinarInfoRemote.getToken(webinarInfo));
        Request request = new Request.Builder().url(reportHost).get().build();
        OKHttpUtils.createOkClient().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    private static String getToken(WebinarInfo webinarInfo) {
        JSONObject collectionParam = new JSONObject();
        try {
            collectionParam.put("user_id", (Object)webinarInfo.join_id);
            collectionParam.put("webinar_id", (Object)webinarInfo.webinar_id);
            collectionParam.put("t_start", (Object)WebinarInfoRemote.dateToString());
            collectionParam.put("os", (Object)ANDROID);
            collectionParam.put("device_id", (Object)VhallSDK.getmIMEI());
            collectionParam.put("type", (Object)SDK);
            collectionParam.put("user_agent", (Object)"user_agent");
            collectionParam.put("entry_time", (Object)WebinarInfoRemote.dateToString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String collectionStr = collectionParam.toString();
        return new String(Base64.encode((byte[])collectionStr.getBytes(), (int)2));
    }

    public static String dateToString() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(TIME_PATTERN3);
        Date date = new Date();
        try {
            return sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

