/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.core;

import android.os.Bundle;
import com.vhall.business.core.IVHSDKListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class VHEventManager {
    static VHEventManager sManager = new VHEventManager();
    private List<WeakReference<IVHSDKListener>> sWeakReferenceList = new ArrayList<WeakReference<IVHSDKListener>>();

    public static VHEventManager share() {
        return sManager;
    }

    private VHEventManager() {
    }

    public synchronized void addVHListener(IVHSDKListener listener) {
        if (listener != null) {
            this.sWeakReferenceList.add(new WeakReference<IVHSDKListener>(listener));
        }
        for (int i = this.sWeakReferenceList.size() - 1; i >= 0; --i) {
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = this.sWeakReferenceList.get(i);
            if (ivhsdkListenerWeakReference != null && ivhsdkListenerWeakReference.get() != null) continue;
            this.sWeakReferenceList.remove(i);
        }
    }

    public synchronized void removeVHListener(IVHSDKListener listener) {
        for (int i = this.sWeakReferenceList.size() - 1; i >= 0; --i) {
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = this.sWeakReferenceList.get(i);
            if (ivhsdkListenerWeakReference == null || ivhsdkListenerWeakReference.get() == null) {
                this.sWeakReferenceList.remove(i);
                continue;
            }
            if (ivhsdkListenerWeakReference.get() != listener) continue;
            this.sWeakReferenceList.remove(i);
        }
    }

    public synchronized void notifyEvent(int code, String tips, String args, Bundle extras) {
        for (int i = this.sWeakReferenceList.size() - 1; i >= 0; --i) {
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = this.sWeakReferenceList.get(i);
            if (ivhsdkListenerWeakReference == null || ivhsdkListenerWeakReference.get() == null) {
                this.sWeakReferenceList.remove(i);
                continue;
            }
            ((IVHSDKListener)ivhsdkListenerWeakReference.get()).onAction(code, tips, args, extras);
        }
    }
}

