/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.Playback;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.PlaybackDocumentDataSource;
import com.vhall.business.data.source.PlaybackDocumentRepository;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.data.source.local.PlaybackDocumentLocalDataSource;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.PlaybackDocumentRemoteDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.utils.LogManager;
import com.vhall.player.Constants;
import com.vhall.player.MPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class WatchPlaybackFlash
extends Playback {
    private static final String TAG = "WatchPlaybackFlash";
    private MPlayer mPlayer;
    Document document;

    WatchPlaybackFlash(Playback.Builder builder) {
        this.context = builder.context;
        if (builder.surfaceView != null) {
            this.surfaceView = builder.surfaceView;
        } else if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.docEventCallback = builder.docCallback;
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.qualities = webinarInfo.qualities;
        if (this.docEventCallback != null) {
            this.document = new Document();
        }
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.mPlayer != null) {
            this.mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.mPlayer) {
            this.mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.mPlayer) {
            this.mPlayer.unmute();
        }
    }

    @Override
    public void setDefinition(String dpi) {
        this.mCurrentDpi = dpi;
        if (this.mPlayer == null) {
            this.start();
        } else {
            this.mPlayer.setDefinition(this.mCurrentDpi);
        }
    }

    @Override
    public void start() {
        String dispatchUrl;
        if (this.mPlayer == null) {
            this.mPlayer = new MPlayer(this.context, 2);
            this.mPlayer.setLogParam(this.getDataCollectionStr());
            if (this.surfaceView != null) {
                this.mPlayer.setDisplay(this.surfaceView);
            } else {
                this.mPlayer.setDisplay(this.vodPlayerView);
            }
            this.mPlayer.setListener(this.listener);
            this.mPlayer.setDefinition(this.mCurrentDpi);
            this.mPlayer.setDrawMode(this.scaleType);
        }
        if ((dispatchUrl = this.setRefreshURL()).contains(".mp4")) {
            this.mPlayer.setStreamType("mp4_domainname");
        } else {
            this.mPlayer.setStreamType("hls_domainname");
        }
        this.mPlayer.startPlay(dispatchUrl, this.setDefaultURL());
        this.setWaterMark();
    }

    @Override
    public void onPause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.mPlayer != null) {
            this.mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.flag = false;
    }

    @Override
    public float setSpeed(float speed) {
        if (this.mPlayer != null) {
            return this.mPlayer.setSpeed(speed);
        }
        return 0.0f;
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public void startPlay(String url) {
        this.releasePlayer();
        if (this.mPlayer == null) {
            this.mPlayer = new MPlayer(this.context, 2);
            this.mPlayer.setLogParam(this.getDataCollectionStr());
            this.mPlayer.setListener(this.listener);
            this.mPlayer.setDisplay(this.surfaceView);
        }
        this.mPlayer.startPlay(url);
        if (this.mSavePlayerPoint != 0L) {
            this.mPlayer.seekto(this.mSavePlayerPoint);
        }
    }

    @Override
    public void releasePlayer() {
        try {
            if (this.mPlayer != null) {
                this.mSavePlayerPoint = this.mPlayer.getPosition();
                this.mPlayer.release();
                this.mPlayer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void seekTo(long position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekto(position);
        }
        if (this.document != null) {
            this.document.seek(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (this.mPlayer != null) {
            return this.mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public void initWH(int width, int height) {
    }

    @Override
    public String getOriginalUrl() {
        if (this.webinarInfo.getCast_screen() == 1 && this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void sendComment(String content, RequestCallback callback) {
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.sendComment(this.webinarInfo.webinar_id, content, VhallSDK.user.user_id, callback);
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int pos, final ChatServer.ChatRecordCallback callback) {
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.getCommentHistory(this.webinarInfo.join_id, webinar_id, String.valueOf(limit), String.valueOf(pos), new ChatServer.ChatRecordCallback(){

            @Override
            public void onDataLoaded(List<ChatServer.ChatInfo> list) {
                callback.onDataLoaded(list);
            }

            @Override
            public void onFailed(int errorcode, String messaage) {
                callback.onFailed(errorcode, messaage);
            }
        });
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    private String getDataCollectionStr() {
        String dataCollection = "";
        if (this.webinarInfo != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("aid", (Object)this.webinarInfo.webinar_id);
                jsonObject.put("s", (Object)this.webinarInfo.session_id);
                jsonObject.put("bu", VhallSDK.BU);
                jsonObject.put("uid", (Object)this.webinarInfo.join_id);
                jsonObject.put("guid", (Object)this.webinarInfo.data_report.guid);
                jsonObject.put("pf", 5);
                jsonObject.put("topic", (Object)this.webinarInfo.data_report.topic);
                jsonObject.put("vfid", (Object)this.webinarInfo.data_report.vfid);
                jsonObject.put("vid", (Object)this.webinarInfo.data_report.vid);
                jsonObject.put("vtype", (Object)this.webinarInfo.data_report.vtype);
                jsonObject.put("app_id", (Object)VhallSDK.APP_KEY);
                jsonObject.put("host", (Object)this.webinarInfo.data_report.host);
                if (this.context != null) {
                    jsonObject.put("ndi", (Object)VhallSDK.getmIMEI());
                }
                dataCollection = jsonObject.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return dataCollection;
    }

    private void setWaterMark() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(WatchPlaybackFlash.this.waterMarkUrl);
                    HttpURLConnection conn = WatchPlaybackFlash.this.waterMarkUrl.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
                    BitmapDrawable drawable = new BitmapDrawable(WatchPlaybackFlash.this.context.getResources(), bitmap);
                    WatchPlaybackFlash.this.mDelivery.post(new Runnable(){
                        final /* synthetic */ Drawable val$drawable;
                        {
                            this.val$drawable = drawable;
                        }

                        @Override
                        public void run() {
                            if (WatchPlaybackFlash.this.vodPlayerView != null && WatchPlaybackFlash.this.vodPlayerView.getWaterMark() == null) {
                                WatchPlaybackFlash.this.vodPlayerView.setWaterMark(this.val$drawable);
                                WatchPlaybackFlash.this.vodPlayerView.setWaterMarkAlpha(WatchPlaybackFlash.this.waterMarkAlpha);
                                switch (WatchPlaybackFlash.this.waterMarkGravity) {
                                    case 1: {
                                        WatchPlaybackFlash.this.vodPlayerView.setWaterMarkGravity(3);
                                        break;
                                    }
                                    case 2: {
                                        WatchPlaybackFlash.this.vodPlayerView.setWaterMarkGravity(5);
                                        break;
                                    }
                                    case 3: {
                                        WatchPlaybackFlash.this.vodPlayerView.setWaterMarkGravity(85);
                                        break;
                                    }
                                    case 4: {
                                        WatchPlaybackFlash.this.vodPlayerView.setWaterMarkGravity(83);
                                        break;
                                    }
                                }
                            }
                        }
                    });
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    class Document
    extends Thread {
        private List<MessageServer.MsgInfo> documentList;
        private CopyOnWriteArrayList<MessageServer.MsgInfo> boardList = new CopyOnWriteArrayList();
        private HashMap<String, ArrayList<MessageServer.MsgInfo>> docMap = new HashMap();
        private int currentPosition = 0;
        private boolean seeking = false;

        public Document() {
            if (WatchPlaybackFlash.this.webinarInfo != null) {
                PlaybackDocumentRepository repository = PlaybackDocumentRepository.getInstance(PlaybackDocumentLocalDataSource.getInstance(), PlaybackDocumentRemoteDataSource.getInstance());
                repository.getDocumentList(WatchPlaybackFlash.this.webinarInfo, new PlaybackDocumentDataSource.LoadDocumentCallback(){

                    @Override
                    public void onLoaded(WebinarInfo webinarInfo, List<MessageServer.MsgInfo> msgInfo) {
                        Document.this.documentList = msgInfo;
                        if (Document.this.documentList == null || Document.this.documentList.size() <= 0) {
                            WatchPlaybackFlash.this.flag = false;
                        } else {
                            WatchPlaybackFlash.this.flag = true;
                            Document.this.separateData();
                            Document.this.start();
                        }
                    }

                    @Override
                    public void onDataNotAvailable(String reason) {
                    }
                });
            }
        }

        @Override
        public void run() {
            super.run();
            while (WatchPlaybackFlash.this.flag) {
                try {
                    int create_at;
                    if (WatchPlaybackFlash.this.mPlayer == null || WatchPlaybackFlash.this.mPlayer.getState() != Constants.State.START || this.currentPosition >= this.documentList.size() || this.seeking) continue;
                    final MessageServer.MsgInfo msgInfo = this.documentList.get(this.currentPosition);
                    long playerPosition = WatchPlaybackFlash.this.mPlayer.getPosition() / 1000L;
                    if (playerPosition > (long)(create_at = msgInfo.created_at)) {
                        WatchPlaybackFlash.this.mDelivery.post(new Runnable(){

                            @Override
                            public void run() {
                                Document.this.dealNewPosition(msgInfo);
                            }
                        });
                        ++this.currentPosition;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void seek(long playerPosition) {
            ArrayList<MessageServer.MsgInfo> doc;
            ArrayList<MessageServer.MsgInfo> docSwitch;
            LogManager.innerLog(WatchPlaybackFlash.TAG, "seek-->position:" + playerPosition);
            if (this.documentList == null || this.documentList.size() <= 0) {
                return;
            }
            if (this.boardList == null || this.docMap == null) {
                return;
            }
            if (!WatchPlaybackFlash.this.flag) {
                return;
            }
            this.seeking = true;
            int boardlist_lastposition = 0;
            int boardlist_lastclearposition = 0;
            String key = "";
            int docposition = 0;
            block6: for (int i = 0; i < this.documentList.size(); ++i) {
                this.currentPosition = i;
                MessageServer.MsgInfo msgInfo = this.documentList.get(i);
                if ((long)msgInfo.created_at > playerPosition / 1000L) break;
                switch (msgInfo.event) {
                    case 23: {
                        boardlist_lastclearposition = ++boardlist_lastposition;
                        continue block6;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        ++boardlist_lastposition;
                        continue block6;
                    }
                    case 6: 
                    case 26: {
                        key = msgInfo.doc + "/" + msgInfo.page;
                    }
                    case 24: 
                    case 25: 
                    case 32: {
                        docposition = i;
                        continue block6;
                    }
                }
            }
            if ((docSwitch = this.docMap.get("showDoc")) != null && docSwitch.size() > 0) {
                MessageServer.MsgInfo msg = this.documentList.get(docposition);
                int pos = 0;
                for (int j = 0; j < docSwitch.size() && docSwitch.get((int)j).created_at <= msg.created_at; ++j) {
                    ++pos;
                }
                WatchPlaybackFlash.this.docEventCallback.onEvent("showDoc", docSwitch.subList(0, pos));
            }
            if (this.boardList != null && this.boardList.size() > 0 && boardlist_lastposition - boardlist_lastclearposition > 0) {
                if (boardlist_lastposition > this.boardList.size()) {
                    return;
                }
                WatchPlaybackFlash.this.docEventCallback.onEvent("board", this.boardList.subList(0, boardlist_lastposition));
            }
            if ((doc = this.docMap.get(key)) != null && doc.size() > 0) {
                if (docposition >= this.documentList.size() - 1) {
                    WatchPlaybackFlash.this.docEventCallback.onEvent(key, doc);
                } else {
                    MessageServer.MsgInfo msg = this.documentList.get(docposition);
                    if (doc != null && doc.size() > 0) {
                        int pos = 0;
                        for (int j = 0; j < doc.size() && doc.get((int)j).created_at <= msg.created_at; ++j) {
                            ++pos;
                        }
                        WatchPlaybackFlash.this.docEventCallback.onEvent(key, doc.subList(0, pos));
                    }
                }
            } else {
                doc = new ArrayList();
                MessageServer.MsgInfo msgInfo = new MessageServer.MsgInfo();
                msgInfo.event = 6;
                doc.add(msgInfo);
                WatchPlaybackFlash.this.docEventCallback.onEvent("empty", doc);
            }
            this.seeking = false;
        }

        private void dealNewPosition(MessageServer.MsgInfo msgInfo) {
            if (msgInfo.event == 6) {
                String key = msgInfo.doc + "/" + msgInfo.page;
                ArrayList<MessageServer.MsgInfo> doc = this.docMap.get(key);
                if (doc != null && doc.size() > 0) {
                    int pos = 0;
                    for (int j = 0; j < doc.size(); ++j) {
                        pos = j;
                        if (doc.get((int)j).created_at > msgInfo.created_at) break;
                    }
                    if (pos == 0) {
                        WatchPlaybackFlash.this.docEventCallback.onEvent(msgInfo);
                    } else {
                        WatchPlaybackFlash.this.docEventCallback.onEvent(key, doc.subList(0, pos));
                    }
                }
            } else if (msgInfo.event == 19 && msgInfo.showType == 1) {
                int kpos = 0;
                for (int k = 0; k < this.boardList.size(); ++k) {
                    if (this.boardList.get((int)k).created_at != msgInfo.created_at) continue;
                    kpos = k;
                    break;
                }
                if (kpos == 0) {
                    WatchPlaybackFlash.this.docEventCallback.onEvent(msgInfo);
                } else {
                    WatchPlaybackFlash.this.docEventCallback.onEvent("board", this.boardList.subList(0, kpos + 1));
                }
            } else {
                WatchPlaybackFlash.this.docEventCallback.onEvent(msgInfo);
            }
        }

        private void separateData() {
            String lastKey = "";
            block6: for (int i = 0; i < this.documentList.size(); ++i) {
                String key = "";
                MessageServer.MsgInfo msgInfo = this.documentList.get(i);
                switch (msgInfo.event) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        this.boardList.add(msgInfo);
                        continue block6;
                    }
                    case 26: {
                        ArrayList<Object> list;
                        key = "showDoc";
                        if (!this.docMap.keySet().contains(key)) {
                            list = new ArrayList<MessageServer.MsgInfo>();
                            list.add(msgInfo);
                            this.docMap.put(key, list);
                            continue block6;
                        }
                        list = this.docMap.get(key);
                        if (list == null) continue block6;
                        list.add(msgInfo);
                        continue block6;
                    }
                    case 6: {
                        ArrayList<Object> list;
                        key = msgInfo.doc + "/" + msgInfo.page;
                        if (!this.docMap.keySet().contains(key)) {
                            list = new ArrayList();
                            list.add(msgInfo);
                            this.docMap.put(key, list);
                        }
                        lastKey = key;
                        continue block6;
                    }
                    case 24: 
                    case 25: 
                    case 32: {
                        ArrayList<MessageServer.MsgInfo> list;
                        MessageServer.Step step = msgInfo.step;
                        key = step == null || TextUtils.isEmpty((CharSequence)step.pageID) ? lastKey : step.pageID;
                        if (TextUtils.isEmpty((CharSequence)key) || (list = this.docMap.get(key)) == null) continue block6;
                        list.add(msgInfo);
                        continue block6;
                    }
                }
            }
        }
    }
}

