/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import android.view.View;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.MessageServer;
import com.vhall.business.Playback;
import com.vhall.business.R;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.player.vod.VodPlayerView;
import java.util.List;

public class WatchPlayback
extends Playback {
    private static final String TAG = "WatchPlayback";
    private Playback mPlayer;
    private String type;

    private WatchPlayback(Builder builder) {
        this.context = builder.context;
        if (builder.surfaceView != null) {
            this.surfaceView = builder.surfaceView;
        } else if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.docEventCallback = builder.docCallback;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.qualities = webinarInfo.qualities;
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
        Playback.Builder builder = new Playback.Builder();
        builder.callback(this.listener).context(this.context).chatCallback(this.chatCallback).messageCallback(this.messageCallback).docCallback(this.docEventCallback);
        if (this.surfaceView != null) {
            builder.surfaceView(this.surfaceView);
        } else if (this.vodPlayerView != null) {
            builder.vodPlayView(this.vodPlayerView);
        }
        this.type = webinarInfo.is_new_version == 3 ? "6" : (TextUtils.isEmpty((CharSequence)webinarInfo.vss_token) ? "flash" : "h5");
        this.mPlayer = builder.build(this.type);
        this.mPlayer.setWebinarInfo(webinarInfo);
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.mPlayer != null) {
            this.mPlayer.setScaleType(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.mPlayer) {
            this.mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.mPlayer) {
            this.mPlayer.unMute();
        }
    }

    @Override
    public void setDefinition(String dpi) {
        this.mCurrentDpi = dpi;
        if (this.mPlayer == null) {
            this.start();
        } else {
            this.mPlayer.setDefinition(this.mCurrentDpi);
        }
    }

    @Override
    public void start() {
        if (!this.isAvaliable()) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.webinarInfo.status != 4 && this.webinarInfo.status != 5) {
            if (this.listener != null) {
                this.listener.onError(20209, 0, String.format(this.context.getString(R.string.playing_status), this.webinarInfo.getStatusStr()));
            }
            return;
        }
        if (this.mPlayer != null) {
            this.mPlayer.start();
        }
    }

    @Override
    public void onPause() {
        if (this.mPlayer != null) {
            this.mPlayer.onPause();
        }
    }

    @Override
    public void onResume() {
        if (this.mPlayer != null) {
            this.mPlayer.onResume();
        }
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.mPlayer != null) {
            this.mPlayer.destroy();
        }
        this.flag = false;
    }

    @Override
    public float setSpeed(float speed) {
        if (this.mPlayer != null) {
            return this.mPlayer.setSpeed(speed);
        }
        return 0.0f;
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.mPlayer != null) {
            return this.mPlayer.setVideoBackgroundColor(color);
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        if (this.mPlayer != null) {
            return this.mPlayer.setVideoBackgroundImage(bitmap);
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (this.mPlayer != null) {
            return this.mPlayer.takeVideoScreenshot(callback);
        }
        return false;
    }

    @Override
    public void startPlay(String url) {
        this.releasePlayer();
        if (this.mPlayer != null) {
            this.mPlayer.startPlay(url);
        }
    }

    @Override
    public void releasePlayer() {
        try {
            if (this.mPlayer != null) {
                this.mPlayer.releasePlayer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void seekTo(long position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekTo(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (this.mPlayer != null) {
            return this.mPlayer.getPlayerState();
        }
        return Constants.State.NONE;
    }

    @Override
    public void initWH(int width, int height) {
    }

    @Override
    public String getOriginalUrl() {
        if (this.webinarInfo.getCast_screen() == 1 && this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void sendComment(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callback, 20003, this.context.getString(R.string.ERROR_MSG_IS_LOGIN));
            return;
        }
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)this.webinarInfo.webinar_id)) {
            VhallCallback.ErrorCallback(callback, 20001, this.context.getString(R.string.error_video_info_init));
            return;
        }
        if (this.webinarInfo.chatforbid) {
            callback.onError(20021, this.context.getString(R.string.error_chat_forbid_open));
            return;
        }
        if (this.webinarInfo.filters != null) {
            for (int i = 0; i < this.webinarInfo.filters.size(); ++i) {
                if (!content.contains(this.webinarInfo.filters.get(i))) continue;
                VhallCallback.ErrorCallback(callback, 20020, VhallSDK.mContext.getString(R.string.error_chat_forbid));
                return;
            }
        }
        if (this.mPlayer != null) {
            this.mPlayer.sendComment(content, callback);
        }
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int pos, ChatServer.ChatRecordCallback callback) {
        if (this.checkCommentParameter(limit, pos, callback) && this.mPlayer != null) {
            this.mPlayer.requestCommentHistory(webinar_id, limit, pos, callback);
        }
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback callback) {
        if (this.checkCommentParameter(limit, page, callback) && this.mPlayer != null) {
            this.mPlayer.requestCommentHistory(webinar_id, limit, page, msgId, anchor_path, is_role, callback);
        }
    }

    private boolean checkCommentParameter(int limit, int pos, ChatServer.ChatRecordCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(ErrorCode.CALLBACK_ERROR_STR);
        }
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onFailed(20001, this.context.getString(R.string.error_video_info_init));
            return false;
        }
        if (this.webinarInfo.status == 1) {
            callback.onFailed(20003, this.context.getString(R.string.playing));
            return false;
        }
        if (limit <= 0 || pos < 0) {
            callback.onFailed(20003, ErrorCode.ERROR_PARAM_STR);
            return false;
        }
        return true;
    }

    public static class Builder {
        Context context;
        VHPlayerListener listener;
        DocumentEventCallback docCallback;
        SurfaceView surfaceView;
        VodPlayerView vodPlayerView;
        ChatServer.Callback chatCallback;
        MessageServer.Callback messageCallback;

        public Builder chatCallback(ChatServer.Callback chatCallback) {
            this.chatCallback = chatCallback;
            return this;
        }

        public Builder messageCallback(MessageServer.Callback messageCallback) {
            this.messageCallback = messageCallback;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder surfaceView(SurfaceView surfaceView) {
            this.surfaceView = surfaceView;
            return this;
        }

        public Builder vodPlayView(VodPlayerView vodPlayerView) {
            this.vodPlayerView = vodPlayerView;
            return this;
        }

        public Builder callback(VHPlayerListener listener) {
            this.listener = listener;
            return this;
        }

        @Deprecated
        public Builder docCallback(DocumentEventCallback docCallback) {
            this.docCallback = docCallback;
            return this;
        }

        public WatchPlayback build() {
            if (this.surfaceView == null && this.vodPlayerView == null) {
                throw new IllegalArgumentException("containerLayout can not be null");
            }
            if (this.context == null) {
                this.context = this.surfaceView != null ? this.surfaceView.getContext() : this.vodPlayerView.getContext();
            }
            return new WatchPlayback(this);
        }
    }

    public static interface DocumentEventCallback {
        public void onEvent(String var1, List<MessageServer.MsgInfo> var2);

        public void onEvent(MessageServer.MsgInfo var1);

        public void onEvent(String var1, String var2, View var3);

        public void onError(int var1, int var2, String var3);
    }
}

