/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.Live;
import com.vhall.business.MessageServer;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.WatchLive;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.player.MPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

class WatchLiveFlash
extends Live {
    private MPlayer mPlayer;
    private MessageServer messageServer;
    private ChatServer chatServer;

    @Override
    public String getDefinition() {
        if (this.mPlayer != null) {
            return this.mPlayer.mDispatcher.mCurrentDPI;
        }
        return "";
    }

    @Override
    public void setDefinition(String definition) {
        if (this.mPlayer != null) {
            this.mPlayer.setDefinition(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.mPlayer) {
            this.mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.mPlayer) {
            this.mPlayer.unmute();
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (this.mPlayer != null) {
            this.mPlayer.pushMsgInfo();
        }
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.messageServer.setWebinarInfo(webinarInfo);
        this.chatServer.setWebinarInfo(webinarInfo);
        this.VR = webinarInfo.is_publish_vr == 1;
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    public WatchLiveFlash(WatchLive.Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;
        this.mPlayer = new MPlayer(this.context, 1);
        this.mPlayer.setListener(this.listener);
        this.mPlayer.setmBufferSeconds(builder.buffSeconds);
        this.mPlayer.setmConnectTimeout(builder.connectTimeout);
        this.messageServer = new MessageServer();
        this.messageServer.setCallback(this.messageCallback);
        this.messageServer.setmPlayLive(this.mPlayer);
        this.chatServer = new ChatServer();
        this.chatServer.setCallback(this.chatCallback);
    }

    @Override
    public void start() {
        if (this.mPlayer == null || this.mPlayer.isPlaying()) {
            return;
        }
        if (!this.isAvaliable()) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.webinarInfo.status != 1) {
            if (this.listener != null) {
                this.listener.onError(20209, 0, String.format(this.context.getString(R.string.playing_status), this.webinarInfo.getStatusStr()));
            }
            return;
        }
        this.mPlayer.setLogParam(this.getDataCollectionStr());
        if (this.videoContainer != null) {
            this.initWH(this.videoContainer.getWidth(), this.videoContainer.getHeight());
        }
        this.mPlayer.setVideoPlayer(this.videoView);
        this.mPlayer.startPlay(this.setRefreshURL(), this.setDefaultURL());
        this.setWaterMark();
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.destoryPlayview();
        this.messageServer.disconnect();
        this.chatServer.disconnect();
    }

    @Override
    public void startPlay(String url) {
        if (this.mPlayer != null) {
            this.mPlayer.startPlay(url);
        }
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public void releasePlayer() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
    }

    private String getDataCollectionStr() {
        String dataCollection = "";
        if (this.webinarInfo != null && this.webinarInfo.data_report != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("s", (Object)this.webinarInfo.session_id);
                jsonObject.put("topic", (Object)this.webinarInfo.data_report.topic);
                jsonObject.put("bu", VhallSDK.BU);
                jsonObject.put("vfid", (Object)this.webinarInfo.data_report.vfid);
                jsonObject.put("vid", (Object)this.webinarInfo.data_report.vid);
                jsonObject.put("vtype", (Object)this.webinarInfo.data_report.vtype);
                jsonObject.put("aid", (Object)this.webinarInfo.webinar_id);
                jsonObject.put("uid", (Object)this.webinarInfo.join_id);
                jsonObject.put("guid", (Object)this.webinarInfo.data_report.guid);
                jsonObject.put("pf", 5);
                jsonObject.put("app_id", (Object)VhallSDK.APP_KEY);
                jsonObject.put("host", (Object)this.webinarInfo.data_report.host);
                if (this.context != null) {
                    jsonObject.put("ndi", (Object)VhallSDK.getmIMEI());
                }
                dataCollection = jsonObject.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return dataCollection;
    }

    private void destoryPlayview() {
        if (this.videoView != null && this.videoContainer != null) {
            this.videoContainer.removeView((View)this.videoView);
        }
    }

    @Override
    public void connectChatServer() {
        if (this.chatServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.chatServer.connect();
    }

    @Override
    public void disconnectChatServer() {
        if (this.chatServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.chatServer.disconnect();
    }

    @Override
    public void connectMsgServer() {
        if (this.messageServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.messageServer.connect();
    }

    @Override
    public void disconnectMsgServer() {
        if (this.messageServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.messageServer.disconnect();
    }

    @Override
    public void sendChat(String content, RequestCallback callback) {
        this.chatServer.sendChat(content, callback);
    }

    @Override
    public void sendCustom(JSONObject content, RequestCallback callback) {
        this.chatServer.sendCustom(content, callback);
    }

    @Override
    public void sendQuestion(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }
        this.chatServer.sendQuestion(VhallSDK.user.user_id, content, callback);
    }

    @Override
    public void onRaiseHand(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.onHand(this.webinarInfo.join_id, webinarId, type, callback);
    }

    @Override
    public void replyInvitation(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.replyInvitation(this.webinarInfo.join_id, webinarId, type, callback);
    }

    @Override
    public void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback) {
        this.chatServer.acquireChatRecord(show_all, chatRecordCallback);
    }

    @Override
    public void acquireChatRecord(int page, ChatServer.ChatRecordCallback chatRecordCallback) {
        this.chatServer.acquireChatRecord(true, chatRecordCallback);
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public String getOriginalUrl() {
        if (this.webinarInfo.getCast_screen() == 1 && this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    private void setWaterMark() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(WatchLiveFlash.this.waterMarkUrl);
                    HttpURLConnection conn = WatchLiveFlash.this.waterMarkUrl.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
                    BitmapDrawable drawable = new BitmapDrawable(WatchLiveFlash.this.context.getResources(), bitmap);
                    WatchLiveFlash.this.mDelivery.post(new Runnable(){
                        final /* synthetic */ Drawable val$drawable;
                        {
                            this.val$drawable = drawable;
                        }

                        @Override
                        public void run() {
                            if (WatchLiveFlash.this.videoView != null && ((VHVideoPlayerView)WatchLiveFlash.this.videoView).getWaterMark() == null) {
                                ((VHVideoPlayerView)WatchLiveFlash.this.videoView).setWaterMark(this.val$drawable);
                                switch (WatchLiveFlash.this.waterMarkGravity) {
                                    case 1: {
                                        ((VHVideoPlayerView)WatchLiveFlash.this.videoView).setWaterMarkGravity(3);
                                        break;
                                    }
                                    case 2: {
                                        ((VHVideoPlayerView)WatchLiveFlash.this.videoView).setWaterMarkGravity(5);
                                        break;
                                    }
                                    case 3: {
                                        ((VHVideoPlayerView)WatchLiveFlash.this.videoView).setWaterMarkGravity(85);
                                        break;
                                    }
                                    case 4: {
                                        ((VHVideoPlayerView)WatchLiveFlash.this.videoView).setWaterMarkGravity(83);
                                        break;
                                    }
                                }
                            }
                        }
                    });
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

