/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.utils.LogManager;
import com.vhall.jni.VhallLiveApi;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Watch {
    private static final String TAG = "WatchNew";
    public static final int ERROR_NOT_INIT = 20202;
    public static final int ERROR_STATE = 20209;
    public static final int EVENT_INIT_PLAYER_SUCCESS = 20300;
    protected Context context;
    protected VHPlayerListener listener;
    protected WebinarInfo webinarInfo;
    protected String saveProtocol = null;
    protected int scaleType = 0;
    protected MessageServer.Callback messageCallback;
    protected ChatServer.Callback chatCallback;
    protected Handler mDelivery;

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public abstract void startPlay(String var1);

    public abstract boolean setVideoBackgroundColor(int var1);

    public abstract boolean setVideoBackgroundImage(Bitmap var1);

    public abstract boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback var1);

    public abstract void releasePlayer();

    public abstract void setDefinition(String var1);

    public abstract boolean isPlaying();

    public abstract void mute();

    public abstract void unMute();

    public abstract String getOriginalUrl();

    public abstract void initWH(int var1, int var2);

    protected void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
        if (this.mDelivery == null) {
            this.mDelivery = new Handler(Looper.getMainLooper());
        }
    }

    protected void setOPSDelay(int delayMs) {
    }

    public double getCheatNum() {
        return this.webinarInfo.cheat_num;
    }

    public boolean isAvaliable() {
        return this.webinarInfo != null && !TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id);
    }

    public String getNotice() {
        if (this.isAvaliable() && this.webinarInfo.notice != null) {
            return this.webinarInfo.notice.content;
        }
        return null;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(int scaleType) {
        this.scaleType = scaleType;
    }

    protected String setRefreshURL() {
        Random random = new Random();
        String url = null;
        if (this.webinarInfo.status == 1) {
            if (!TextUtils.isEmpty((CharSequence)this.webinarInfo.against_url) && !TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
                String rand = String.valueOf(random.nextInt(999999999));
                url = this.webinarInfo.against_url + "api/dispatch_play?webinar_id=" + this.webinarInfo.webinar_id + "&rand=" + rand + "&uid=" + this.webinarInfo.join_id + "&bu=" + VhallSDK.BU;
            }
        } else if (!(this.webinarInfo.status != 4 || TextUtils.isEmpty((CharSequence)this.webinarInfo.against_url) || TextUtils.isEmpty((CharSequence)this.webinarInfo.video_path) || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id))) {
            String rand = String.valueOf(random.nextInt(999999999));
            url = this.webinarInfo.against_url + "api/dispatch_replay?webinar_id=" + this.webinarInfo.webinar_id + "&rand=" + rand + "&uri=" + this.webinarInfo.video_path + "&uid=" + this.webinarInfo.join_id + "&bu=" + VhallSDK.BU + "&quality=" + this.webinarInfo.qualitiesjson;
        }
        Log.i((String)TAG, (String)(" current dispath url = " + url));
        return url;
    }

    protected String setDefaultURL() {
        String defaultToken = VhallLiveApi.TokenTransition((String)this.webinarInfo.against_token);
        try {
            JSONArray jsonArray = new JSONArray();
            if (this.webinarInfo.status == 1) {
                return this.setDefaultLiveURL();
            }
            int num = this.webinarInfo.video.length() > 5 ? 5 : this.webinarInfo.video.length();
            for (int i = 0; i < num; ++i) {
                JSONObject Json = new JSONObject();
                if (this.webinarInfo.video.endsWith(".mp4")) {
                    this.saveProtocol = "mp4_domainname";
                } else if (this.webinarInfo.video.endsWith(".m3u8")) {
                    this.saveProtocol = "hls_domainname";
                }
                Json.put(this.saveProtocol, (Object)this.webinarInfo.video);
                jsonArray.put((Object)Json);
            }
            JSONObject j = new JSONObject();
            j.put("same", (Object)jsonArray);
            JSONObject data = new JSONObject();
            data.put("token", (Object)this.webinarInfo.against_token);
            data.put(this.saveProtocol + "s", (Object)j);
            JSONObject o = new JSONObject();
            o.put("data", (Object)data);
            LogManager.innerLog(TAG, " GetDefaultPlayBackUrls == " + o.toString());
            return o.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String setDefaultLiveURL() {
        String defaultToken = VhallLiveApi.TokenTransition((String)this.webinarInfo.against_token);
        JSONObject resultData = new JSONObject();
        try {
            if (this.webinarInfo.SD.valid == 1) {
                resultData.put("360p", (Object)this.changeURL(this.webinarInfo.SD.value, defaultToken));
            }
            if (this.webinarInfo.HD.valid == 1) {
                resultData.put("480p", (Object)this.changeURL(this.webinarInfo.HD.value, defaultToken));
            }
            if (this.webinarInfo.UHD.valid == 1) {
                resultData.put("720p", (Object)this.changeURL(this.webinarInfo.UHD.value, defaultToken));
            }
            if (this.webinarInfo.A.valid == 1) {
                resultData.put("a", (Object)this.changeURL(this.webinarInfo.A.value, defaultToken));
            }
            resultData.put("same", (Object)this.changeURL("", defaultToken));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogManager.innerLog(TAG, " GetDefaultPlayLiveUrls ---> " + resultData.toString());
        return resultData.toString();
    }

    private JSONArray changeURL(String value, String defaultToken) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        if (this.webinarInfo.streams == null || this.webinarInfo.streams.size() <= 0) {
            jsonArray.put((Object)(this.webinarInfo.rtmp_video + "?token=" + defaultToken));
            return jsonArray;
        }
        for (int i = 0; i < this.webinarInfo.streams.size(); ++i) {
            JSONObject Json = new JSONObject();
            String url = this.webinarInfo.streams.get((int)i).src.replace("{definition}", value) + "?token=" + defaultToken;
            Json.put("rtmp_url", (Object)url);
            jsonArray.put((Object)Json);
        }
        return jsonArray;
    }
}

