/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.business.BaseSDKApi;
import com.vhall.business.Broadcast;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.HttpDataSource;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.R;
import com.vhall.business.VhallCallback;
import com.vhall.business.Watch;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.IAccountApi;
import com.vhall.business.core.IActionNetApi;
import com.vhall.business.core.IChatInfoDataApi;
import com.vhall.business.core.IInteractiveNetApi;
import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.UserInfo;
import com.vhall.business.data.UserInfoData;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.SurveyDataSource;
import com.vhall.business.data.source.SurveyRepository;
import com.vhall.business.data.source.UserInfoDataSource;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.SurveyRemoteDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.business.utils.LogManager;
import com.vhall.business.utils.Md5Encode;
import com.vhall.business.utils.NetWorkUtil;
import com.vhall.business.utils.SignatureUtil;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.jni.VhallLiveApi;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VhallDeviceId;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.api.CoreNetApi;
import com.vhall.vhss.data.CreateRecordData;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.FilesData;
import com.vhall.vhss.data.GiftListData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.NoticeListInfoData;
import com.vhall.vhss.data.QuestionHistoryListData;
import com.vhall.vhss.data.RecordChaptersData;
import com.vhall.vhss.data.RecordsData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.RoomToolsStatusData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.data.VersionRollData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.netutils.EncryptionUtil;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.ChatNetworkRequest;
import com.vhall.vhss.network.UserNetworkRequest;
import com.vhall.vhss.network.VersionNetworkRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.data.ResponseAttributes;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.data.ResponseUserStatus;
import vhall.com.vss2.module.room.VssRoomManager;

public final class VhallSDK
extends BaseSDKApi {
    private static final String TAG = "VhallSDK";
    private static final String META_KEY_HOST = "com.vhall.sdk.host";
    private static final String META_KEY_BU = "com.vhall.sdk.bu";
    protected static String mHOST = "https://e.vhall.com/sdk/v2/";
    protected static String vhssUrl = "https://open-api.vhall.com";
    protected static String yunUrl = "";
    protected static String vssUrl = "";
    public static String SURVEY_URL = "https://cnstatic01.e.vhall.com/questionnaire/%s.html";
    public static String NEW_SURVEY_URL = "https://live.vhall.com";
    public static String DOMAIN = "https://e.vhall.com";
    public static final int PLANTFORM = 5;
    public static int BU = 0;
    public static boolean versionBall = false;
    public static String reportUrl = "https://dc.e.vhall.com";
    public static String APP_KEY = "";
    protected static String APP_SECRET_KEY = "";
    protected static String packageName = "";
    protected static String signature = "";
    public static Context mContext;
    private static String mVersion;
    public static UserInfo user;
    private static String mPhone;
    private static String mNetType;
    private static String mIMEI;
    protected static String header;
    public static String SURVEY_URL_FORMAT;
    public static String third_account_id;
    private static IInteractiveNetApi sInteractiveInternalApi;
    private static IChatInfoDataApi chatInfoDataChange;
    private static IActionNetApi actionNetApi;
    private static IAccountApi sAccountApi;
    private static final String atomFormat = "cv=%s&dt=%s&pf=%s&uid=%s&cn=%s&imei=%s";
    private static String appId;

    private VhallSDK() {
    }

    public static void setLogEnable(boolean enable) {
        LogManager.isDebug = enable;
        VhallLiveApi.EnableDebug((boolean)enable);
    }

    public static String getVersion() {
        return mVersion;
    }

    public static void setRsaPrivateKey(String rsaPrivateKey) {
        TokenManger.setSignType("0");
        if (rsaPrivateKey != null && rsaPrivateKey.length() > 0) {
            rsaPrivateKey = rsaPrivateKey.trim();
            rsaPrivateKey = rsaPrivateKey.replaceAll("-----BEGIN PRIVATE KEY-----", "");
            rsaPrivateKey = rsaPrivateKey.replaceAll("-----END PRIVATE KEY-----", "");
            EncryptionUtil.USER_PRIVATE_KEY = rsaPrivateKey = rsaPrivateKey.trim();
            TokenManger.setSignType("1");
        } else {
            EncryptionUtil.USER_PRIVATE_KEY = rsaPrivateKey;
        }
    }

    public static void init(Context context, String app_key, String app_secret_key) {
        VhallSDK.init(context, app_key, app_secret_key, "");
    }

    public static void init(Context context, String app_key, String app_secret_key, String host) {
        APP_KEY = app_key;
        APP_SECRET_KEY = app_secret_key;
        mContext = context;
        VhallSDK.initHeader();
        VssSdk.getInstance().init(context, appId, VhallSDK.getUserId(), vssUrl, yunUrl);
        if (!TextUtils.isEmpty((CharSequence)host)) {
            mHOST = "https://" + host + "/sdk/v2/";
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            packageName = SignatureUtil.getPackageName(mContext);
        }
        if (TextUtils.isEmpty((CharSequence)signature)) {
            signature = SignatureUtil.getSignatureSHA1(mContext);
        }
        VhallSDK.initUserInfo();
        CoreNetApi.getNet().init(mContext, vhssUrl, "", "5");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_key", APP_KEY);
        hashMap.put("package_name", packageName);
        hashMap.put("signature", signature);
        hashMap.put("client_version", "6.23.0");
        CoreNetApi.getNet().setPostParams(hashMap);
        CoreApiConstant.SECRET_KEY = APP_SECRET_KEY;
        VhallSDK.initBu();
        VhallSDK.initNetRequestInfo();
        VhallSDK.initBeauty();
    }

    private static void initBeauty() {
    }

    private static void initNetRequestInfo() {
        sInteractiveInternalApi = VhallNetApiFactory.createInteractiveApi();
        chatInfoDataChange = VhallNetApiFactory.createChatApi();
        actionNetApi = VhallNetApiFactory.createActionNetApi();
        sAccountApi = VhallNetApiFactory.createAccountApi();
    }

    private static Bundle createReportBundle() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("PS_V", (Object)com.vhall.framework.VhallSDK.getInstance().getVersion());
            jsonObject.put("SA_V", (Object)VhallSDK.getVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Bundle bundle = new Bundle();
        bundle.putString("extra", jsonObject.toString());
        return bundle;
    }

    private static void initHeader() {
        mPhone = Build.MANUFACTURER + Build.MODEL;
        mIMEI = VhallSDK.getmIMEI();
        mNetType = NetWorkUtil.getNetworkType(mContext);
        header = VhallSDK.getAtom();
    }

    public static String getmIMEI() {
        if (TextUtils.isEmpty((CharSequence)mIMEI)) {
            mIMEI = VhallDeviceId.getVhallDeviceId((Context)mContext, (boolean)true);
        }
        return mIMEI;
    }

    private static void initBu() {
        VersionNetworkRequest.versionInitConfig(APP_KEY, new CallBack<VersionRollData>(){

            @Override
            public void onSuccess(VersionRollData result) {
                if (result != null) {
                    BU = TextUtils.isEmpty((CharSequence)result.bu) ? 0 : Integer.parseInt(result.bu);
                    versionBall = TextUtils.equals((CharSequence)"1", (CharSequence)result.is_roll_back);
                    if (!TextUtils.isEmpty((CharSequence)result.data_domain) && result.data_domain.startsWith("http")) {
                        reportUrl = result.data_domain;
                    }
                }
                VhallSDK.initLogReporter();
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhallSDK.initLogReporter();
            }
        });
    }

    private static void initLogReporter() {
        LogReporter.getInstance().init(mContext, "", mVersion, BU, VhallBaseSDK.getInstance().getAPP_ID(), VhallSDK.getUserId());
        LogReporter.getInstance().initExtra(VhallSDK.createReportBundle());
        LogInfo.getInstance().initStaticData(VhallBaseSDK.getInstance().getAPP_ID(), VhallBaseSDK.getInstance().mIMEI, reportUrl + "/login", 5, 0);
        LogReporter.getInstance().onCollection("2001", null);
        LogManager.innerLog(TAG, "packageName:" + packageName + " signature:" + signature);
    }

    private static void initMeta() {
        try {
            ApplicationInfo appInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            String host = appInfo.metaData.getString(META_KEY_HOST);
            if (!TextUtils.isEmpty((CharSequence)host)) {
                mHOST = host;
                BU = appInfo.metaData.getInt(META_KEY_BU);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean isInit() {
        return !TextUtils.isEmpty((CharSequence)APP_KEY) && !TextUtils.isEmpty((CharSequence)APP_SECRET_KEY);
    }

    private static void initUserInfo() {
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.saveAppkey(mContext, APP_KEY);
        VhallSDK.configInfoData();
    }

    private static void configInfoData() {
        if (VhallSDK.isLogin()) {
            UserInfoData infoData = new UserInfoData(VhallSDK.user.user_id, VhallSDK.user.nick_name, VhallSDK.user.avatar, "2", "3", "1", "0", "0", third_account_id);
            if (!TextUtils.isEmpty((CharSequence)VhallSDK.user.user_id)) {
                VssSdk.getInstance().setUserId(VhallSDK.user.user_id);
            }
            com.vhall.framework.VhallSDK.getInstance().setUserInfo(infoData.toJsonString());
        }
        VssSdk.getInstance().setClient_version("6.23.0");
    }

    public static boolean isLogin() {
        return user != null && !TextUtils.isEmpty((CharSequence)VhallSDK.user.user_id);
    }

    public static void loginByThirdId(String thirdId, String userName, String headNetUrl, UserInfoDataSource.UserInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)thirdId) || TextUtils.isEmpty((CharSequence)thirdId.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("head", TextUtils.isEmpty((CharSequence)headNetUrl) ? "" : headNetUrl.trim());
        map.put("nick_name", TextUtils.isEmpty((CharSequence)userName) ? "" : userName.trim());
        map.put("third_user_id", thirdId.trim());
        sAccountApi.loginByThirdId(map, new LoginCallbackInternalImpl(callback, userName.trim()));
        third_account_id = thirdId.trim();
    }

    public static void login(String userName, String passWord, UserInfoDataSource.UserInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userName) || TextUtils.isEmpty((CharSequence)passWord) || TextUtils.isEmpty((CharSequence)userName.trim()) || TextUtils.isEmpty((CharSequence)passWord.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        sAccountApi.login(userName, passWord, "", new LoginCallbackInternalImpl(callback, userName));
        third_account_id = userName;
    }

    public static void logout() {
        user = null;
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.clearUserInfo(mContext);
        VhallSDK.configInfoData();
        UserNetworkRequest.logout(null);
        LogReportManager.doReport("115002");
        third_account_id = "";
    }

    public static String getUserName() {
        return VhallSDK.isLogin() ? VhallSDK.user.account : "";
    }

    public static String getUserNickname() {
        return VhallSDK.isLogin() ? VhallSDK.user.nick_name : "";
    }

    public static String getUserAvatar() {
        return VhallSDK.isLogin() ? VhallSDK.user.avatar : "";
    }

    public static String getUserId() {
        if (VhallSDK.isLogin()) {
            return VhallSDK.user.user_id;
        }
        return "";
    }

    private static void getVssRoomInfo(final RequestCallback callback, final Broadcast broadcast, final WebinarInfo webinarInfo) {
        VssRoomManager.getInstance().enterRoom(webinarInfo.vss_token, webinarInfo.vss_room_id, new vhall.com.vss2.CallBack<ResponseRoomInfo>(){

            @Override
            public void onSuccess(ResponseRoomInfo result) {
                broadcast.setWebinarInfo(VhallSDK.dealVssRoomInfo(result, webinarInfo));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhallCallback.ErrorCallback(callback, eventCode, msg);
            }
        });
    }

    private static WebinarInfo dealVssRoomInfo(ResponseRoomInfo result, WebinarInfo webinarInfo) {
        ResponseAttributes attributes = result.getAttributes();
        if (attributes != null) {
            webinarInfo.hands_up = attributes.getIs_handsup();
            if (TextUtils.isEmpty((CharSequence)webinarInfo.hands_up)) {
                webinarInfo.hands_up = "0";
            }
        }
        if (!VhallSDK.isLogin()) {
            VssSdk.getInstance().setUserId(result.getThird_party_user_id());
        } else {
            ResponseUserStatus userStatus = result.getUserStatus();
            if (userStatus != null && !TextUtils.isEmpty((CharSequence)userStatus.getIs_banned())) {
                webinarInfo.chatforbid = "1".equals(userStatus.getIs_banned());
                webinarInfo.chatOwnForbid = "1".equals(userStatus.getIs_banned());
            }
            if (attributes != null && !TextUtils.isEmpty((CharSequence)attributes.getAll_banned())) {
                webinarInfo.chatforbid = "1".equals(attributes.getAll_banned()) || webinarInfo.chatforbid;
                webinarInfo.chatAllForbid = "1".equals(attributes.getAll_banned());
            }
            webinarInfo.nick_name = VhallSDK.getUserName();
        }
        return webinarInfo;
    }

    public static void initBroadcast(String id, String accessToken, String nickName, Broadcast broadcast, RequestCallback callback) {
        VhallSDK.initBroadcast(id, accessToken, nickName, "", broadcast, callback);
    }

    public static void initBroadcast(final String id, final String accessToken, String nickName, String email, final Broadcast broadcast, final RequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)id) || broadcast == null) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getBroadcastWebinarInfo(id.trim(), accessToken.trim(), nickName.trim(), email.trim(), VhallSDK.getUserId().trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (webinarInfo.status == 1 || webinarInfo.status == 5) {
                    VhallCallback.ErrorCallback(callback, 20101, "\u5f53\u524d\u89c6\u9891\u5904\u5728" + webinarInfo.getStatusStr() + "\u72b6\u6001");
                } else {
                    broadcast.setWebinarInfo(webinarInfo);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    if (TextUtils.isEmpty((CharSequence)accessToken)) {
                        VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
                        return;
                    }
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getBroadcastWebinarInfo(id, accessToken, VhallSDK.getUserId(), new WebinarInfoDataSource.LoadWebinarInfoCallback(){

                        @Override
                        public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                            if (webinarInfo.status == 1 || webinarInfo.status == 5) {
                                VhallCallback.ErrorCallback(callback, 20101, "\u5f53\u524d\u89c6\u9891\u5904\u5728" + webinarInfo.getStatusStr() + "\u72b6\u6001");
                            } else if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                VhallSDK.getVssRoomInfo(callback, broadcast, webinarInfo);
                            } else {
                                broadcast.setWebinarInfo(webinarInfo);
                                if (callback != null) {
                                    callback.onSuccess();
                                }
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    public static void initDirector(String id, String seatId, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)seatId)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getCloudBroadcastWebinarInfo(id.trim(), seatId.trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
            }
        });
    }

    public static void getBaseWebinarInfo(String id, RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getBaseWebinarInfo(id, callback);
    }

    public static void getDirectorStatus(String id, RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorStatus(id, callback);
    }

    public static void getDirectorStreamStatus(String id, RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorStreamStatus(id, callback);
    }

    public static void setDevice(String room_id, String status, RequestCallback callBack) {
        WebinarInfoRemote.getInstance().setDevice(room_id, status, callBack);
    }

    public static void directorSelectSeat(String id, String seatId, RequestCallback callback) {
        WebinarInfoRemote.getInstance().directorSelectSeat(id, seatId, callback);
    }

    public static void getDirectorSeatList(String id, RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorSeatList(id, callback);
    }

    public static void initBroadcast(String id, String accessToken, String nickName, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.initBroadcast(id, accessToken, nickName, "", callback);
    }

    public static void initBroadcast(String id, String accessToken, String liveToken, String nickName, String email, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.initBroadcast(id, accessToken, liveToken, nickName, email, callback, false);
    }

    public static void initBroadcast(String id, String accessToken, String nickName, WebinarInfoDataSource.LoadWebinarInfoCallback callback, boolean onlyNewInteractive) {
        VhallSDK.initBroadcast(id, accessToken, "", nickName, "", callback, onlyNewInteractive);
    }

    private static void initBroadcast(final String id, final String accessToken, String liveToken, String nickName, String email, final WebinarInfoDataSource.LoadWebinarInfoCallback callback, final boolean onlyNewInteractive) {
        if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)id.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getBroadcastWebinarInfo(id.trim(), TextUtils.isEmpty((CharSequence)accessToken) ? "" : accessToken.trim(), TextUtils.isEmpty((CharSequence)liveToken) ? "" : liveToken, TextUtils.isEmpty((CharSequence)nickName) ? "" : nickName.trim(), TextUtils.isEmpty((CharSequence)email) ? "" : email.trim(), TextUtils.isEmpty((CharSequence)VhallSDK.getUserId()) ? "" : VhallSDK.getUserId().trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    if (onlyNewInteractive) {
                        if (callback != null) {
                            callback.onError(errorCode, errorMsg);
                        }
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)accessToken)) {
                        VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
                        return;
                    }
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getBroadcastWebinarInfo(id, accessToken, VhallSDK.getUserId(), new WebinarInfoDataSource.LoadWebinarInfoCallback(){

                        @Override
                        public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                            if (callback != null) {
                                if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                    VhallSDK.getVssRoomInfo(callback, jsonStr, webinarInfo);
                                } else {
                                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                }
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    public static void initBroadcast(String id, String accessToken, String nickName, String email, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.initBroadcast(id, accessToken, "", nickName, email, callback);
    }

    private static void getVssRoomInfo(final WebinarInfoDataSource.LoadWebinarInfoCallback callback, final String jsonStr, final WebinarInfo webinarInfo) {
        VssRoomManager.getInstance().enterRoom(webinarInfo.vss_token, webinarInfo.vss_room_id, new vhall.com.vss2.CallBack<ResponseRoomInfo>(){

            @Override
            public void onSuccess(ResponseRoomInfo result) {
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, VhallSDK.dealVssRoomInfo(result, webinarInfo));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhallCallback.ErrorCallback(callback, eventCode, msg);
            }
        });
    }

    public static void startBroadcast(String id, final RequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (NewH5ImManager.enter) {
            ActivityNetworkRequest.liveStart(id, "", "3", new CallBack(){

                public void onSuccess(Object s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else if (callback != null) {
            callback.onError(-1, "\u5f53\u524d\u6d3b\u52a8\u4e0d\u652f\u6301");
        }
    }

    public static void finishBroadcast(String id, String accessToken, Broadcast broadcast, RequestCallback callback) {
        VhallSDK.finishBroadcast(id, accessToken, broadcast, false, callback);
    }

    public static void finishBroadcast(String id, String accessToken, Broadcast broadcast, boolean rehearsal, final RequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (VssRoomManager.enter) {
            VssRoomManager.getInstance().roomEndLive(new vhall.com.vss2.CallBack<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else if (NewH5ImManager.enter) {
            ActivityNetworkRequest.liveEnd(id, "", "3", rehearsal ? "2" : "0", new CallBack(){

                public void onSuccess(Object s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else if (broadcast != null) {
            if (TextUtils.isEmpty((CharSequence)accessToken)) {
                VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
                return;
            }
            WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
            repository.stopBroadcast(id, accessToken, callback);
            broadcast.stop();
        } else {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
        }
    }

    public static void queryWatchAuth(String webinarId, WebinarInfoDataSource.WatchAuthQueryCallback callback) {
        if (TextUtils.isEmpty((CharSequence)webinarId) || TextUtils.isEmpty((CharSequence)webinarId.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().queryWatchAuth(webinarId, null, null, callback);
    }

    public static void checkWatchAuth(String webinarId, String type, String verifyValue, WebinarInfoDataSource.WatchAuthCallback callback) {
        if (TextUtils.isEmpty((CharSequence)webinarId) || TextUtils.isEmpty((CharSequence)webinarId.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().checkWatchAuth(webinarId, type, verifyValue, callback);
    }

    public static void initWatch(String webinarId, String email, String nickname, boolean watchAuth, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> authConfig = new HashMap<String, String>();
        authConfig.put("auth_model", watchAuth ? "1" : "0");
        VhallSDK.doInitWatch(webinarId, "", email, nickname, null, -1, null, authConfig, callback);
    }

    public static void initWatch(String webinarId, String record_id, String email, String nickname, boolean watchAuth, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> authConfig = new HashMap<String, String>();
        authConfig.put("auth_model", watchAuth ? "1" : "0");
        VhallSDK.doInitWatch(webinarId, record_id, email, nickname, null, -1, null, authConfig, callback);
    }

    public static void initWatch(String id, String email, String nickname, String password, String k_id, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.initWatch(id, email, nickname, password, -1, k_id, callback);
    }

    public static void initWatch(String id, String email, String nickname, String password, int status, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.initWatch(id, email, nickname, password, status, "", callback);
    }

    public static void initWatch(String id, String email, String nickname, String password, int status, String k_id, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        VhallSDK.doInitWatch(id, "", email, nickname, password, status, k_id, null, callback);
    }

    private static void doInitWatch(final String id, String record_id, final String email, final String nickname, final String password, final int status, String k_id, HashMap<String, String> authConfig, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)id.trim())) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        final String vhallId = VhallSDK.getUserId();
        LogReportManager.doReport("115011");
        WebinarInfoRemote.getInstance().getWatchWebinarInfo(id.trim(), TextUtils.isEmpty((CharSequence)nickname) ? "" : nickname.trim(), TextUtils.isEmpty((CharSequence)email) ? "" : email.trim(), TextUtils.isEmpty((CharSequence)password) ? "" : password.trim(), vhallId.trim(), record_id, k_id, authConfig, new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (webinarInfo != null) {
                    String userInfoStr = com.vhall.framework.VhallSDK.getInstance().getmUserInfo();
                    if (!TextUtils.isEmpty((CharSequence)userInfoStr)) {
                        try {
                            JSONObject userInfo = new JSONObject(userInfoStr);
                            userInfo.put("pv", webinarInfo.pv);
                            com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toString());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    if (webinarInfo.status == 1 && status == 1) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    if (!(webinarInfo.status != 4 && webinarInfo.status != 5 || status != 4 && status != 5)) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    if (webinarInfo.status == 2) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    if (status == -1) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    VhallCallback.ErrorCallback(callback, 20209, String.format(mContext.getString(R.string.playing_status), webinarInfo.getStatusStr()));
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getWatchWebinarInfo(id, nickname, email, TextUtils.isEmpty((CharSequence)password) ? "" : password.trim(), vhallId, "", new WebinarInfoDataSource.LoadWebinarInfoCallback(){

                        @Override
                        public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                            if (webinarInfo != null) {
                                String userInfoStr;
                                if (!TextUtils.isEmpty((CharSequence)webinarInfo.report_extra)) {
                                    LogInfo.getInstance().setExtraData(webinarInfo.report_extra);
                                }
                                if (!TextUtils.isEmpty((CharSequence)(userInfoStr = com.vhall.framework.VhallSDK.getInstance().getmUserInfo()))) {
                                    try {
                                        JSONObject userInfo = new JSONObject(userInfoStr);
                                        userInfo.put("pv", webinarInfo.online);
                                        com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toString());
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (webinarInfo.status == 1 && status == 1) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                            VhallSDK.getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                if (!(webinarInfo.status != 4 && webinarInfo.status != 5 || status != 4 && status != 5)) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                            VhallSDK.getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                if (webinarInfo.status == 2) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                            VhallSDK.getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                if (status == -1) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty((CharSequence)webinarInfo.vss_token)) {
                                            VhallSDK.getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                VhallCallback.ErrorCallback(callback, 20209, String.format(mContext.getString(R.string.playing_status), webinarInfo.getStatusStr()));
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    public static void performSignIn(String webinarId, String signId, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId) || TextUtils.isEmpty((CharSequence)signId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callBack, 20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.performSignIn(webinarId, signId, callBack);
    }

    public static void getHistorySurveyList(String switchId, String roomId, String webinarId, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId) || TextUtils.isEmpty((CharSequence)roomId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callBack, 20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.getHistorySurvey(switchId, roomId, webinarId, callBack);
    }

    public static void getHistoryLotteryList(String show_all, RequestDataCallback callBack) {
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callBack, 20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.getHistoryLotteryList(show_all, callBack);
    }

    public static void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)join_id) || TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)join_id.trim()) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || TextUtils.isEmpty((CharSequence)name.trim())) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.submitLotteryInfo(join_id.trim(), lottery_id.trim(), name.trim(), TextUtils.isEmpty((CharSequence)phone) ? "" : phone.trim(), TextUtils.isEmpty((CharSequence)remark) ? "" : remark.trim(), callBack);
    }

    public static void submitLotteryInfo(String lottery_id, List<LotteryPrizeListInfo> infoList, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || infoList == null || infoList.isEmpty()) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.submitLotteryInfo(lottery_id.trim(), infoList, callBack);
    }

    public static void getRoleName(String webinar_id, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinar_id)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        ActivityNetworkRequest.getRoleName(webinar_id, new CallBack<RoleNameData>(){

            @Override
            public void onSuccess(RoleNameData result) {
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    public static void lotteryCheck(RequestDataCallback callBack) {
        actionNetApi.lotteryCheck(callBack);
    }

    public static void getAgreement(String webinarId, RequestDataCallback callBack) {
        actionNetApi.getAgreement(webinarId, callBack);
    }

    public static void setUserAgreeAgreement(String webinarId, RequestCallback callBack) {
        actionNetApi.setUserAgreeAgreement(webinarId, callBack);
        LogReportManager.doReport("115038");
    }

    @Deprecated
    public static void getPrizeInfo(String webinarId, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getPrizeInfo(webinarId, callBack);
    }

    public static void getPrizeInfo(String webinarId, String lottery_id, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getPrizeInfo(webinarId, lottery_id, callBack);
    }

    public static void getLotteryWinner(String room_id, String lottery_id, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)room_id) || TextUtils.isEmpty((CharSequence)lottery_id)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getLotteryWinner(room_id, lottery_id, callBack);
    }

    public static void joinCodeLottery(String room_id, String lottery_id, String command, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)command) || TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)room_id) || TextUtils.isEmpty((CharSequence)command.trim()) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || TextUtils.isEmpty((CharSequence)room_id.trim())) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.joinCodeLottery(room_id.trim(), lottery_id.trim(), command.trim(), callBack);
    }

    public static void getSurveyInfo(String survey_id, SurveyDataSource.SurveyInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)survey_id)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        repository.getSurveyInfo(survey_id, callback);
    }

    public static void submitSurveyInfo(Watch watch, String surveyid, String result, RequestCallback callback) {
        if (!VhallSDK.isLogin() || TextUtils.isEmpty((CharSequence)surveyid) || TextUtils.isEmpty((CharSequence)result)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        if (watch != null && watch.webinarInfo != null && !TextUtils.isEmpty((CharSequence)watch.webinarInfo.webinar_id)) {
            repository.submitSurveyInfo(VhallSDK.getUserId(), watch.webinarInfo.webinar_id, surveyid, result, callback);
        } else {
            repository.submitSurveyInfo(VhallSDK.getUserId(), "", surveyid, result, callback);
        }
    }

    public static void submitSurveyInfo(String webinar_id, String surveyid, String result, RequestCallback callback) {
        if (!VhallSDK.isLogin() || TextUtils.isEmpty((CharSequence)surveyid) || TextUtils.isEmpty((CharSequence)result)) {
            VhallCallback.ErrorCallback(callback, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        repository.submitSurveyInfo(VhallSDK.getUserId(), webinar_id, surveyid, result, callback);
    }

    public static void getAnswerList(String webinarId, final ChatServer.ChatRecordCallback callback) {
        if (NewH5ImManager.enter) {
            ChatNetworkRequest.getQuestionHistory(NewH5ImManager.getInstance().getRoomId(), new CallBack<QuestionHistoryListData>(){

                @Override
                public void onSuccess(QuestionHistoryListData data) {
                    if (callback != null) {
                        callback.onDataLoaded(chatInfoDataChange.questionHistoryListDataChange(data));
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onFailed(eventCode, msg);
                    }
                }
            });
        } else {
            WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
            repository.getAnswerList(VhallSDK.getUserId(), webinarId, callback);
        }
    }

    public static void getToken(String secretkey, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        String url = "http://e.vhall.com/api/vhallapi/v2/verify/access-token";
        long timemiles = System.currentTimeMillis();
        url = url + "?app_key=" + APP_KEY;
        url = url + "&auth_type=2";
        url = url + "&signed_at=" + timemiles;
        String sign = secretkey + "app_key" + APP_KEY + "auth_type2signed_at" + timemiles + secretkey;
        sign = Md5Encode.getMD5(sign);
        url = url + "&sign=" + sign;
        repository.getPublishToken(url, callback);
    }

    protected static String getDispatchURL(String url, String def) {
        String result = def;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return result;
        }
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = HttpDataSource.getOkHttpClient().newCall(request).execute();
            result = response.isSuccessful() ? response.body().string() : "";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getAtom() {
        String atom = String.format(atomFormat, mVersion, mPhone, 5, VhallSDK.getUserId(), mNetType, mIMEI);
        Base64.encodeToString((byte[])atom.getBytes(), (int)2);
        LogManager.e(TAG, "atom:" + atom + " basic64 == " + Base64.encodeToString((byte[])atom.getBytes(), (int)2));
        return Base64.encodeToString((byte[])atom.getBytes(), (int)2);
    }

    public void setDebugMode(boolean debugMode) {
        LogReporter.getInstance().setDebug(debugMode);
    }

    public static void joinWebinar(String webinarId, String password, String nickname, String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack) {
        VhallSDK.joinWebinar(webinarId, password, nickname, "", type, callBack);
    }

    public static void joinWebinar(String webinarId, String password, String nickname, String avatar, String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack) {
        sInteractiveInternalApi.joinWebinar(TextUtils.isEmpty((CharSequence)webinarId) ? "" : webinarId.trim(), TextUtils.isEmpty((CharSequence)password) ? "" : password.trim(), TextUtils.isEmpty((CharSequence)nickname) ? "" : nickname.trim(), TextUtils.isEmpty((CharSequence)avatar) ? "" : avatar.trim(), TextUtils.isEmpty((CharSequence)type) ? "" : type.trim(), callBack);
    }

    public static void getRoundUsers(String room_id, String isNext, RequestDataCallback callBack) {
        sInteractiveInternalApi.getRoundUsers(TextUtils.isEmpty((CharSequence)room_id) ? "" : room_id.trim(), TextUtils.isEmpty((CharSequence)isNext) ? "0" : isNext.trim(), callBack);
    }

    public static void getNoticeList(String room_id, int page, int limit, RequestDataCallbackV2<NoticeListInfoData> callback) {
        WebinarInfoRemote.getInstance().getNoticeList(room_id, page, limit, callback);
    }

    public static void getTimerInfo(RequestDataCallbackV2<TimerInfoData> callback) {
        actionNetApi.getTimerInfo(callback);
    }

    public static void userLike(String room_id, String num, RequestCallback callback) {
        actionNetApi.userLike(room_id, num, callback);
    }

    public static void getRoomLike(String room_id, RequestDataCallbackV2<Integer> callback) {
        actionNetApi.getRoomLike(room_id, callback);
    }

    public static void getGiftList(String room_id, RequestDataCallbackV2<GiftListData> callback) {
        WebinarInfoRemote.getInstance().getGiftList(room_id, callback);
    }

    public static void sendGift(String room_id, String gift_id, String channel, String service_code, String open_id, RequestCallback callback) {
        WebinarInfoRemote.getInstance().sendGift(room_id, gift_id, channel, service_code, open_id, callback);
    }

    public static void permissionsCheck(String webinar_id, String host_id, RequestDataCallbackV2<String> callBack) {
        WebinarInfoRemote.getInstance().getConfigList("1", webinar_id, TextUtils.isEmpty((CharSequence)host_id) ? "" : host_id, callBack);
    }

    public static void getDocList(String webinar_id, String room_id, int page, int limit, String keyword, RequestDataCallbackV2<DocListInfoData> callBack) {
        WebinarInfoRemote.getDocList(webinar_id, room_id, page, limit, keyword, callBack);
    }

    public static void createRecord(String webinar_id, String live_type, RequestDataCallbackV2<CreateRecordData> callBack) {
        WebinarInfoRemote.createRecord(webinar_id, live_type, callBack);
    }

    public static void getRecordChaptersList(String record_id, RequestDataCallbackV2<RecordChaptersData> callBack) {
        WebinarInfoRemote.getRecordChaptersList(record_id, callBack);
    }

    public static void getRecordList(String webinar_id, int page, int limit, RequestDataCallbackV2<RecordsData> callBack) {
        limit = limit <= 0 ? 10 : limit;
        page = page < 1 ? 1 : page;
        WebinarInfoRemote.getRecordList(webinar_id, (page - 1) * limit, limit, callBack);
    }

    public static void getFilesList(String webinar_id, MenuListInfoData.MenuItem menu_item, RequestDataCallbackV2<FilesData> callBack) {
        if (webinar_id == null || menu_item == null) {
            return;
        }
        WebinarInfoRemote.getFilesList(webinar_id, menu_item.id, callBack);
    }

    public static void getFileDownLoadUrl(String webinar_id, MenuListInfoData.MenuItem menu_item, String file_id, RequestDataCallbackV2<String> callBack) {
        if (webinar_id == null || menu_item == null || file_id == null) {
            return;
        }
        WebinarInfoRemote.getFileDownLoadUrl(webinar_id, menu_item.id, file_id, callBack);
    }

    public static void getWarmInfo(String webinar_id, RequestDataCallbackV2<WarmInfoData> callBack) {
        WebinarInfoRemote.getWarmInfo(webinar_id, callBack);
    }

    public static void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callBack) {
        actionNetApi.lotteryWinningDetail(room_id, lottery_id, callBack);
    }

    public static void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callBack) {
        actionNetApi.lotteryWinningUserInfo(room_id, callBack);
    }

    public static void sendCode(String type, String data, String scene_id, RequestCallback callBack) {
        sAccountApi.sendCode(type, data, scene_id, callBack);
    }

    public static void noticeWechatSubmit(String webinar_id, String phone, String code, RequestCallback callBack) {
        sAccountApi.wechatSubmit(webinar_id, phone, code, callBack);
    }

    public static void getRoomToolsState(String roomId, RequestDataCallbackV2<RoomToolsStatusData> callBack) {
        WebinarInfoRemote.getRoomToolsState(roomId, callBack);
    }

    private static String getVersionImpl() {
        return String.format("v%s", "6.23.0");
    }

    public static void setPackageCheck(String pkgName, String st) {
        packageName = pkgName;
        signature = st;
    }

    public static void setExData(String app_id, String vhss_url, String h5_url, String vss_url, String yun_url) {
        appId = TextUtils.isEmpty((CharSequence)app_id) ? "15df4d3f" : app_id;
        vhssUrl = TextUtils.isEmpty((CharSequence)vhss_url) ? "https://open-api.vhall.com" : vhss_url;
        mHOST = TextUtils.isEmpty((CharSequence)h5_url) ? "https://e.vhall.com/sdk/v2/" : "https://" + h5_url + "/sdk/v2/";
        vssUrl = vss_url;
        yunUrl = yun_url;
        CoreNetApi.getNet().init(mContext, vhssUrl, "", "5");
    }

    public static void setSurveyUrl(String url, String domain, String newdomain) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            SURVEY_URL = url;
        }
        if (!TextUtils.isEmpty((CharSequence)domain)) {
            DOMAIN = domain;
        }
        if (!TextUtils.isEmpty((CharSequence)newdomain)) {
            NEW_SURVEY_URL = newdomain;
        }
        SURVEY_URL_FORMAT = SURVEY_URL + "?survey_id=%s&user_id=%s&domain=%s&webinar_id=%s&r=%d";
    }

    public static String getSurveyUrl(String survey_id, String webinar_id, String userId) {
        return String.format(SURVEY_URL_FORMAT, survey_id, survey_id, TextUtils.isEmpty((CharSequence)userId) ? VhallSDK.getUserId() : userId, DOMAIN, webinar_id, System.currentTimeMillis());
    }

    static {
        mVersion = VhallSDK.getVersionImpl();
        user = null;
        mPhone = "";
        mNetType = "";
        mIMEI = "";
        header = "";
        SURVEY_URL_FORMAT = SURVEY_URL + "?survey_id=%s&user_id=%s&domain=%s&webinar_id=%s&r=%d";
        third_account_id = "";
        appId = "15df4d3f";
    }

    private static class LoginCallbackInternalImpl
    implements CallBack<VhssUserInfoData> {
        private UserInfoDataSource.UserInfoCallback callback;
        private String userName;

        public LoginCallbackInternalImpl(UserInfoDataSource.UserInfoCallback callback, String userName) {
            this.callback = callback;
            this.userName = userName;
        }

        @Override
        public void onSuccess(VhssUserInfoData result) {
            UserInfo userInfo = UserInfo.getUserInfo(result);
            userInfo.account = this.userName;
            user = userInfo;
            VssSdk.getInstance().setUserInfo(new UserInfoData(userInfo.user_id, userInfo.nick_name, userInfo.avatar, "2", "3", "1", "0", "0", third_account_id));
            VhallSDK.configInfoData();
            LogReporter.getInstance().setUserid(userInfo.user_id);
            LogReporter.getInstance().onCollection("2002", null);
            this.callback.onSuccess(userInfo);
        }

        @Override
        public void onError(int errorCode, String errorMsg) {
            LogReporter.getInstance().setErr(errorMsg);
            LogReporter.getInstance().onCollection("2002", false, null);
            this.callback.onError(errorCode, errorMsg);
        }
    }
}

