/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.hardware.Camera;
import com.vhall.business.Broadcast;
import com.vhall.business.BroadcastFlash;
import com.vhall.business.BroadcastH5;
import com.vhall.business.BroadcastH5new;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.lss_v2.VHV2LiveDef;
import com.vhall.lss_v2.push.IVHV2Pusher;
import com.vhall.player.VHPlayerListener;
import com.vhall.push.VHAudioCapture;
import com.vhall.push.VHLivePushConfig;
import com.vhall.push.VHVideoCaptureView;
import org.json.JSONObject;

abstract class Push {
    public static final int ERROR_PLAYING = 20101;
    public static final int ERROR_NOT_INIT = 20102;
    public static final int ERROR_CONNECTE = 20105;
    public static final int BEAUTY_PERMISSION = 30001;
    protected boolean streamOnly;
    protected WebinarInfo webinarInfo;
    protected VHVideoCaptureView videoCapture;
    protected IVHV2Pusher vhLivePusherV2;
    protected VHAudioCapture mAudioCapture;
    protected VHPlayerListener listener;
    protected ChatServer.Callback chatCallback;
    protected MessageServer.Callback messageCallback;
    protected VHLivePushConfig config;
    protected boolean denoise;
    protected boolean isBuilderV2 = false;
    protected Context mContext;
    protected boolean isMirror = false;
    protected boolean front_camera = true;
    protected String licenseUrl;
    protected String licenseKey;
    protected boolean is_audio_enable = true;
    protected boolean is_video_enable = true;

    Push() {
    }

    public abstract void destroy();

    public abstract void start(RequestCallback var1);

    public void start(boolean rehearsal, RequestCallback callback) {
    }

    public abstract void stop();

    public abstract void sendChat(String var1, RequestCallback var2);

    public abstract void sendCustom(JSONObject var1, RequestCallback var2);

    public abstract void acquireChatRecord(boolean var1, ChatServer.ChatRecordCallback var2);

    public abstract void acquireChatRecord(int var1, int var2, String var3, String var4, String var5, ChatServer.ChatRecordCallback var6);

    public abstract int PushAACDataTs(byte[] var1, int var2, int var3, long var4);

    public abstract int PushH264DataTs(byte[] var1, int var2, int var3, long var4);

    public abstract int setVolumeAmplificateSize(float var1);

    public abstract void connectChatServer();

    public abstract void disconnectChatServer();

    protected abstract void setWebinarInfo(WebinarInfo var1);

    public abstract boolean pushStream(RequestCallback var1);

    public int changeCamera() {
        int id = -1;
        if (Camera.getNumberOfCameras() <= 1) {
            return -1;
        }
        if (this.videoCapture != null) {
            id = this.videoCapture.switchCamera();
        }
        return id;
    }

    public void changeCameraV2(boolean frontCamera) {
        if (this.vhLivePusherV2 != null) {
            this.front_camera = frontCamera;
            this.vhLivePusherV2.switchCamera(this.front_camera);
        }
    }

    public boolean setVideoCapture(boolean enable) {
        this.is_video_enable = enable;
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                if (enable) {
                    this.vhLivePusherV2.stopVirtualCamera();
                    this.vhLivePusherV2.startCamera(this.front_camera);
                    this.setMirror(this.isMirror);
                } else {
                    this.vhLivePusherV2.stopCamera();
                    int largeWidth = this.config.screenOri == 0 ? 640 : 360;
                    int largeHeight = this.config.screenOri == 0 ? 360 : 640;
                    try {
                        Bitmap largeBitmap = Bitmap.createBitmap((int)largeWidth, (int)largeHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(largeBitmap);
                        canvas.drawColor(-16777216);
                        if (largeBitmap != null) {
                            this.vhLivePusherV2.startVirtualCamera(largeBitmap);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (this.videoCapture != null) {
            this.videoCapture.setEnable(enable);
        }
        return this.is_video_enable;
    }

    public void setFrontPreViewMirror(boolean preViewMirror) {
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                this.vhLivePusherV2.setRenderMirror(preViewMirror);
            }
        } else if (this.videoCapture != null) {
            this.videoCapture.setFrontPreViewMirror(preViewMirror);
        }
    }

    public void setCameraDrawMode(int mode) {
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                if (mode == 0) {
                    this.vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fill);
                } else if (mode == 1) {
                    this.vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fit);
                } else if (mode == 2) {
                    this.vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_ScaleFill);
                }
            }
        } else if (this.videoCapture != null) {
            this.videoCapture.setCameraDrawMode(mode);
            LogReportManager.doReport("115008");
        }
    }

    public void setMirror(boolean mirror) {
        if (this.isBuilderV2) {
            this.vhLivePusherV2.setRenderMirror(mirror);
            if (this.front_camera && this.config.screenOri == 0) {
                this.vhLivePusherV2.setRenderRotation(VHV2LiveDef.VHV2LiveRotation.VHV2LiveRotation0);
            } else if (!this.front_camera && this.config.screenOri == 0) {
                this.vhLivePusherV2.setRenderRotation(VHV2LiveDef.VHV2LiveRotation.VHV2LiveRotation0);
            }
        } else if (this.videoCapture != null) {
            this.videoCapture.setMirror(mirror);
        }
    }

    public boolean changeFlash(boolean isOpen) {
        try {
            if (this.isBuilderV2) {
                if (this.vhLivePusherV2 != null) {
                    return this.vhLivePusherV2.enableCameraTorch(isOpen);
                }
            } else if (this.videoCapture != null) {
                return this.videoCapture.changeFlash(isOpen) == isOpen;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !isOpen;
    }

    public boolean isMute() {
        boolean state = false;
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                state = !this.is_audio_enable;
            }
        } else {
            state = !this.mAudioCapture.isEnable();
        }
        return state;
    }

    public boolean setMute(boolean mute) {
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                int i;
                int n = i = mute ? this.vhLivePusherV2.stopMicrophone() : this.vhLivePusherV2.startMicrophone();
                if (i == 0) {
                    this.is_audio_enable = !mute;
                }
            }
            return true;
        }
        return this.mAudioCapture.setEnable(!mute);
    }

    public boolean isAvaliable() {
        return this.webinarInfo != null;
    }

    static class Builder
    extends Broadcast.Builder {
        Builder() {
        }

        public Push buildPush(String type) {
            if (!(this.streamOnly || this.videoCapture != null && this.videoCapture.getActivity() != null)) {
                throw new IllegalArgumentException("init CameraView first...");
            }
            if (this.listener == null) {
                throw new IllegalArgumentException("Broadcast callback should not be null...");
            }
            if (this.config == null) {
                throw new IllegalArgumentException("PushConfig should not be null...");
            }
            if (this.audioCapture == null) {
                this.audioCapture = new VHAudioCapture();
            }
            if ("h5".equals(type)) {
                return new BroadcastH5(this);
            }
            if ("flash".equals(type)) {
                return new BroadcastFlash(this);
            }
            return new BroadcastH5new(this);
        }
    }
}

