/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.view.View;
import android.widget.RelativeLayout;
import com.vhall.business.ChatServer;
import com.vhall.business.Watch;
import com.vhall.business.WatchLive;
import com.vhall.business.WatchLiveFlash;
import com.vhall.business.WatchLiveH5;
import com.vhall.business.WatchLiveH5New;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVRVideoPlayerView;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.util.HashMap;
import org.json.JSONObject;

abstract class Live
extends Watch {
    protected IVHVideoPlayer videoView;
    protected int buffSeconds;
    protected int connectTimeout;
    protected int videoWidth = 0;
    protected int videoHeight = 0;
    protected boolean VR = false;
    protected int VRDrawMode = 0;
    protected boolean VRHeadTracker = false;
    protected String waterMarkUrl = "";
    protected int waterMarkGravity = 0;
    protected float waterMarkAlpha = 0.0f;
    protected RelativeLayout videoContainer;

    Live() {
    }

    public abstract String getDefinition();

    public abstract void setPCSwitchDefinition();

    public abstract void sendChat(String var1, RequestCallback var2);

    public abstract void sendCustom(JSONObject var1, RequestCallback var2);

    public abstract void sendQuestion(String var1, RequestCallback var2);

    public abstract void onRaiseHand(String var1, int var2, RequestCallback var3);

    public abstract void replyInvitation(String var1, int var2, RequestCallback var3);

    public abstract void acquireChatRecord(boolean var1, ChatServer.ChatRecordCallback var2);

    public abstract void acquireChatRecord(int var1, ChatServer.ChatRecordCallback var2);

    public abstract void acquireChatRecord(int var1, int var2, String var3, String var4, String var5, ChatServer.ChatRecordCallback var6);

    public abstract void connectChatServer();

    public abstract void disconnectChatServer();

    public abstract void connectMsgServer();

    public abstract void disconnectMsgServer();

    public HashMap<String, Integer> getDefinitionAvailable() {
        if (this.webinarInfo == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("SD", this.webinarInfo.SD.valid);
        map.put("HD", this.webinarInfo.HD.valid);
        map.put("UHD", this.webinarInfo.UHD.valid);
        map.put("A", this.webinarInfo.A.valid);
        return map;
    }

    public boolean isVR() {
        return this.VR;
    }

    public boolean isVRHeadTracker() {
        return this.VRHeadTracker;
    }

    public void setVRHeadTracker(boolean VRHeadTracker) {
        this.VRHeadTracker = VRHeadTracker;
        if (this.videoView != null && this.videoView instanceof VHVRVideoPlayerView) {
            ((VHVRVideoPlayerView)this.videoView).setIsHeadTracker(VRHeadTracker);
        }
    }

    @Override
    public void setScaleType(final int scaleType) {
        super.setScaleType(scaleType);
        this.mDelivery.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Live.this.videoView != null) {
                    Live.this.videoView.setDrawMode(scaleType);
                }
            }
        }, 10L);
    }

    public String isInteractive() {
        if (this.webinarInfo == null) {
            return "";
        }
        return this.webinarInfo.is_interact;
    }

    public String isAllowHand() {
        if (this.webinarInfo == null) {
            return "";
        }
        return this.webinarInfo.hands_up;
    }

    public boolean isUseDoc() {
        if (this.webinarInfo == null) {
            return true;
        }
        return this.webinarInfo.use_doc == 1;
    }

    public boolean isUseBoard() {
        if (this.webinarInfo == null) {
            return false;
        }
        return this.webinarInfo.use_white_board == 1;
    }

    public void setIsUseBoard(int state) {
        if (this.webinarInfo != null) {
            this.webinarInfo.use_white_board = state;
        }
    }

    public void setIsUseDoc(int state) {
        if (this.webinarInfo != null) {
            this.webinarInfo.use_doc = state;
        }
    }

    public void setVRDrawMode(int vrDrawMode) {
        this.VRDrawMode = vrDrawMode;
        if (this.videoView != null && this.videoView instanceof VHVRVideoPlayerView) {
            this.videoView.setDrawMode(vrDrawMode);
        }
    }

    @Override
    public void initWH(int width, int height) {
        this.videoWidth = width;
        this.videoHeight = height;
        if (this.videoView != null) {
            this.videoView.setDrawMode(this.scaleType);
        } else {
            if (this.VR) {
                this.videoView = new VHVRVideoPlayerView(this.context);
                this.videoView.setDrawMode(this.VRDrawMode);
                ((VHVRVideoPlayerView)this.videoView).setIsHeadTracker(this.VRHeadTracker);
            } else {
                this.videoView = new VHVideoPlayerView(this.context);
                this.videoView.setDrawMode(this.scaleType);
            }
            this.videoContainer.addView((View)((VHVideoPlayerView)this.videoView));
        }
    }

    class Builder
    extends WatchLive.Builder {
        Builder() {
        }

        public Live buildLive(String type) {
            if (this.context == null) {
                throw new IllegalArgumentException("context can not be null");
            }
            if (this.videoContainer == null && this.videoView == null) {
                throw new IllegalArgumentException("containerLayout and playView can not both be null");
            }
            LogReportManager.doReport("115010");
            if ("h5".equals(type)) {
                return new WatchLiveH5(this);
            }
            if ("flash".equals(type)) {
                return new WatchLiveFlash(this);
            }
            return new WatchLiveH5New(this);
        }
    }
}

