/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.business.ChatServer;
import com.vhall.business.H5MessageChange;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.Push;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.logmanager.VLog;
import com.vhall.lss.push.VHLivePusher;
import com.vhall.lss_v2.VHV2LiveDef;
import com.vhall.lss_v2.push.VHV2PusherObserver;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.push.IVHCapture;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.ChatListData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.ChatNetworkRequest;
import java.lang.ref.WeakReference;
import org.json.JSONObject;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;

class BroadcastH5new
extends Push {
    private static final String TAG = "BroadcastH5";
    private VHLivePusher mVhallPushLive;
    private VHV2LiveDef.VHV2LivePushStatus pushStreamState = VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_IDLE;
    private WebinarInfoData roomInfo;
    private int rePushCount = 0;
    private Handler handler;
    private Handler netStateHandler;
    private Runnable runnable;
    private Runnable netStateRunnable;
    private Handler beautyCheckerHandler;
    private Runnable beautyCheckRun;
    private boolean enableBeauty = false;
    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener(){

        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            switch (state) {
                case STATE_CONNECTED: {
                    if (BroadcastH5new.this.chatCallback == null) break;
                    BroadcastH5new.this.chatCallback.onChatServerConnected();
                    break;
                }
                case STATE_CONNECTIONG: {
                    break;
                }
                case STATE_DISCONNECT: {
                    if (BroadcastH5new.this.chatCallback == null) break;
                    BroadcastH5new.this.chatCallback.onChatServerClosed();
                    break;
                }
                case STATE_KICK_OFF: {
                    if (BroadcastH5new.this.chatCallback == null) break;
                    BroadcastH5new.this.chatCallback.onChatServerKickOff();
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            if (BroadcastH5new.this.chatCallback != null) {
                BroadcastH5new.this.chatCallback.onConnectFailed();
            }
        }
    };
    private H5MessageChange iMessageListener = null;

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, "error data");
            }
            return;
        }
        this.webinarInfo = webinarInfo;
        this.roomInfo = webinarInfo.getWebinarInfoData();
        if (this.roomInfo != null) {
            if (this.roomInfo.webinar.is_director != 1) {
                NewH5ImManager.getInstance().enterRoom(this.roomInfo);
                if (this.iMessageListener == null) {
                    this.iMessageListener = new H5MessageChange(this.messageCallback, this.chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack(){

                        @Override
                        public void dataChange(WebinarInfo data) {
                            BroadcastH5new.this.setWebinarInfo(data);
                        }

                        @Override
                        public void kickedOut() {
                        }
                    });
                }
                NewH5ImManager.getInstance().setMessageListener(this.iMessageListener);
                NewH5ImManager.getInstance().setVssCallBackListener(this.iVssCallBackListener);
            }
            this.beautyCheckerHandler = new Handler();
            this.beautyCheckRun = new Runnable(){

                @Override
                public void run() {
                    VLog.i((String)BroadcastH5new.TAG, (String)"time run");
                    if (!BroadcastH5new.this.enableBeauty) {
                        VHBeautifyKit.getInstance().setBeautifyEnable(false);
                    }
                    if (BroadcastH5new.this.beautyCheckerHandler != null) {
                        BroadcastH5new.this.beautyCheckerHandler.removeCallbacks(BroadcastH5new.this.beautyCheckRun);
                        BroadcastH5new.this.beautyCheckerHandler.postDelayed(BroadcastH5new.this.beautyCheckRun, 3000L);
                    }
                }
            };
            ActivityNetworkRequest.getConfigList(webinarInfo.webinar_id, webinarInfo.user_id, new CallBack<String>(){

                @Override
                public void onSuccess(String result) {
                    if (result != null) {
                        try {
                            JSONObject permissions;
                            JSONObject jsonObject = new JSONObject(result);
                            String data = jsonObject.optString("data");
                            JSONObject dataObject = new JSONObject(data);
                            if (!TextUtils.isEmpty((CharSequence)dataObject.optString("permissions")) && (permissions = new JSONObject(dataObject.optString("permissions"))).has("saas_sdk_beauty_config")) {
                                int saas_sdk_beauty_config = Integer.parseInt(permissions.optString("saas_sdk_beauty_config"));
                                if (saas_sdk_beauty_config == 1) {
                                    BroadcastH5new.this.enableBeauty = true;
                                    VHBeautifyKit.getInstance().setBeautifyEnable(true);
                                } else {
                                    BroadcastH5new.this.enableBeauty = false;
                                    VHBeautifyKit.getInstance().setBeautifyEnable(false);
                                    if (BroadcastH5new.this.listener != null) {
                                        BroadcastH5new.this.listener.onError(30001, 0, VhallSDK.mContext.getString(R.string.beauty_permission));
                                    }
                                }
                                if (BroadcastH5new.this.beautyCheckerHandler != null) {
                                    BroadcastH5new.this.beautyCheckerHandler.removeCallbacks(BroadcastH5new.this.beautyCheckRun);
                                    BroadcastH5new.this.beautyCheckerHandler.postDelayed(BroadcastH5new.this.beautyCheckRun, 3000L);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                }
            });
            if (this.isBuilderV2) {
                this.initLivePusherV2();
                this.handler = new Handler();
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        VLog.i((String)BroadcastH5new.TAG, (String)"time run");
                        if (BroadcastH5new.this.vhLivePusherV2 != null) {
                            BroadcastH5new.this.rePushCount++;
                            BroadcastH5new.this.vhLivePusherV2.startPush(((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.room_id, ((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.paas_access_token);
                        }
                    }
                };
                this.netStateHandler = new Handler();
                this.netStateRunnable = new Runnable(){

                    @Override
                    public void run() {
                        VLog.i((String)BroadcastH5new.TAG, (String)"time run");
                        if (BroadcastH5new.this.vhLivePusherV2 != null && BroadcastH5new.this.listener != null) {
                            BroadcastH5new.this.listener.onEvent(6, VhallSDK.mContext.getString(R.string.push_stream_network_ok));
                        }
                    }
                };
            } else if (this.mVhallPushLive != null) {
                this.mVhallPushLive.setLogReportRoomId(this.roomInfo.getInteract().getInav_id());
            }
        } else if (this.listener != null) {
            this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
        }
    }

    public BroadcastH5new(Push.Builder builder) {
        this.isBuilderV2 = builder.isBuilderV2;
        if (this.isBuilderV2) {
            this.licenseKey = builder.licenseKey;
            this.licenseUrl = builder.licenseUrl;
            this.streamOnly = builder.streamOnly;
            this.chatCallback = builder.chatCallback;
            this.messageCallback = builder.messageCallback;
            this.mContext = builder.mContext;
            this.videoCapture = builder.videoCapture;
            this.config = builder.config;
            this.listener = builder.listener;
            this.vhLivePusherV2 = builder.vhInteractiveV2;
        } else {
            this.mVhallPushLive = new VHLivePusher((IVHCapture)builder.videoCapture, (IVHCapture)builder.audioCapture, builder.config);
            this.streamOnly = builder.streamOnly;
            this.chatCallback = builder.chatCallback;
            this.messageCallback = builder.messageCallback;
            if (!this.streamOnly) {
                this.videoCapture = builder.videoCapture;
                this.mAudioCapture = builder.audioCapture;
                this.listener = builder.listener;
                this.mVhallPushLive.openNoiseCancelling(builder.denoise);
                this.mVhallPushLive.setListener(this.listener);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.mVhallPushLive != null && this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.release();
        }
        if (this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
        }
        if (this.netStateHandler != null) {
            this.netStateHandler.removeCallbacks(this.runnable);
        }
        if (this.beautyCheckerHandler != null) {
            this.beautyCheckerHandler.removeCallbacks(this.beautyCheckRun);
        }
        NewH5ImManager.getInstance().removeMessageListener(this.iMessageListener);
        NewH5ImManager.getInstance().leaveRoom();
    }

    @Override
    public void start(RequestCallback callback) {
        this.start(false, callback);
    }

    @Override
    public void start(boolean rehearsal, RequestCallback callback) {
        if (this.roomInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.isBuilderV2) {
            this.onStartV2(rehearsal, callback);
        } else {
            if (this.mVhallPushLive.getState() == Constants.State.START) {
                return;
            }
            this.onStart(rehearsal, callback);
        }
    }

    private void initLivePusherV2() {
        this.vhLivePusherV2.init(this.webinarInfo.webinar_show_type == 1 ? VHV2LiveDef.VHV2LiveVideoResolutionMode.VHV2LiveVideoResolutionMode_Portrait : VHV2LiveDef.VHV2LiveVideoResolutionMode.VHV2LiveVideoResolutionMode_Landscape);
        VhallBaseSDK.getInstance().initLssV2(this.roomInfo.interact.paas_access_token, new VhallBaseSDK.InitCallback(){

            public void onSuccess() {
                if (BroadcastH5new.this.vhLivePusherV2 != null) {
                    String url = VhallBaseSDK.getInstance().getLicenseUrl();
                    String key = VhallBaseSDK.getInstance().getLicenseKey();
                    if (!TextUtils.isEmpty((CharSequence)BroadcastH5new.this.licenseKey) && !TextUtils.isEmpty((CharSequence)BroadcastH5new.this.licenseUrl)) {
                        BroadcastH5new.this.vhLivePusherV2.authentication(BroadcastH5new.this.licenseUrl, BroadcastH5new.this.licenseKey);
                    } else {
                        BroadcastH5new.this.vhLivePusherV2.authentication(url, key);
                    }
                }
            }

            public void onFailure(String s) {
                if (BroadcastH5new.this.listener != null) {
                    BroadcastH5new.this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_init_license_key));
                }
            }
        });
        this.vhLivePusherV2.setObserver(new VHV2PusherObserver(){

            public void onError(int code, String msg) {
                String res = String.valueOf(code) + " " + msg;
                VLog.e((String)BroadcastH5new.TAG, (String)res);
                if ((-12 == code || -4 == code || -5 == code) && BroadcastH5new.this.listener != null) {
                    BroadcastH5new.this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_init_license_key));
                }
            }

            public void onWarning(int code, String msg) {
                String res = String.valueOf(code) + " " + msg;
                VLog.i((String)BroadcastH5new.TAG, (String)res);
                if (code == 1101 && BroadcastH5new.this.listener != null) {
                    BroadcastH5new.this.listener.onEvent(5, VhallSDK.mContext.getString(R.string.push_stream_network_bad));
                    if (BroadcastH5new.this.netStateHandler != null) {
                        BroadcastH5new.this.netStateHandler.removeCallbacks(BroadcastH5new.this.runnable);
                        BroadcastH5new.this.netStateHandler.postDelayed(BroadcastH5new.this.runnable, 3000L);
                    }
                }
            }

            public void onCaptureFirstAudioFrame() {
            }

            public void onCaptureFirstVideoFrame() {
            }

            public void onMicrophoneVolumeUpdate(int volume) {
            }

            public void onPushStatusUpdate(VHV2LiveDef.VHV2LivePushStatus status, String msg) {
                String res = String.valueOf(status) + " " + msg;
                VLog.i((String)BroadcastH5new.TAG, (String)res);
                BroadcastH5new.this.pushStreamState = status;
                switch (status) {
                    case VHV2LivePushStatus_ConnectSuccess: 
                    case VHV2LivePushStatus_RESUME: {
                        if (BroadcastH5new.this.listener == null) break;
                        BroadcastH5new.this.listener.onStateChanged(Constants.State.START);
                        break;
                    }
                    case VHV2LivePushStatus_Connecting: {
                        break;
                    }
                    case VHV2LivePushStatus_Disconnected: 
                    case VHV2LivePushStatus_ConnectError: {
                        if (BroadcastH5new.this.rePushCount < BroadcastH5new.this.config.pushReconnectTimes) {
                            if (BroadcastH5new.this.handler == null) break;
                            BroadcastH5new.this.handler.removeCallbacks(BroadcastH5new.this.runnable);
                            BroadcastH5new.this.handler.postDelayed(BroadcastH5new.this.runnable, 1000L);
                            if (BroadcastH5new.this.listener == null) break;
                            BroadcastH5new.this.listener.onError(20212, 0, VhallSDK.mContext.getString(R.string.error_push_reconnecting));
                            break;
                        }
                        BroadcastH5new.this.rePushCount = 0;
                        if (BroadcastH5new.this.listener == null) break;
                        BroadcastH5new.this.listener.onError(20213, 0, VhallSDK.mContext.getString(R.string.error_push_disconnect));
                        break;
                    }
                    case VHV2LivePushStatus_Reconnecting: {
                        if (BroadcastH5new.this.listener == null) break;
                        BroadcastH5new.this.listener.onError(20212, 0, VhallSDK.mContext.getString(R.string.error_push_reconnecting));
                        break;
                    }
                }
            }

            public void onStatisticsUpdate(VHV2LiveDef.VHV2LivePusherStatistics statistics) {
                if (BroadcastH5new.this.listener != null) {
                    BroadcastH5new.this.listener.onEvent(4, String.valueOf(statistics.videoBitrate));
                }
            }

            public void onGLContextCreated() {
                VhallBaseSDK.getInstance().initBeautify(((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.paas_access_token, new IVHBeautifyInitListener(){

                    public void onSuccess() {
                    }

                    public void onError(int i, String s) {
                    }
                });
                VHBeautifyKit.getInstance().loadFaceProcessor();
                if (null != BroadcastH5new.this.mContext) {
                    VHBeautifyKit.getInstance().judgeDeviceLevel(new WeakReference<Context>(BroadcastH5new.this.mContext));
                }
                if (BroadcastH5new.this.webinarInfo.webinar_show_type == 1) {
                    VHBeautifyKit.getInstance().setActivityOrientation(1);
                } else {
                    VHBeautifyKit.getInstance().setActivityOrientation(0);
                }
            }

            public void onGLContextDestroyed() {
                VHBeautifyKit.getInstance().release();
            }
        });
        this.vhLivePusherV2.setRenderView((SurfaceView)this.videoCapture);
        if (this.config.screenOri == 0) {
            this.vhLivePusherV2.setVideoQuality(this.config.getVideoWidth(), this.config.getVideoHeight(), this.config.videoFrameRate, this.config.videoBitrate / 1000, this.config.videoBitrate / 1000);
        } else {
            this.vhLivePusherV2.setVideoQuality(this.config.getVideoHeight(), this.config.getVideoWidth(), this.config.videoFrameRate, this.config.videoBitrate / 1000, this.config.videoBitrate / 1000);
        }
        this.vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fill);
        this.vhLivePusherV2.startCamera(true);
        this.setMirror(false);
        this.vhLivePusherV2.startMicrophone();
        this.is_audio_enable = true;
    }

    @Override
    public boolean pushStream(RequestCallback callback) {
        if (this.isBuilderV2) {
            this.rePushCount = 0;
            int ret = this.vhLivePusherV2.startPush(this.roomInfo.interact.room_id, this.roomInfo.interact.paas_access_token);
            if (ret == 0) {
                if (callback != null) {
                    callback.onSuccess();
                }
                return true;
            }
        } else {
            this.mVhallPushLive.start(this.roomInfo.interact.room_id, this.roomInfo.interact.paas_access_token);
            if (callback != null) {
                callback.onSuccess();
            }
        }
        return false;
    }

    private int setCamera() {
        this.vhLivePusherV2.startCamera(this.front_camera);
        this.setMirror(this.isMirror);
        return 0;
    }

    private void onStartV2(boolean rehearsal, final RequestCallback callback) {
        if (this.roomInfo.webinar.is_director != 1) {
            ActivityNetworkRequest.liveStart(this.webinarInfo.webinar_id, "", "3", rehearsal ? "2" : "0", new CallBack(){

                public void onSuccess(Object result) {
                    if (BroadcastH5new.this.vhLivePusherV2 != null) {
                        if (BroadcastH5new.this.pushStreamState == VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_ConnectSuccess) {
                            BroadcastH5new.this.vhLivePusherV2.pausePush();
                        } else if (BroadcastH5new.this.pushStreamState == VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_PAUSE) {
                            BroadcastH5new.this.vhLivePusherV2.resumePush();
                        } else {
                            int ret = BroadcastH5new.this.vhLivePusherV2.startPush(((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.room_id, ((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.paas_access_token);
                            if (ret == -5) {
                                if (callback != null) {
                                    callback.onError(20102, VhallSDK.mContext.getString(R.string.error_init_license_key));
                                }
                                return;
                            }
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        }
    }

    private void onStart(boolean rehearsal, final RequestCallback callback) {
        if (this.mVhallPushLive == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.roomInfo.webinar.is_director != 1) {
            ActivityNetworkRequest.liveStart(this.webinarInfo.webinar_id, "", "3", rehearsal ? "2" : "0", new CallBack(){

                public void onSuccess(Object result) {
                    BroadcastH5new.this.mVhallPushLive.start(((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.room_id, ((BroadcastH5new)BroadcastH5new.this).roomInfo.interact.paas_access_token);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        } else {
            this.mVhallPushLive.start(this.roomInfo.interact.room_id, this.roomInfo.interact.paas_access_token);
        }
    }

    @Override
    public void stop() {
        if (this.isBuilderV2) {
            if (this.vhLivePusherV2 != null) {
                this.vhLivePusherV2.stopPush();
                if (this.listener != null) {
                    this.listener.onStateChanged(Constants.State.STOP);
                }
            }
        } else if (this.mVhallPushLive != null && this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.stop();
        }
    }

    @Override
    public void sendChat(String content, final RequestCallback callback) {
        if (this.roomInfo.webinar.is_director != 1) {
            NewH5ImManager.getInstance().sendMsg(content, "", new CallBack(){

                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        }
    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        ChatNetworkRequest.sendCustomMessage(this.roomInfo.interact.room_id, this.roomInfo.interact.channel_id, content.toString(), new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void connectChatServer() {
    }

    @Override
    public void disconnectChatServer() {
    }

    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        ChatNetworkRequest.chatGetList(this.roomInfo.interact.room_id, 1, show_all ? 100 : 20, new CallBack<ChatListData>(){

            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, final ChatServer.ChatRecordCallback chatRecordCallback) {
        if (limit > 100) {
            limit = 100;
        }
        if (limit < 1) {
            limit = 1;
        }
        ChatNetworkRequest.chatGetList(this.roomInfo.interact.room_id, page, limit, msgId, anchor_path, is_role, new CallBack<ChatListData>(){

            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }
}

