/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import com.vhall.business.ChatServer;
import com.vhall.business.H5MessageChange;
import com.vhall.business.Push;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.lss.push.VHLivePusher;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.push.IVHCapture;
import java.util.List;
import org.json.JSONObject;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;

class BroadcastH5
extends Push {
    private static final String TAG = "BroadcastH5";
    private VHLivePusher mVhallPushLive;
    private ResponseRoomInfo roomInfo;
    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener(){

        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            switch (state) {
                case STATE_CONNECTED: {
                    if (BroadcastH5.this.chatCallback == null) break;
                    BroadcastH5.this.chatCallback.onChatServerConnected();
                    break;
                }
                case STATE_CONNECTIONG: {
                    break;
                }
                case STATE_DISCONNECT: {
                    if (BroadcastH5.this.chatCallback == null) break;
                    BroadcastH5.this.chatCallback.onChatServerClosed();
                    break;
                }
                case STATE_KICK_OFF: {
                    if (BroadcastH5.this.chatCallback == null) break;
                    BroadcastH5.this.chatCallback.onChatServerKickOff();
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            if (BroadcastH5.this.chatCallback != null) {
                BroadcastH5.this.chatCallback.onConnectFailed();
            }
        }
    };

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, "error data");
            }
            return;
        }
        this.webinarInfo = webinarInfo;
        if (this.roomInfo == null) {
            if (VssRoomManager.enter) {
                this.roomInfo = VssRoomManager.getInstance().getRoomInfo();
                if (this.mVhallPushLive != null) {
                    this.mVhallPushLive.setLogReportRoomId(this.roomInfo.getInav_id());
                }
                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(this.messageCallback, this.chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack(){

                    @Override
                    public void dataChange(WebinarInfo data) {
                        BroadcastH5.this.setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {
                    }
                }));
                VssRoomManager.getInstance().setVssCallBackListener(this.iVssCallBackListener);
            } else if (this.listener != null) {
                this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
        }
    }

    public BroadcastH5(Push.Builder builder) {
        this.mVhallPushLive = new VHLivePusher((IVHCapture)builder.videoCapture, (IVHCapture)builder.audioCapture, builder.config);
        this.streamOnly = builder.streamOnly;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        if (!this.streamOnly) {
            this.videoCapture = builder.videoCapture;
            this.mAudioCapture = builder.audioCapture;
            this.listener = builder.listener;
            this.mVhallPushLive.openNoiseCancelling(builder.denoise);
            this.mVhallPushLive.setListener(this.listener);
        }
    }

    @Override
    public void destroy() {
        if (this.mVhallPushLive != null && this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.release();
        }
        VssRoomManager.leaveRoom();
    }

    @Override
    public void start(RequestCallback callback) {
        if (this.mVhallPushLive.getState() == Constants.State.START) {
            return;
        }
        if (this.roomInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        this.onStart(callback);
    }

    private void onStart(final RequestCallback callback) {
        if (this.mVhallPushLive == null) {
            if (this.listener != null) {
                this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
            return;
        }
        VssRoomManager.getInstance().roomStartLive(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                BroadcastH5.this.mVhallPushLive.start(BroadcastH5.this.webinarInfo.vss_room_id, BroadcastH5.this.roomInfo.getPaas_access_token());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public boolean pushStream(RequestCallback callback) {
        this.mVhallPushLive.start(this.webinarInfo.vss_room_id, this.roomInfo.getPaas_access_token());
        if (callback != null) {
            callback.onSuccess();
        }
        return true;
    }

    @Override
    public void stop() {
        if (this.mVhallPushLive == null) {
            return;
        }
        if (this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.stop();
        }
    }

    @Override
    public void sendChat(String content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content, "", new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content.toString(), "service_custom", new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void connectChatServer() {
    }

    @Override
    public void disconnectChatServer() {
    }

    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists("1", show_all ? "200" : "20", "", new CallBack<List<ResponseChatInfo>>(){

            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }
}

