/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.Push;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.utils.LogManager;
import com.vhall.player.Constants;
import com.vhall.push.IVHCapture;
import com.vhall.push.LivePusher;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BroadcastFlash
extends Push {
    private static final String TAG = "BroadcastFlash";
    private int RECONNECT;
    private ChatServer chatServer;
    private MessageServer messageServer;
    private LivePusher mVhallPushLive;
    private DispatchParam dispatchParam;
    private int currentTimes;

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
        if (this.chatServer != null) {
            this.chatServer.setWebinarInfo(webinarInfo);
        }
        if (this.messageServer != null) {
            this.messageServer.setWebinarInfo(webinarInfo);
        }
    }

    public BroadcastFlash(Push.Builder builder) {
        this.currentTimes = this.RECONNECT = 1;
        this.mVhallPushLive = new LivePusher((IVHCapture)builder.videoCapture, (IVHCapture)builder.audioCapture, builder.config);
        this.streamOnly = builder.streamOnly;
        if (!this.streamOnly) {
            this.videoCapture = builder.videoCapture;
            this.mAudioCapture = builder.audioCapture;
            this.mVhallPushLive.openNoiseCancelling(builder.denoise);
            if (builder.config.pushReconnectTimes > 0) {
                this.RECONNECT = builder.config.pushReconnectTimes;
            }
            this.listener = builder.listener;
            this.mVhallPushLive.setListener(this.listener);
            this.chatServer = new ChatServer();
            this.chatServer.setCallback(builder.chatCallback);
            this.messageServer = new MessageServer();
            this.messageServer.setCallback(new MessageServer.Callback(){

                @Override
                public void onEvent(MessageServer.MsgInfo messageInfo) {
                }

                @Override
                public void onMsgServerConnected() {
                }

                @Override
                public void onConnectFailed() {
                }

                @Override
                public void onMsgServerClosed() {
                }
            });
        }
    }

    @Override
    public void destroy() {
        if (this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.release();
        }
        this.chatServer.disconnect();
    }

    @Override
    public void start(RequestCallback callback) {
        if (this.mVhallPushLive.getState() == Constants.State.START) {
            this.listener.onError(20101, 0, VhallSDK.mContext.getString(R.string.living));
            return;
        }
        this.refreshPublishURL();
        if (callback != null) {
            callback.onSuccess();
        }
    }

    @Override
    public void stop() {
        if (this.mVhallPushLive.getState() == Constants.State.START) {
            this.mVhallPushLive.stop();
        }
    }

    @Override
    public void sendChat(String content, RequestCallback callback) {
        if (this.chatServer != null) {
            this.chatServer.sendChat(content, callback);
        }
    }

    @Override
    public void sendCustom(JSONObject content, RequestCallback callback) {
        if (this.chatServer != null) {
            this.chatServer.sendCustom(content, callback);
        }
    }

    @Override
    public void connectChatServer() {
        if (this.chatServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.chatServer.connect();
    }

    @Override
    public void disconnectChatServer() {
        if (this.chatServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.chatServer.disconnect();
    }

    @Override
    public boolean pushStream(RequestCallback callback) {
        this.refreshPublishURL();
        if (callback != null) {
            callback.onSuccess();
        }
        return true;
    }

    @Override
    public void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback) {
        this.chatServer.acquireChatRecord(show_all, chatRecordCallback);
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }

    private void refreshPublishURL() {
        if (TextUtils.isEmpty((CharSequence)this.webinarInfo.dispatch_host)) {
            this.publish();
            return;
        }
        if (!this.webinarInfo.dispatch_host.endsWith("/")) {
            this.webinarInfo.dispatch_host = this.webinarInfo.dispatch_host + "/";
        }
        String url = this.webinarInfo.dispatch_host + "api/dispatch_publish?webinar_id=" + this.webinarInfo.webinar_id + "&stream_name=" + this.webinarInfo.webinar_id + "&webinar_type=1&accesstoken=vhall&client_type=3&appkey=" + VhallSDK.APP_KEY + "&bu=0";
        LogManager.innerLog(TAG, url);
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.getPublishURL(url, new WebinarInfoDataSource.LoadWebinarInfoCallback(){

            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (BroadcastFlash.this.mVhallPushLive.getState() == Constants.State.START) {
                    return;
                }
                try {
                    JSONObject obj = new JSONObject(jsonStr);
                    String msg = obj.optString("msg");
                    int code = obj.optInt("code");
                    if (code == 200) {
                        JSONObject args;
                        BroadcastFlash.this.dispatchParam = new DispatchParam();
                        JSONObject dataResult = obj.optJSONObject("data");
                        JSONArray urllist = dataResult.optJSONArray("publish_domainname");
                        if (urllist != null && urllist.length() > 0) {
                            ArrayList<String> urls = new ArrayList<String>();
                            for (int i = 0; i < urllist.length(); ++i) {
                                urls.add(urllist.optString(i));
                            }
                            ((BroadcastFlash)BroadcastFlash.this).dispatchParam.urls = urls;
                        }
                        if ((args = dataResult.optJSONObject("publish_args")) != null) {
                            ((BroadcastFlash)BroadcastFlash.this).dispatchParam.accesstoken = args.optString("accesstoken");
                            ((BroadcastFlash)BroadcastFlash.this).dispatchParam.token = args.optString("token");
                            ((BroadcastFlash)BroadcastFlash.this).dispatchParam.mixer = args.optString("mixer");
                            ((BroadcastFlash)BroadcastFlash.this).dispatchParam.vhost = args.optString("vhost");
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                BroadcastFlash.this.publish();
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                BroadcastFlash.this.publish();
            }
        });
    }

    private void publish() {
        if (this.mVhallPushLive != null && this.mVhallPushLive.getState() == Constants.State.START) {
            return;
        }
        String publicURL = "";
        publicURL = this.dispatchParam == null || this.dispatchParam.urls == null || this.dispatchParam.urls.size() <= 0 ? this.webinarInfo.media_srv + "?token=" + this.webinarInfo.streamtoken + "/" + this.webinarInfo.webinar_id : this.dispatchParam.urls.get(0) + "?vhost=" + this.dispatchParam.vhost + "?token=" + this.dispatchParam.token + "?webinar_id=" + this.webinarInfo.webinar_id + "?ismix=0?mixserver=" + this.dispatchParam.mixer + "?accesstoken=" + this.dispatchParam.accesstoken + "/" + this.webinarInfo.webinar_id + this.webinarInfo.user_id;
        LogManager.innerLog(TAG, publicURL);
        this.mVhallPushLive.setLogParam(this.getDataCollectionStr());
        this.mVhallPushLive.start(publicURL);
    }

    private String getDataCollectionStr() {
        String dataCollection = "";
        if (this.webinarInfo != null && this.webinarInfo.data_report != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("topic", (Object)this.webinarInfo.data_report.topic);
                jsonObject.put("sessionId", (Object)this.webinarInfo.session_id);
                jsonObject.put("bu", (Object)"0");
                jsonObject.put("guid", (Object)this.webinarInfo.data_report.guid);
                jsonObject.put("pf", 5);
                jsonObject.put("uid", (Object)this.webinarInfo.join_id);
                jsonObject.put("vfid", (Object)this.webinarInfo.data_report.vfid);
                jsonObject.put("vid", (Object)this.webinarInfo.data_report.vid);
                jsonObject.put("vtype", (Object)this.webinarInfo.data_report.vtype);
                jsonObject.put("aid", (Object)this.webinarInfo.webinar_id);
                jsonObject.put("app_id", (Object)VhallSDK.APP_KEY);
                jsonObject.put("host", (Object)this.webinarInfo.data_report.host);
                if (this.videoCapture != null) {
                    jsonObject.put("ndi", (Object)VhallSDK.getmIMEI());
                }
                dataCollection = jsonObject.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        LogManager.d(TAG, "dataCollection:" + dataCollection);
        return dataCollection;
    }

    private class DispatchParam {
        List<String> urls;
        String token = "";
        String mixer = "";
        String accesstoken = "";
        String vhost = "";

        private DispatchParam() {
        }
    }
}

