package vhall.com.vss2.utils.rxutils;

import android.text.TextUtils;
import android.util.Log;

import com.vhall.logmanager.VLog;

import java.util.HashMap;

import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;

/**
 * @author hkl
 * Date: 2019-06-25 13:49
 */
public class BasePresenter {
    protected static String vssToken = null;
    protected static String roomId = null;
    protected static ResponseRoomInfo roomInfo = new ResponseRoomInfo();

    public String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        return String.format("%s%s%s", VssApiConstant.API_HOST, VssApiConstant.API_AREA, api);
    }

    public HashMap<String, String> getDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, String> param = new HashMap<>(size + 3);
        if (!TextUtils.isEmpty(vssToken)) {
            param.put(VssApiConstant.KEY_VSS_TOKEN, vssToken);
        }
        if (!TextUtils.isEmpty(roomId)) {
            param.put(VssApiConstant.KEY_ROOM_ID, roomId);
        }
        param.put(VssApiConstant.KEY_APP_ID, VssSdk.getInstance().getAppId());
        param.put("from", "android_app");
        param.put("client_version",  VssSdk.getInstance().getClient_version());
        return param;
    }

    public HashMap<String, Object> getObjectDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, Object> param = new HashMap<>(size);
        if (!TextUtils.isEmpty(vssToken)) {
            param.put(VssApiConstant.KEY_VSS_TOKEN, vssToken);
        }
        if (!TextUtils.isEmpty(roomId)) {
            param.put(VssApiConstant.KEY_ROOM_ID, roomId);
        }
        return param;
    }

    public void dealError(Throwable e, CallBack callback, String tag) {
        if (callback == null) {
            return;
        }
        String msg;
        if (e instanceof ApiException) {
            ApiException exception = CustomException.handleException(-1, e);
            if (TextUtils.isEmpty(exception.getDisplayMessage())) {
                callback.onError(exception.getCode(), exception.getMessage());
                msg = exception.getMessage();
            } else {
                callback.onError(exception.getCode(), exception.getDisplayMessage());
                msg = exception.getDisplayMessage();
            }
        } else {
            callback.onError(-1, e.getMessage());
            msg = e.getMessage();
        }
        VLog.e(tag, msg);
    }
}
