package vhall.com.vss2.module.sign;

import android.util.Log;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.logmanager.VLog;

import java.util.HashMap;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.ResponseSignList;
import vhall.com.vss2.data.ResponseSignListUser;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-07-02 14:05
 */
public class VssSignManager extends BasePresenter {
    private volatile static VssSignManager instance;
    private static String TAG = "VssSignManager";

    public static VssSignManager getInstance() {
        if (roomInfo == null) {
            VLog.e(TAG, "room data error");
        }
        if (instance == null) {
            synchronized (VssSignManager.class) {
                if (instance == null) {
                    instance = new VssSignManager();
                }
            }
        }
        return instance;
    }

    /**
     * 签到 发起签到
     */
    public void signAdd(String show_time, CallBack callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_SHOW_TIME, show_time);
        //构造参数
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SIGN_ADD)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback));
    }

    /**
     * 签到 用户签到
     */
    public void signIn(String signId, CallBack callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_SIGN_ID, signId);

        //构造参数
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SIGN_IN)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback));
    }

    public void signGets(CallBack callback) {
        signGets("asc", "500", "0", callback);
    }

    /**
     * 签到 获取发起的签到列表
     * sort_type asc 正序
     * desc 倒序
     */
    public void signGets(String sort_type, String limit, String offset, CallBack callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        if (sort_type != null) {
            params.put("sort_type", sort_type);
        }
        if (offset != null) {
            params.put("offset", offset);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        //构造参数
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SIGN_GETS)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback, ResponseSignList.class));
    }

    public void signRecordsGet(String signId, CallBack callback) {
        signRecordsGet("asc", "500", "0", signId, callback);
    }


    /**
     * 签到 获取签到记录列表
     */
    public void signRecordsGet(String sort_type, String limit, String offset, String signId, CallBack callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 6);
        params.put("sort_type", sort_type);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put(VssApiConstant.KEY_SIGN_ID, signId);
        //构造参数
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SIGN_RECORDS_GET)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback, ResponseSignListUser.class));
    }

}
