package vhall.com.vss2.module.room;

/**
 * @author hkl
 * Date: 2019-07-04 14:15
 */
public class MessageTypeData {

    /**
     * 聊天消息
     */
    public static final String MESSAGE_SERVICE_IM = "service_im";

    public static final String MESSAGE_SERVICE_IM_IMAGE = "image";
    public static final String MESSAGE_SERVICE_IM_TEXT = "text";


    /**
     * 聊天消息 禁言单个用户
     */
    public static final String MESSAGE_SERVICE_IM_DISABLE = "disable";
    /**
     * 聊天消息 全员禁言
     */
    public static final String MESSAGE_SERVICE_IM_DISABLE_ALL = "disable_all";
    /**
     * 聊天消息 取消禁言某个用户
     */
    public static final String MESSAGE_SERVICE_IM_PERMIT = "permit";
    /**
     * 聊天消息 取消全员禁
     */
    public static final String MESSAGE_SERVICE_IM_PERMIT_ALL = "permit_all";


    /**
     * 在线消息
     */
    public static final String MESSAGE_SERVICE_ONLINE = "service_online";
    /**
     * 在线消息 上线
     */
    public static final String MESSAGE_SERVICE_ONLINE_JOIN = "Join";
    /**
     * 在线消息 离线
     */
    public static final String MESSAGE_SERVICE_ONLINE_LEAVE = "Leave";


    /**
     * 房间消息
     */
    public static final String MESSAGE_SERVICE_ROOM = "service_room";
    /**
     * 自定义消息
     */
    public static final String MESSAGE_SERVICE_CUSTOM = "service_custom";
    /**
     * 文档消息
     */
    public static final String MESSAGE_SERVICE_DOCUMENT = "service_document";

    /**
     * 房间消息 直播（live） 发起端开始推流 直播开始
     */
    public static final String MESSAGE_LIVE_START = "live_start";
    /**
     * 房间消息 直播（live） 发起端停止推流 直播结束
     */
    public static final String MESSAGE_LIVE_OVER = "live_over";
    /**
     * 房间消息 直播（live） 清晰度转换完成
     */
    public static final String MESSAGE_LIVE_CONVERTED = "live_converted";

    /**
     * 房间消息 房间（room） 被踢出房间
     */
    public static final String MESSAGE_ROOM_KICKOUT = "room_kickout";
    /**
     * 房间消息 房间（room） 取消踢出房间
     */
    public static final String MESSAGE_ROOM_KICKOUT_CANCEL = "room_kickout_cancel";
    /**
     * 房间消息 房间（room） 房间内发布公告
     */
    public static final String MESSAGE_ROOM_ANNOUNCEMENT = "room_announcement";
    /**
     * 房间消息 房间（room） 嘉宾消息
     */
    public static final String MESSAGE_ROOM_GUEST = "room_guest";
    /**
     * 房间消息 房间（room） 房间切换主讲人
     */
    public static final String MESSAGE_ROOM_SPEAKER_SWITCH = "room_speaker_switch";
    /**
     * 房间消息 房间（room） 房间并发超载
     */
    public static final String MESSAGE_ROOM_OVERLOAD = "room_overload";
    /**
     * 房间消息 房间（room） 房间并发超载通知
     */
    public static final String MESSAGE_ROOM_OVERLOAD_NOTICE = "room_overload_notice";

    /**
     * 房间 互动消息 互动连麦连接检查成功通知
     */
    public static final String MESSAGE_VRTC_CONNECT_CHECK_SUCCESS = "vrtc_connect_check_success";
    /**
     * 房间 互动消息 互动连麦连接检查失败通知
     */
    public static final String MESSAGE_VRTC_CONNECT_CHECK_FAILURE = "vrtc_connect_check_failure";
    /**
     * 房间 互动消息 互动连麦终端环境检查
     */
    public static final String MESSAGE_VRTC_CONNECT_DEVICE_CHECK = "vrtc_connect_device_check";
    /**
     * 房间 互动消息 互动连麦终端环境检查错误通知
     */
    public static final String MESSAGE_VRTC_CONNECT_DEVICE_ERROR = "vrtc_connect_device_error";
    /**
     * 房间 互动消息 互动房间关闭
     */
    public static final String MESSAGE_VRTC_ROOM_CLOSE = "vrtc_room_close";
    /**
     * 房间 互动消息 互动连麦条件检查
     */
    public static final String MESSAGE_VRTC_CONNECT_CHECK = "vrtc_connect_check";

    /**
     * 房间 互动消息 互动连麦断开连接成功（观看端只能收到自己的 发起端收得到全部的）
     */
    public static final String MESSAGE_VRTC_DISCONNECT_SUCCESS = "vrtc_disconnect_success";
    /**
     * 房间 互动消息 开启互动连麦功能
     */
    public static final String MESSAGE_VRTC_CONNECT_OPEN = "vrtc_connect_open";
    /**
     * 房间 互动消息 关闭互动连麦功能
     */
    public static final String MESSAGE_VRTC_CONNECT_CLOSE = "vrtc_connect_close";
    /**
     * 房间 互动消息 互动连麦连接邀请
     */
    public static final String MESSAGE_VRTC_CONNECT_INVITE = "vrtc_connect_invite";
    /**
     * 房间 互动消息 互动连麦连接同意
     */
    public static final String MESSAGE_VRTC_CONNECT_AGREE = "vrtc_connect_agree";
    /**
     * 房间 互动消息 互动连麦连接拒绝
     */
    public static final String MESSAGE_VRTC_CONNECT_REFUSED = "vrtc_connect_refused";
    /**
     * 房间 互动消息 互动连麦连接失败
     */
    public static final String MESSAGE_VRTC_CONNECT_FAILURE = "vrtc_connect_failure";
    /**
     * 房间消息 互动消息 用户上麦
     */
    public static final String MESSAGE_VRTC_CONNECT_SUCCESS = "vrtc_connect_success";
    /**
     * 房间消息 互动消息 互动连麦连接邀请拒绝
     */
    public static final String MESSAGE_VRTC_CONNECT_INVITE_REFUSED = "vrtc_connect_invite_refused";
    /**
     * 房间消息 互动消息 用户取消上麦申请
     */
    public static final String MESSAGE_VRTC_CONNECT_APPLY_CANCEL = "vrtc_connect_apply_cancel";
    /**
     * 房间消息 互动消息 用户上麦申请
     */
    public static final String MESSAGE_VRTC_CONNECT_APPLY = "vrtc_connect_apply";
    /**
     * 房间消息 互动消息 互动设置主讲人
     */
    public static final String MESSAGE_VRTC_SPEAKER_SWITCH = "vrtc_speaker_switch";
    /**
     * 房间消息 互动消息 互动设置观看端布局
     */
    public static final String MESSAGE_VRTC_LAYOUT_SET = "vrtc_layout_set";
    /**
     * 房间消息 互动消息 互动设置发起端清晰度
     */
    public static final String MESSAGE_VRTC_DEFINITION_SET = "vrtc_definition_set";
    /**
     * 房间消息 互动消息 互动连麦断开连接检查
     */
    public static final String MESSAGE_VRTC_DISCONNECT_CHECK = "vrtc_disconnect_check";

    /**
     * 房间消息 互动消息 互动连麦断开连接申请
     */
    public static final String MESSAGE_vrtc_disconnect_apply = "vrtc_disconnect_apply";
    /**
     * 房间消息 互动消息 互动连麦断开连接同意
     */
    public static final String MESSAGE_vrtc_disconnect_agree = "vrtc_disconnect_agree";
    /**
     * 房间消息 互动消息 互动连麦断开连接拒绝
     */
    public static final String MESSAGE_vrtc_disconnect_refused = "vrtc_disconnect_refused";
    /**
     * 房间消息 互动消息 互动连麦断开连接失败
     */
    public static final String MESSAGE_vrtc_disconnect_failure = "vrtc_disconnect_failure";
    /**
     * 房间消息 互动消息 互动连麦断开连接失败
     */
    public static final String MESSAGE_VRTC_CONNECT_INVITE_AGREE = "vrtc_connect_invite_agree";


    /**
     * 房间消息 流消息 静音某路流
     */
    public static final String MESSAGE_VRTC_MUTE = "vrtc_mute";
    /**
     * 房间消息 流消息 全体静音
     */
    public static final String MESSAGE_VRTC_MUTE_ALL = "vrtc_mute_all";
    /**
     * 房间消息 流消息 取消静音某路流
     */
    public static final String MESSAGE_VRTC_MUTE_CANCEL = "vrtc_mute_cancel";
    /**
     * 房间消息 流消息 取消全体静音
     */
    public static final String MESSAGE_VRTC_MUTE_ALL_CANCEL = "vrtc_mute_all_cancel";
    /**
     * 房间消息 流消息 禁止显示某路流的画面
     */
    public static final String MESSAGE_VRTC_FRAMES_FORBID = "vrtc_frames_forbid";
    /**
     * 房间消息 流消息 显示某路流的画面
     */
    public static final String MESSAGE_VRTC_FRAMES_DISPLAY = "vrtc_frames_display";

    /**
     * 房间消息 流消息 互动流开始排麦
     */
    public static final String MESSAGE_VRTC_SORT_START = "vrtc_sort_start";
    /**
     * 房间消息 流消息 互动流停止排麦
     */
    public static final String MESSAGE_VRTC_SORT_STOP = "vrtc_sort_stop";
    /**
     * 房间消息 流消息 互动流申请排麦
     */
    public static final String MESSAGE_VRTC_SORT_APPLY = "vrtc_sort_apply";
    /**
     * 房间消息 流消息 互动流用户离线5s之后从排麦队列清除
     */
    public static final String MESSAGE_VRTC_SORT_USER_CLEAR = "vrtc_sort_user_clear";
    /**
     * 房间消息 流消息 互动流设置混流大画面
     */
    public static final String MESSAGE_VRTC_BIG_SCREEN_SET = "vrtc_big_screen_set";

    /**
     * 房间消息 抽奖 发起抽奖
     */
    public static final String MESSAGE_LOTTERY_PUSH = "lottery_push";
    /**
     * 房间消息 抽奖 参加抽奖
     */
    public static final String MESSAGE_LOTTERY_SUBMIT = "lottery_submit";
    /**
     * 房间消息 抽奖 抽奖结果通知
     */
    public static final String MESSAGE_LOTTERY_RESULT_NOTICE = "lottery_result_notice";

    /**
     * 房间消息 签到 开始签到 	发起签到
     */
    public static final String MESSAGE_SIGN_IN_PUSH = "sign_in_push";
    /**
     * 房间消息 签到结束
     */
    public static final String MESSAGE_SIGN_END = "sign_end";
    /**
     * 房间消息 签到 提交签到
     */
    public static final String MESSAGE_SIGN_IN_SUBMIT = "sign_in_submit";

    /**
     * 房间消息 问答 开启问答
     */
    public static final String MESSAGE_QUESTION_ANSWER_OPEN = "question_answer_open";
    /**
     * 房间消息 问答 回复问答
     */
    public static final String MESSAGE_QUESTION_ANSWER_COMMIT = "question_answer_commit";
    /**
     * 房间消息 问答 问答创建
     */
    public static final String MESSAGE_QUESTION_ANSWER_CREATE = "question_answer_create";
    /**
     * 房间消息 问答 提交答案
     */
    public static final String MESSAGE_QUESTION_ANSWER_SUBMIT = "question_answer_submit";
    /**
     * 房间消息 问答 关闭问答
     */
    public static final String MESSAGE_QUESTION_ANSWER_CLOSE = "question_answer_close";
    /**
     * 房间消息 问答 撤销答案
     */
    public static final String MESSAGE_QUESTION_ANSWER_BACKOUT = "question_answer_backout";

    /**
     * 房间消息 问卷发布
     */
    public static final String MESSAGE_QUESTIONNAIRE_PUSH = "questionnaire_push";

    /**
     * 房间消息 问卷提交
     */
    public static final String MESSAGE_QUESTIONANSWER_PUSH = "questionanswer_push";
    /**
     * 房间消息 问卷发布
     */
    public static final String MESSAGE_QUESTIONNAIRE_REPUSH = "questionnaire_repush";

    /**
     * 房间消息 文档 设置开启学生画笔
     */
    public static final String MESSAGE_DOC_BRUSH_OPEN = "doc_brush_open";
    /**
     * 房间消息 文档 设置关闭学生画笔
     */
    public static final String MESSAGE_DOC_BRUSH_DISABLE = "doc_brush_disable";
    /**
     * 房间消息 文档 文档转换jpeg通知
     */
    public static final String MESSAGE_DOC_CONVERT_JPEG = "doc_convert_jpeg";
    /**
     * 房间消息 文档 文档转换通知
     */
    public static final String MESSAGE_DOC_CONVERT = "doc_convert";


    /**
     * 转播  开始转播
     */
    public static final String MESSAGE_LIVE_BROADCAST_START = "live_broadcast_start";
    /**
     * 转播  停止转播
     */
    public static final String MESSAGE_LIVE_BROADCAST_STOP = "live_broadcast_stop";
    /**
     * 转播  开启转播功能
     */
    public static final String MESSAGE_LIVE_BROADCAST_ON = "live_broadcast_on";
    /**
     * 转播  关闭转播功能
     */
    public static final String MESSAGE_LIVE_BROADCAST_OFF = "live_broadcast_off";

    /**
     * 插播  插播开始
     */
    public static final String MESSAGE_VOD_INSERT_START = "vod_insert_start";
    /**
     * 插播  插播暂停
     */
    public static final String MESSAGE_VOD_INSERT_PAUSE = "vod_insert_pause";
    /**
     * 插播  插播停止
     */
    public static final String MESSAGE_VOD_INSERT_STOP = "vod_insert_stop";
    /**
     * 插播  插播进度同步
     */
    public static final String MESSAGE_VOD_INSERT_PROGRESS_RATE_SYNC = "vod_insert_progress_rate_sync";

    /**
     * 礼物  赠送礼物成功
     */
    public static final String MESSAGE_GIFT_SEND_SUCCESS = "gift_send_success";

    /**
     * 打赏  打赏成功
     */
    public static final String MESSAGE_REWARD_PAY_SUCCESS = "reward_pay_success";

    /**
     * 红包 发红包
     */
    public static final String MESSAGE_RED_ENVELOPE_PUSH = "red_envelope_push";
    /**
     * 红包 抢红包成功
     */
    public static final String MESSAGE_RED_ENVELOPE_OPEN_SUCCESS = "red_envelope_open_success";

    /**
     * 支付 支付成功通知
     */
    public static final String MESSAGE_PAY_SUCCESS = "pay_success";

    /**
     * 桌面共享 开启桌面共享
     */
    public static final String MESSAGE_DESKTOP_SHARING_OPEN = "desktop_sharing_open";
    /**
     * 桌面共享 关闭桌面共享
     */
    public static final String MESSAGE_DESKTOP_SHARING_DISABLE = "desktop_sharing_disable";

    /**
     * 点播 点播转码
     */
    public static final String MESSAGE_VOD_TRANSCODINGN = "vod_transcoding";
    /**
     * 点播 点播下载
     */
    public static final String MESSAGE_VOD_DOWNLOAD = "vod_download";

    /**
     * 其他 操作回调
     */
    public static final String MESSAGE_OPERATE_CALLBACK = "operate_callback";

    /**
     * 其他 修改角色信息
     */
    public static final String MESSAGE_EDIT_WEBINAR_ROLE_NAME = "edit_webinar_role_name";
    /**
     * 其他 修改问答
     */
    public static final String MESSAGE_QUESTION_ANSWER_SET = "question_answer_set";

    /**
     * 云导播流状态
     */
    public static final String MESSAGE_DIRECTOR_STREAM = "director_stream";

    /**
     * 轮巡开始
     */
    public static final String MESSAGE_VIDEO_ROUND_START = "video_round_start";

    /**
     * 轮巡结束
     */
    public static final String MESSAGE_VIDEO_ROUND_END = "video_round_end";

    /**
     * 轮巡用户
     */
    public static final String MESSAGE_VIDEO_ROUND_USERS = "video_round_users";

    /**
     * 计时器开始
     */
    public static final String MESSAGE_TIMER_START = "timer_start";

    /**
     * 计时器 重置
     */
    public static final String MESSAGE_TIMER_RESET = "timer_reset";

    /**
     * 计时器 结束
     */
    public static final String MESSAGE_TIMER_END = "timer_end";

    /**
     * 计时器 暂停
     */
    public static final String MESSAGE_TIMER_PAUSE = "timer_pause";

    /**
     * 计时器 继续
     */
    public static final String MESSAGE_TIMER_RESUME = "timer_resume";
    /**
     * 点赞
     */
    public static final String MESSAGE_CUSTOM_PRAISE_TOTAL = "customPraiseTotal";

    /**
     * 虚拟人数更新
     */
    public static final String MESSAGE_BASE_NUM_UPDATE = "base_num_update";

    /**
     * 彩排开始消息
     */
    public static final String MESSAGE_LIVE_START_REHEARSAL = "live_start_rehearsal";

    /**
     * 彩排结束消息
     */
    public static final String MESSAGE_LIVE_OVER_REHEARSAL = "live_over_rehearsal";

    /**
     * 发送直播答题
     */
    public static final String MESSAGE_PAPER_SEND = "paper_send";
    /**
     * 直播答题-收卷
     */
    public static final String MESSAGE_PAPER_END = "paper_end";
    /**
     * 直播答题-自动收卷
     */
    public static final String MESSAGE_PAPER_AUTO_END = "paper_auto_end";
    /**
     * 直播答题公布成绩
     */
    public static final String MESSAGE_PAPER_SEND_RANK = "paper_send_rank";
    /**
     * 直播答题自动公布成绩
     */
    public static final String MESSAGE_PAPER_AUTO_SEND_RANK= "paper_auto_send_rank";
    /**
     * 聊天删除消息
     */
    public static final String MESSAGE_CHAT_DELETE= "chat_delete";
    /**
     * 文件下载菜单更新
     */
    public static final String MESSAGE_DATA_DOWNLOAD_UPDATE= "data_download_update";
    /**
     * 推屏卡片
     */
    public static final String MESSAGE_PUSH_SCREEN_CRAD= "push_screen_card";
    /**
     * 删除推屏卡片
     */
    public static final String MESSAGE_PUSH_SCREEN_CRAD_DELETE= "push_screen_card_delete";
    /**
     * 删除推屏卡片
     */
    public static final String MESSAGE_PUSH_SCREEN_CRAD_UPDATE= "push_screen_card_update";
    /**
     * 商品推屏
     */
    public static final String MESSAGE_PUSH_GOODS_CARD= "push_goods_change";
    /**
     * 修改商品信息
     */
    public static final String MESSAGE_GOOD_UPDATE_INFO= "goods_update_info";
    /**
     * 订单状态
     */
    public static final String MESSAGE_GOOD_ORFER_STATUS= "order_status_change";

}
