package vhall.com.vss2.module.lottery;

import android.text.TextUtils;
import android.util.Log;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.logmanager.VLog;

import java.util.HashMap;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
public class VssLotteryManager extends BasePresenter {
    private volatile static VssLotteryManager instance;
    private static String TAG = "VssLotteryManager";

    public static VssLotteryManager getInstance() {
        if (roomInfo == null) {
            VLog.e(TAG, "room data error");
        }
        if (instance == null) {
            synchronized (VssLotteryManager.class) {
                if (instance == null) {
                    instance = new VssLotteryManager();
                }
            }
        }
        return instance;
    }


    /**
     * 抽奖 发起抽奖
     */
    public void lotteryAdd(String lottery_type, String lottery_number, String lottery_user_ids, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        params.put(VssApiConstant.KEY_LOTTERY_TYPE, lottery_type);
        params.put(VssApiConstant.KEY_LOTTERY_NUMBER, lottery_number);
        params.put(VssApiConstant.KEY_LOTTERY_USER_IDS, lottery_user_ids);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_ADD)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 结束抽奖
     */
    public void lotteryEnd(String lottery_id, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_LOTTERY_ID, lottery_id);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_END)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 获取抽奖中奖人名单
     */
    public void lotteryUsersGet(String lottery_id, String offset, String limit, String sort_type, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 6);
        params.put(VssApiConstant.KEY_LOTTERY_ID, lottery_id);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_USERS_GET)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 获取抽奖列表
     */
    public void lotteryGet(String lottery_type, String offset, String limit, String sort_type, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 6);
        params.put(VssApiConstant.KEY_LOTTERY_TYPE, lottery_type);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_GET)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 领奖信息更新
     */
    public void lotteryAward(String lottery_id, String lottery_user_name, String lottery_user_phone, String lottery_user_remark, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 6);
        params.put(VssApiConstant.KEY_LOTTERY_ID, lottery_id);
        params.put("lottery_user_name", lottery_user_name);
        params.put("lottery_user_phone", lottery_user_phone);
        if (!TextUtils.isEmpty(lottery_user_remark)) {
            params.put("lottery_user_remark", lottery_user_remark);
        }

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_AWARD)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 根据抽奖中奖范围获取可以参加抽奖的人数
     */
    public void lotteryCount(String lottery_type, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_LOTTERY_TYPE, lottery_type);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_COUNT)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 抽奖 搜索符合范围条件的抽奖用户名单
     */
    public void lotterySearch(String lottery_type,String keyword, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_KEYWORD, keyword);
        params.put(VssApiConstant.KEY_LOTTERY_TYPE, lottery_type);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_LOTTERY_SEARCH)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }


}
