package vhall.com.vss2.module.chat;

import android.text.TextUtils;
import android.util.Log;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.logmanager.VLog;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseGetUserStateList;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.VHJSON;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
public class VssChatManager extends BasePresenter {
    private volatile static VssChatManager instance;
    private static String TAG = "VssChatManager";

    public static VssChatManager getInstance() {
        if (roomInfo == null) {
            VLog.e(TAG, "room data error");
        }
        if (instance == null) {
            synchronized (VssChatManager.class) {
                if (instance == null) {
                    instance = new VssChatManager();
                }
            }
        }
        return instance;
    }


    /**
     * 聊天
     * VSS 组件使用
     * 聊天历史信息列表
     */
    public void chatLists(String currPage, String pageSize, String startTime, CallBack<List<ResponseChatInfo>> callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);

        if (!TextUtils.isEmpty(currPage)) {
            params.put("curr_page", currPage);
        }
        if (!TextUtils.isEmpty(startTime)) {
            params.put("start_time", startTime);
        }
        if (!TextUtils.isEmpty(pageSize)) {
            params.put("page_size", pageSize);
        }

        //构造参数
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_CHAT_LIST)).build();

        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callback, new ArrayList<ResponseChatInfo>() {
        }.getClass()));
    }

    /**
     * 聊天
     * SaaS SDK 使用
     * 聊天历史信息列表
     */
    public void chatList(String currPage, String pageSize, String startTime, final CallBack<List<ResponseChatInfo>> callback) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);

        if (!TextUtils.isEmpty(currPage)) {
            params.put("curr_page", currPage);
        }
        if (!TextUtils.isEmpty(startTime)) {
            params.put("start_time", startTime);
        }
        if (!TextUtils.isEmpty(pageSize)) {
            params.put("page_size", pageSize);
        }

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_CHAT_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new IVHNetCallback() {
            @Override
            public void onFailure(VHNetResponse response, Exception e) {
                dealError(e, callback, TAG);
            }

            @Override
            public void response(VHNetResponse response) {
                if (callback != null) {
                    List<ResponseChatInfo> s = VHJSON.parseObject(response.getResult(), new ArrayList<ResponseChatInfo>() {
                    }.getClass());
                    for (ResponseChatInfo info : s) {
                        String contentText = info.getData().getText_content();
                        if (info.getContext().getAtList() != null && info.getContext().getAtList().size() > 0) {
                            for (ResponseChatInfo.ContextBean.AtListBean bean : info.getContext().getAtList()) {
                                contentText = contentText.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                            }
                            info.getData().setText_content(contentText);
                        }
                    }
                    callback.onSuccess(s);
                }
            }
        });
    }

    /**
     * 获取禁言用户列表
     */
    public void getBannedList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatOperateList()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有获取成员列表权限");
            }
            VLog.e(TAG, "没有获取成员列表权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);
        params.put(VssApiConstant.KEY_PAGE, page);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_GET_BANNED_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack,ResponseGetUserStateList.class));

    }

    /**
     * 获取踢出用户列表
     */
    public void getKickedList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatOperateList()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有获取成员列表权限");
            }
            VLog.e(TAG, "没有获取成员列表权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);
        params.put(VssApiConstant.KEY_PAGE, page);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_GET_KICKED_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack,ResponseGetUserStateList.class));
    }

    /**
     * 获取在线用户列表
     */
    public void getOnlineList(String nickname, String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatMemberList()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有获取成员列表权限");
            }
            VLog.e(TAG, "没有获取成员列表权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);
        params.put(VssApiConstant.KEY_PAGE, page);
        params.put(VssApiConstant.KEY_NICKNAME, nickname);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_GET_ONLINE_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack,ResponseGetUserStateList.class));

    }

    /**
     * 获取特殊用户列表
     */
    public void getSpecialList(String pageSize, String page, CallBack<ResponseGetUserStateList> callBack) {
        if (!VssRoleManager.getInstance().canChatMemberList()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有获取成员列表权限");
            }
            VLog.e(TAG, "没有获取成员列表权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);
        params.put(VssApiConstant.KEY_PAGE, page);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_GET_SPECIAL_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack,ResponseGetUserStateList.class));

    }

    /**
     * 聊天 图片上传
     */
    public void chatImageUpload(File file, CallBack<String> callback) {
        if (file == null) {
            callback.onError(-1, "file is  null");
            return;
        }
        if (TextUtils.isEmpty(VssApiConstant.KEY_VSS_TOKEN)) {
            if (callback != null) {
                callback.onError(-1, "vssToken 不能为空");
            }
            return;
        }

        RequestBody fileBody = RequestBody.create(MediaType.parse("image/"), file);
        MultipartBody requestBody = new MultipartBody.Builder()
                .setType(MultipartBody.FORM)
                .addFormDataPart("file", file.getName(), fileBody)
                .addFormDataPart(VssApiConstant.KEY_VSS_TOKEN, vssToken)
                .addFormDataPart(VssApiConstant.KEY_APP_ID, VssSdk.getInstance().getAppId())
                .addFormDataPart("from", "android_app")
                .build();

    }

}
