package vhall.com.vss2.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 用户发的的签到 的列表
 * Date: 2019-11-22 13:55
 */
public class ResponseSignListUser implements Serializable {


    /**
     * sort_type : asc
     * bu : 1
     * offset : 0
     * creator_id : 700
     * limit : 500
     * count : 1
     * source_id : lss_5eb02174
     * list : [{"show_time":"30","bu":"1","deleted":"0","creator_id":"700","created_at":"2019-11-22 13:54:15","id":"14756","creator_avatar":"","source_id":"lss_5eb02174","app_id":"af314787","creator_nickname":"thh"}]
     * app_id : af314787
     */
    private String sort_type;
    private String bu;
    private int offset;
    private String creator_id;
    private String limit;
    private int count;
    private String source_id;
    private String app_id;
    private List<ListBean> list;

    public ResponseSignListUser(JSONObject object) {

        this.sort_type = object.optString("sort_type");
        this.bu = object.optString("bu");
        this.offset = object.optInt("offset");
        this.creator_id = object.optString("creator_id");
        this.limit = object.optString("limit");
        this.count = object.optInt("count");
        this.source_id = object.optString("source_id");
        this.app_id = object.optString("app_id");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public String getSort_type() {
        return this.sort_type;
    }

    public String getBu() {
        return this.bu;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getCreator_id() {
        return this.creator_id;
    }

    public String getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String getSource_id() {
        return this.source_id;
    }

    public String getApp_id() {
        return this.app_id;
    }

    public List<ListBean> getList() {
        return this.list;
    }

    public void setSort_type(String sort_type) {
        this.sort_type = sort_type;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setCreator_id(String creator_id) {
        this.creator_id = creator_id;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setSource_id(String source_id) {
        this.source_id = source_id;
    }

    public void setApp_id(String app_id) {
        this.app_id = app_id;
    }

    public void setList(List<ListBean> list) {
        this.list = list;
    }

    public static class ListBean {
        private String sign_id;
        private String signer_id;
        private String signer_nickname;
        private String signer_avatar;
        private String bu;
        private String deleted;
        private String deleted_at;
        private String creator_id;
        private String created_at;
        private String id;
        private String creator_avatar;
        private String source_id;
        private String app_id;
        private String creator_nickname;

        public ListBean(JSONObject object) {

            this.sign_id = object.optString("sign_id");
            this.signer_id = object.optString("signer_id");
            this.signer_nickname = object.optString("signer_nickname");
            this.signer_avatar = object.optString("signer_avatar");
            this.bu = object.optString("bu");
            this.deleted = object.optString("deleted");
            this.deleted_at = object.optString("deleted_at");
            this.creator_id = object.optString("creator_id");
            this.created_at = object.optString("created_at");
            this.id = object.optString("id");
            this.creator_avatar = object.optString("creator_avatar");
            this.source_id = object.optString("source_id");
            this.app_id = object.optString("app_id");
            this.creator_nickname = object.optString("creator_nickname");
        }

        public String getSign_id() {
            return this.sign_id;
        }

        public String getSigner_id() {
            return this.signer_id;
        }

        public String getSigner_nickname() {
            return this.signer_nickname;
        }

        public String getSigner_avatar() {
            return this.signer_avatar;
        }

        public String getBu() {
            return this.bu;
        }

        public String getDeleted() {
            return this.deleted;
        }

        public String getDeleted_at() {
            return this.deleted_at;
        }

        public String getCreator_id() {
            return this.creator_id;
        }

        public String getCreated_at() {
            return this.created_at;
        }

        public String getId() {
            return this.id;
        }

        public String getCreator_avatar() {
            return this.creator_avatar;
        }

        public String getSource_id() {
            return this.source_id;
        }

        public String getApp_id() {
            return this.app_id;
        }

        public String getCreator_nickname() {
            return this.creator_nickname;
        }

        public void setSign_id(String sign_id) {
            this.sign_id = sign_id;
        }

        public void setSigner_id(String signer_id) {
            this.signer_id = signer_id;
        }

        public void setSigner_nickname(String signer_nickname) {
            this.signer_nickname = signer_nickname;
        }

        public void setSigner_avatar(String signer_avatar) {
            this.signer_avatar = signer_avatar;
        }

        public void setBu(String bu) {
            this.bu = bu;
        }

        public void setDeleted(String deleted) {
            this.deleted = deleted;
        }

        public void setDeleted_at(String deleted_at) {
            this.deleted_at = deleted_at;
        }

        public void setCreator_id(String creator_id) {
            this.creator_id = creator_id;
        }

        public void setCreated_at(String created_at) {
            this.created_at = created_at;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setCreator_avatar(String creator_avatar) {
            this.creator_avatar = creator_avatar;
        }

        public void setSource_id(String source_id) {
            this.source_id = source_id;
        }

        public void setApp_id(String app_id) {
            this.app_id = app_id;
        }

        public void setCreator_nickname(String creator_nickname) {
            this.creator_nickname = creator_nickname;
        }
    }
}
