package vhall.com.vss2.data;


import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 获取禁言列表/获取踢出用户列表/获取在线用户列表/获取特殊用户列表
 */
public class ResponseGetUserStateList implements Serializable {
    /**
     * total : 0
     * page : 15
     * pagesize : 1
     * list : []
     */

    private int total;
    private int page;
    private String pagesize;
    private List<DataBeen> list;

    public ResponseGetUserStateList(JSONObject object) {

        this.total = object.optInt("total");
        this.page = object.optInt("page");
        this.pagesize = object.optString("pagesize");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new DataBeen(listArray.optJSONObject(i)));
            }
        }
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getPagesize() {
        return pagesize;
    }

    public void setPagesize(String pagesize) {
        this.pagesize = pagesize;
    }

    public List<DataBeen> getList() {
        return list;
    }

    public void setList(List<DataBeen> list) {
        this.list = list;
    }

    public class DataBeen implements Serializable {

        //是否禁言，1是0否
        //是否踢出，1是0否

        private String join_id;
        private String nickname;
        private String is_banned;
        private String is_kick;
        private String role_name;
        private String avatar;
        private String device_type;
        private String device_status;

        public DataBeen(JSONObject object) {

            this.join_id = object.optString("join_id");
            this.nickname = object.optString("nickname");
            this.is_banned = object.optString("is_banned");
            this.is_kick = object.optString("is_kick");
            this.role_name = object.optString("role_name");
            this.avatar = object.optString("avatar");
            this.device_type = object.optString("device_type");
            this.device_status = object.optString("device_status");
        }

        public String getJoin_id() {
            return join_id;
        }

        public void setJoin_id(String join_id) {
            this.join_id = join_id;
        }

        public String getNickname() {
            return nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getIs_banned() {
            return is_banned;
        }

        public void setIs_banned(String is_banned) {
            this.is_banned = is_banned;
        }

        public String getIs_kick() {
            return is_kick;
        }

        public void setIs_kick(String is_kick) {
            this.is_kick = is_kick;
        }

        public String getRole_name() {
            return role_name;
        }

        public void setRole_name(String role_name) {
            this.role_name = role_name;
        }

        public String getAvatar() {
            return avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getDevice_type() {
            return device_type;
        }

        public void setDevice_type(String device_type) {
            this.device_type = device_type;
        }

        public String getDevice_status() {
            return device_status;
        }

        public void setDevice_status(String device_status) {
            this.device_status = device_status;
        }
    }
}
